/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class FhirIOTestUtil {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_TEMP_BUCKET = "temp-storage-for-healthcare-io-tests";
    static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> DSTU2_PRETTY_BUNDLES = FhirIOTestUtil.readPrettyBundles("DSTU2").collect(Collectors.toList());
    static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> STU3_PRETTY_BUNDLES = FhirIOTestUtil.readPrettyBundles("STU3").collect(Collectors.toList());
    static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> R4_PRETTY_BUNDLES = FhirIOTestUtil.readPrettyBundles("R4").collect(Collectors.toList());
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> BUNDLES;

    FhirIOTestUtil() {
    }

    private static @UnknownKeyFor @NonNull @Initialized Stream<@UnknownKeyFor @NonNull @Initialized String> readPrettyBundles(@UnknownKeyFor @NonNull @Initialized String version) {
        ClassLoader classLoader = FhirIOTestUtil.class.getClassLoader();
        Path resourceDir = Paths.get("build", "resources", "test", version);
        String absolutePath = resourceDir.toFile().getAbsolutePath();
        File dir = new File(absolutePath);
        File[] fhirJsons = dir.listFiles();
        return Arrays.stream(fhirJsons).map(File::toPath).map(path -> {
            try {
                return Files.readAllBytes(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).map(String::new);
    }

    static void executeFhirBundles(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> bundles) throws @UnknownKeyFor @NonNull @Initialized IOException, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized HttpHealthcareApiClient.HealthcareHttpException {
        for (String bundle : bundles) {
            client.executeFhirBundle(fhirStore, bundle);
        }
    }

    public static void tearDownTempBucket() throws @UnknownKeyFor @NonNull @Initialized IOException {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
        HttpRequestInitializer requestInitializer = request -> {
            Map credentialHeaders;
            HttpHeaders requestHeaders = request.getHeaders();
            if (!credentials.hasRequestMetadata()) {
                return;
            }
            URI uri = null;
            if (request.getUrl() != null) {
                uri = request.getUrl().toURI();
            }
            if ((credentialHeaders = credentials.getRequestMetadata(uri)) == null) {
                return;
            }
            for (Map.Entry entry : credentialHeaders.entrySet()) {
                String headerName = (String)entry.getKey();
                ArrayList requestValues = new ArrayList((Collection)entry.getValue());
                requestHeaders.put(headerName, requestValues);
            }
            request.setConnectTimeout(60000);
            request.setReadTimeout(60000);
        };
        Storage storage = new Storage.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), requestInitializer).build();
        List blobs = ((Objects)storage.objects().list(DEFAULT_TEMP_BUCKET).execute()).getItems();
        if (blobs != null) {
            for (StorageObject blob : blobs) {
                storage.objects().delete(DEFAULT_TEMP_BUCKET, blob.getId());
            }
        }
    }

    static {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        m.put("DSTU2", DSTU2_PRETTY_BUNDLES);
        m.put("STU3", STU3_PRETTY_BUNDLES);
        m.put("R4", R4_PRETTY_BUNDLES);
        BUNDLES = Collections.unmodifiableMap(m);
    }
}

