/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Validation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface FhirIOTestOptions
extends HealthcareStoreTestPipelineOptions {
    @Description(value="FHIR store should match the pattern: projects/PROJECT_ID/locations/LOCATION/datasets/DATASET_ID/fhirStores/HL7V2_STORE_ID")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getFhirStore();

    public void setFhirStore(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="GCS temp path for import should be of the form gs://bucket/path/")
    @Default.String(value="gs://temp-storage-for-healthcare-io-tests/FhirIOWriteIT/temp/")
    public @UnknownKeyFor @NonNull @Initialized String getGcsTempPath();

    public void setGcsTempPath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="GCS dead letter path for import should be of the form gs://bucket/path/")
    public @UnknownKeyFor @NonNull @Initialized String getGcsDeadLetterPath();

    public void setGcsDeadLetterPath(@UnknownKeyFor @NonNull @Initialized String var1);
}

