/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FhirIOTest {
    @Rule
    public final transient @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();
    private static final @UnknownKeyFor @NonNull @Initialized long NUM_ELEMENTS = 11L;

    @Test
    public void test_FhirIO_failedReads() {
        List<String> badMessageIDs = Arrays.asList("foo", "bar");
        FhirIO.Read.Result readResult = (FhirIO.Read.Result)((PCollection)this.pipeline.apply((PTransform)Create.of(badMessageIDs))).apply((PTransform)FhirIO.readResources());
        PCollection failed = readResult.getFailedReads();
        PCollection resources = readResult.getResources();
        PCollection failedMsgIds = (PCollection)failed.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(HealthcareIOError::getDataResource));
        PAssert.that((PCollection)failedMsgIds).containsInAnyOrder(badMessageIDs);
        PAssert.that((PCollection)resources).empty();
        this.pipeline.run();
    }

    @Test
    public void test_FhirIO_failedSearches() {
        List<KV> input = Arrays.asList(KV.of((Object)"resource-type-1", null));
        FhirIO.Search.Result searchResult = (FhirIO.Search.Result)((PCollection)this.pipeline.apply((PTransform)Create.of(input))).apply((PTransform)FhirIO.searchResources((String)"bad-store"));
        PCollection failed = searchResult.getFailedSearches();
        PCollection resources = searchResult.getResources();
        PCollection failedMsgIds = (PCollection)failed.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(HealthcareIOError::getDataResource));
        PAssert.that((PCollection)failedMsgIds).containsInAnyOrder(Arrays.asList("bad-store"));
        PAssert.that((PCollection)resources).empty();
        this.pipeline.run();
    }

    @Test
    public void test_FhirIO_failedWrites() {
        String badBundle = "bad";
        List<String> emptyMessages = Collections.singletonList(badBundle);
        PCollection fhirBundles = (PCollection)this.pipeline.apply((PTransform)Create.of(emptyMessages));
        FhirIO.Write.Result writeResult = (FhirIO.Write.Result)fhirBundles.apply((PTransform)FhirIO.Write.executeBundles((String)"projects/foo/locations/us-central1/datasets/bar/hl7V2Stores/baz"));
        PCollection failedInserts = writeResult.getFailedBodies();
        PAssert.thatSingleton((PCollection)failedInserts).satisfies((SerializableFunction & Serializable)err -> {
            Assert.assertEquals((Object)"bad", (Object)err.getDataResource());
            return null;
        });
        PCollection numFailedInserts = (PCollection)failedInserts.apply(Count.globally());
        PAssert.thatSingleton((PCollection)numFailedInserts).isEqualTo((Object)1L);
        this.pipeline.run();
    }

    private static @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> createTestData() {
        String[] scientists = new String[]{"Einstein", "Darwin", "Copernicus", "Pasteur", "Curie", "Faraday", "Newton", "Bohr", "Galilei", "Maxwell"};
        ArrayList<KV<String, String>> data = new ArrayList<KV<String, String>>();
        int i = 0;
        while ((long)i < 11L) {
            int index = i % scientists.length;
            KV element = KV.of((Object)"key", (Object)scientists[index]);
            data.add((KV<String, String>)element);
            ++i;
        }
        return data;
    }
}

