/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.direct.DirectOptions;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FhirIOSearchIT {
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();
    private final @UnknownKeyFor @NonNull @Initialized String project;
    private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
    private static @UnknownKeyFor @NonNull @Initialized String healthcareDataset;
    private static final @UnknownKeyFor @NonNull @Initialized String BASE_STORE_ID;
    private @UnknownKeyFor @NonNull @Initialized String fhirStoreId;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_NUM_OF_SEARCHES = 100;
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>>> input = new ArrayList<KV<String, Map<String, String>>>();
    public @UnknownKeyFor @NonNull @Initialized String version;

    @Parameterized.Parameters(name="{0}")
    public static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> versions() {
        return Arrays.asList("R4");
    }

    public FhirIOSearchIT(@UnknownKeyFor @NonNull @Initialized String version) {
        this.version = version;
        this.fhirStoreId = BASE_STORE_ID + version;
        this.project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
    }

    @Before
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", this.project);
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        this.client.createFhirStore(healthcareDataset, this.fhirStoreId, this.version, "");
        List<String> bundles = FhirIOTestUtil.BUNDLES.get(this.version);
        FhirIOTestUtil.executeFhirBundles(this.client, healthcareDataset + "/fhirStores/" + this.fhirStoreId, bundles);
        JsonArray fhirResources = JsonParser.parseString((String)bundles.get(0)).getAsJsonObject().getAsJsonArray("entry");
        HashMap<String, String> searchParameters = new HashMap<String, String>();
        searchParameters.put("_count", Integer.toString(100));
        int searches = 0;
        for (JsonElement resource : fhirResources) {
            this.input.add((KV<String, Map<String, String>>)KV.of((Object)resource.getAsJsonObject().getAsJsonObject("resource").get("resourceType").getAsString(), searchParameters));
            if (++searches <= 100) continue;
            break;
        }
    }

    @AfterClass
    public static void teardown() throws @UnknownKeyFor @NonNull @Initialized IOException {
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        for (String version : FhirIOSearchIT.versions()) {
            client.deleteFhirStore(healthcareDataset + "/fhirStores/" + BASE_STORE_ID + version);
        }
    }

    @Test
    public void testFhirIOSearch() {
        ((DirectOptions)this.pipeline.getOptions().as(DirectOptions.class)).setBlockOnRun(false);
        PCollection searchConfigs = (PCollection)this.pipeline.apply((PTransform)Create.of(this.input).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()))));
        FhirIO.Search.Result result = (FhirIO.Search.Result)searchConfigs.apply((PTransform)FhirIO.searchResources((String)(healthcareDataset + "/fhirStores/" + this.fhirStoreId)));
        PAssert.that((PCollection)result.getFailedSearches()).empty();
        PCollection resources = result.getResources();
        PAssert.that((PCollection)resources).satisfies((SerializableFunction & Serializable)input -> {
            for (JsonArray resource : input) {
                Assert.assertNotEquals((long)resource.size(), (long)0L);
            }
            return null;
        });
        this.pipeline.run().waitUntilFinish();
    }

    static {
        BASE_STORE_ID = "FHIR_store_search_it_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
    }
}

