/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.healthcare.v1beta1.model.DeidentifyConfig;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FhirIOLROIT {
    @Rule
    public final transient @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();
    private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
    private final @UnknownKeyFor @NonNull @Initialized String project;
    private @UnknownKeyFor @NonNull @Initialized String healthcareDataset;
    private final @UnknownKeyFor @NonNull @Initialized String fhirStoreId;
    private final @UnknownKeyFor @NonNull @Initialized String deidFhirStoreId;
    private @UnknownKeyFor @NonNull @Initialized String version;

    public FhirIOLROIT() {
        long testTime = System.currentTimeMillis();
        this.fhirStoreId = "FHIR_store_" + testTime + "_" + new SecureRandom().nextInt(32);
        this.deidFhirStoreId = this.fhirStoreId + "_deid";
        this.version = "STU3";
        this.project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
    }

    @Before
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", this.project);
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        this.client.createFhirStore(this.healthcareDataset, this.fhirStoreId, this.version, null);
        this.client.createFhirStore(this.healthcareDataset, this.deidFhirStoreId, this.version, null);
        FhirIOTestUtil.executeFhirBundles(this.client, this.healthcareDataset + "/fhirStores/" + this.fhirStoreId, FhirIOTestUtil.BUNDLES.get(this.version));
    }

    @After
    public void deleteAllFhirStores() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            HttpHealthcareApiClient client = new HttpHealthcareApiClient();
            client.deleteFhirStore(this.healthcareDataset + "/fhirStores/" + this.fhirStoreId);
            client.deleteFhirStore(this.healthcareDataset + "/fhirStores/" + this.deidFhirStoreId);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @AfterClass
    public static void teardownBucket() throws @UnknownKeyFor @NonNull @Initialized IOException {
        FhirIOTestUtil.tearDownTempBucket();
    }

    @Test
    public void test_FhirIO_exportFhirResourcesGcs() {
        String fhirStoreName = this.healthcareDataset + "/fhirStores/" + this.fhirStoreId;
        String exportGcsUriPrefix = "gs://temp-storage-for-healthcare-io-tests/export/" + new SecureRandom().nextInt(32);
        PCollection resources = (PCollection)this.pipeline.apply((PTransform)FhirIO.exportResourcesToGcs((String)fhirStoreName, (String)exportGcsUriPrefix));
        this.pipeline.run();
    }

    @Test
    public void test_FhirIO_deidentify() throws @UnknownKeyFor @NonNull @Initialized IOException {
        String fhirStoreName = this.healthcareDataset + "/fhirStores/" + this.fhirStoreId;
        String destinationFhirStoreName = this.healthcareDataset + "/fhirStores/" + this.deidFhirStoreId;
        DeidentifyConfig deidConfig = new DeidentifyConfig();
        this.pipeline.apply((PTransform)FhirIO.deidentify((String)fhirStoreName, (String)destinationFhirStoreName, (DeidentifyConfig)deidConfig));
        this.pipeline.run();
    }
}

