/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.gcp.healthcare.DicomIO;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class DicomIOReadIT {
    private static final @UnknownKeyFor @NonNull @Initialized String TEST_FILE_PATH = "src/test/resources/DICOM/testDicomFile.dcm";
    private static final @UnknownKeyFor @NonNull @Initialized String TEST_FILE_STUDY_ID = "study_000000000";
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();
    private @UnknownKeyFor @NonNull @Initialized String healthcareDataset;
    private @UnknownKeyFor @NonNull @Initialized String project;
    private @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
    private @UnknownKeyFor @NonNull @Initialized String storeName = "foo";

    @Before
    public void setup() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized URISyntaxException {
        this.project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
        this.healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", this.project);
        this.client = new HttpHealthcareApiClient();
        this.client.createDicomStore(this.healthcareDataset, this.storeName);
        this.client.uploadToDicomStore(this.healthcareDataset + "/dicomStores/" + this.storeName, TEST_FILE_PATH);
    }

    @After
    public void deleteDicomStore() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.client.deleteDicomStore(this.healthcareDataset + "/dicomStores/" + this.storeName);
    }

    @Ignore(value="https://jira.apache.org/jira/browse/BEAM-11376")
    @Test
    public void testDicomMetadataRead() throws @UnknownKeyFor @NonNull @Initialized IOException {
        String webPath = String.format("%s/dicomStores/%s/dicomWeb/studies/%s", this.healthcareDataset, this.storeName, TEST_FILE_STUDY_ID);
        DicomIO.ReadStudyMetadata.Result result = (DicomIO.ReadStudyMetadata.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)webPath, (Object[])new String[0]))).apply((PTransform)DicomIO.readStudyMetadata());
        PAssert.that((PCollection)result.getFailedReads()).empty();
        PAssert.that((PCollection)result.getReadResponse()).satisfies((SerializableFunction & Serializable)input -> {
            for (String resp : input) {
                Assert.assertTrue((boolean)resp.contains(TEST_FILE_STUDY_ID));
            }
            return null;
        });
        PipelineResult job = this.pipeline.run();
        try {
            job.cancel();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

