/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.Entity;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.PropertyFilter;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.datastore.v1.client.DatastoreOptions;
import com.google.protobuf.Int32Value;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.io.gcp.datastore.V1TestOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class V1TestUtil {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(V1TestUtil.class);

    V1TestUtil() {
    }

    static @UnknownKeyFor @NonNull @Initialized Key makeAncestorKey(@Nullable @UnknownKeyFor @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String kind, @UnknownKeyFor @NonNull @Initialized String ancestor) {
        Key.Builder keyBuilder = DatastoreHelper.makeKey((Object[])new Object[]{kind, ancestor});
        if (namespace != null) {
            keyBuilder.getPartitionIdBuilder().setNamespaceId(namespace);
        }
        return keyBuilder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Query makeAncestorKindQuery(@UnknownKeyFor @NonNull @Initialized String kind, @Nullable @UnknownKeyFor @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String ancestor) {
        Query.Builder q = Query.newBuilder();
        q.addKindBuilder().setName(kind);
        q.setFilter(DatastoreHelper.makeFilter((String)"__key__", (PropertyFilter.Operator)PropertyFilter.Operator.HAS_ANCESTOR, (Value.Builder)DatastoreHelper.makeValue((Key)V1TestUtil.makeAncestorKey(namespace, kind, ancestor))));
        return q.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Entity makeEntity(@UnknownKeyFor @NonNull @Initialized Long value, @UnknownKeyFor @NonNull @Initialized Key ancestorKey, @UnknownKeyFor @NonNull @Initialized String kind, @Nullable @UnknownKeyFor @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized int largePropertySize) {
        Entity.Builder entityBuilder = Entity.newBuilder();
        Key.Builder keyBuilder = DatastoreHelper.makeKey((Object[])new Object[]{ancestorKey, kind, UUID.randomUUID().toString()});
        if (namespace != null) {
            keyBuilder.getPartitionIdBuilder().setNamespaceId(namespace);
        }
        entityBuilder.setKey(keyBuilder.build());
        entityBuilder.putProperties("value", DatastoreHelper.makeValue((long)value).build());
        if (largePropertySize > 0) {
            entityBuilder.putProperties("unindexed_value", DatastoreHelper.makeValue((String)new String(new char[largePropertySize]).replace("\u0000", "A")).setExcludeFromIndexes(true).build());
        }
        return entityBuilder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Datastore getDatastore(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized String projectId) {
        Credentials credential = ((GcpOptions)pipelineOptions.as(GcpOptions.class)).getGcpCredential();
        Object initializer = credential != null ? new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), new RetryHttpRequestInitializer()}) : new RetryHttpRequestInitializer();
        DatastoreOptions.Builder builder = new DatastoreOptions.Builder().projectId(projectId).initializer((HttpRequestInitializer)initializer);
        return DatastoreFactory.get().create(builder.build());
    }

    private static @UnknownKeyFor @NonNull @Initialized RunQueryRequest makeRequest(@UnknownKeyFor @NonNull @Initialized Query query, @Nullable @UnknownKeyFor @Initialized String namespace) {
        RunQueryRequest.Builder requestBuilder = RunQueryRequest.newBuilder().setQuery(query);
        if (namespace != null) {
            requestBuilder.getPartitionIdBuilder().setNamespaceId(namespace);
        }
        return requestBuilder.build();
    }

    static void deleteAllEntities(@UnknownKeyFor @NonNull @Initialized V1TestOptions options, @UnknownKeyFor @NonNull @Initialized String project, @UnknownKeyFor @NonNull @Initialized String ancestor) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Datastore datastore = V1TestUtil.getDatastore((PipelineOptions)options, project);
        Query query = V1TestUtil.makeAncestorKindQuery(options.getKind(), options.getNamespace(), ancestor);
        V1TestReader reader = new V1TestReader(datastore, query, options.getNamespace());
        V1TestWriter writer = new V1TestWriter(datastore, new DeleteMutationBuilder());
        long numEntities = 0L;
        while (reader.advance()) {
            Entity entity = reader.getCurrent();
            ++numEntities;
            writer.write(entity);
        }
        writer.close();
        LOG.info("Successfully deleted {} entities", (Object)numEntities);
    }

    static @UnknownKeyFor @NonNull @Initialized long countEntities(@UnknownKeyFor @NonNull @Initialized V1TestOptions options, @UnknownKeyFor @NonNull @Initialized String project, @UnknownKeyFor @NonNull @Initialized String ancestor) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Datastore datastore = V1TestUtil.getDatastore((PipelineOptions)options, project);
        Query query = V1TestUtil.makeAncestorKindQuery(options.getKind(), options.getNamespace(), ancestor);
        V1TestReader reader = new V1TestReader(datastore, query, options.getNamespace());
        long numEntitiesRead = 0L;
        while (reader.advance()) {
            reader.getCurrent();
            ++numEntitiesRead;
        }
        return numEntitiesRead;
    }

    static class V1TestReader {
        private static final @UnknownKeyFor @NonNull @Initialized int QUERY_BATCH_LIMIT = 500;
        private final @UnknownKeyFor @NonNull @Initialized Datastore datastore;
        private final @UnknownKeyFor @NonNull @Initialized Query query;
        private final @Nullable @UnknownKeyFor @Initialized String namespace;
        private @UnknownKeyFor @NonNull @Initialized boolean moreResults;
        private @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized EntityResult> entities;
        private @UnknownKeyFor @NonNull @Initialized QueryResultBatch currentBatch;
        private @UnknownKeyFor @NonNull @Initialized Entity currentEntity;

        V1TestReader(@UnknownKeyFor @NonNull @Initialized Datastore datastore, @UnknownKeyFor @NonNull @Initialized Query query, @Nullable @UnknownKeyFor @Initialized String namespace) {
            this.datastore = datastore;
            this.query = query;
            this.namespace = namespace;
        }

        @UnknownKeyFor @NonNull @Initialized Entity getCurrent() {
            return this.currentEntity;
        }

        @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.entities == null || !this.entities.hasNext() && this.moreResults) {
                try {
                    this.entities = this.getIteratorAndMoveCursor();
                }
                catch (DatastoreException e) {
                    throw new IOException(e);
                }
            }
            if (this.entities == null || !this.entities.hasNext()) {
                this.currentEntity = null;
                return false;
            }
            this.currentEntity = this.entities.next().getEntity();
            return true;
        }

        private @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized EntityResult> getIteratorAndMoveCursor() throws @UnknownKeyFor @NonNull @Initialized DatastoreException {
            Query.Builder query = this.query.toBuilder();
            query.setLimit(Int32Value.newBuilder().setValue(500));
            if (this.currentBatch != null && !this.currentBatch.getEndCursor().isEmpty()) {
                query.setStartCursor(this.currentBatch.getEndCursor());
            }
            RunQueryRequest request = V1TestUtil.makeRequest(query.build(), this.namespace);
            RunQueryResponse response = this.datastore.runQuery(request);
            this.currentBatch = response.getBatch();
            int numFetch = this.currentBatch.getEntityResultsCount();
            boolean bl = this.moreResults = numFetch == 500 || this.currentBatch.getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED;
            if (numFetch == 0) {
                return null;
            }
            return this.currentBatch.getEntityResultsList().iterator();
        }
    }

    static class V1TestWriter {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(V1TestWriter.class);
        private static final @UnknownKeyFor @NonNull @Initialized int DATASTORE_BATCH_UPDATE_LIMIT = 500;
        private static final @UnknownKeyFor @NonNull @Initialized int MAX_RETRIES = 5;
        private static final @UnknownKeyFor @NonNull @Initialized Duration INITIAL_BACKOFF = Duration.standardSeconds((long)5L);
        private final @UnknownKeyFor @NonNull @Initialized Datastore datastore;
        private final @UnknownKeyFor @NonNull @Initialized MutationBuilder mutationBuilder;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Entity> entities = new ArrayList<Entity>();

        static @UnknownKeyFor @NonNull @Initialized boolean isValidKey(@UnknownKeyFor @NonNull @Initialized Key key) {
            List elementList = key.getPathList();
            if (elementList.isEmpty()) {
                return false;
            }
            Key.PathElement lastElement = (Key.PathElement)elementList.get(elementList.size() - 1);
            return lastElement.getId() != 0L || !lastElement.getName().isEmpty();
        }

        V1TestWriter(@UnknownKeyFor @NonNull @Initialized Datastore datastore, @UnknownKeyFor @NonNull @Initialized MutationBuilder mutationBuilder) {
            this.datastore = datastore;
            this.mutationBuilder = mutationBuilder;
        }

        void write(@UnknownKeyFor @NonNull @Initialized Entity value) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (!V1TestWriter.isValidKey(value.getKey())) {
                throw new IllegalArgumentException("Entities to be written to the Datastore must have complete keys");
            }
            this.entities.add(value);
            if (this.entities.size() >= 500) {
                this.flushBatch();
            }
        }

        void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.entities.size() > 0) {
                this.flushBatch();
            }
        }

        private void flushBatch() throws @UnknownKeyFor @NonNull @Initialized DatastoreException, @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            LOG.info("Writing batch of {} entities", (Object)this.entities.size());
            Sleeper sleeper = Sleeper.DEFAULT;
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(5).withInitialBackoff(INITIAL_BACKOFF).backoff();
            while (true) {
                try {
                    CommitRequest.Builder commitRequest = CommitRequest.newBuilder();
                    for (Entity entity : this.entities) {
                        commitRequest.addMutations(this.mutationBuilder.apply(entity));
                    }
                    commitRequest.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
                    this.datastore.commit(commitRequest.build());
                }
                catch (DatastoreException exception) {
                    LOG.error("Error writing to the Datastore ({}): {}", (Object)exception.getCode(), (Object)exception.getMessage());
                    if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) continue;
                    LOG.error("Aborting after {} retries.", (Object)5);
                    throw exception;
                }
                break;
            }
            LOG.info("Successfully wrote {} entities", (Object)this.entities.size());
            this.entities.clear();
        }
    }

    static class DeleteMutationBuilder
    implements MutationBuilder {
        DeleteMutationBuilder() {
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Mutation.Builder apply(@UnknownKeyFor @NonNull @Initialized Entity entity) {
            return DatastoreHelper.makeDelete((Key)entity.getKey());
        }
    }

    static class UpsertMutationBuilder
    implements MutationBuilder {
        UpsertMutationBuilder() {
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Mutation.Builder apply(@UnknownKeyFor @NonNull @Initialized Entity entity) {
            return DatastoreHelper.makeUpsert((Entity)entity);
        }
    }

    static interface MutationBuilder {
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Mutation.Builder apply(@UnknownKeyFor @NonNull @Initialized Entity var1);
    }

    static class CreateEntityFn
    extends DoFn<Long, Entity> {
        private final @UnknownKeyFor @NonNull @Initialized String kind;
        private final @Nullable @UnknownKeyFor @Initialized String namespace;
        private final @UnknownKeyFor @NonNull @Initialized int largePropertySize;
        private @UnknownKeyFor @NonNull @Initialized Key ancestorKey;

        CreateEntityFn(@UnknownKeyFor @NonNull @Initialized String kind, @Nullable @UnknownKeyFor @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String ancestor, @UnknownKeyFor @NonNull @Initialized int largePropertySize) {
            this.kind = kind;
            this.namespace = namespace;
            this.largePropertySize = largePropertySize;
            this.ancestorKey = V1TestUtil.makeAncestorKey(namespace, kind, ancestor);
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            c.output((Object)V1TestUtil.makeEntity((Long)c.element(), this.ancestorKey, this.kind, this.namespace, this.largePropertySize));
        }
    }
}

