/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Entity;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.client.Datastore;
import java.util.UUID;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreIO;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreV1;
import org.apache.beam.sdk.io.gcp.datastore.V1TestOptions;
import org.apache.beam.sdk.io.gcp.datastore.V1TestUtil;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class V1ReadIT {
    private @UnknownKeyFor @NonNull @Initialized V1TestOptions options;
    private @UnknownKeyFor @NonNull @Initialized String project;
    private @UnknownKeyFor @NonNull @Initialized String ancestor;
    private final @UnknownKeyFor @NonNull @Initialized long numEntities = 1000L;

    @Before
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PipelineOptionsFactory.register(V1TestOptions.class);
        this.options = (V1TestOptions)TestPipeline.testingPipelineOptions().as(V1TestOptions.class);
        this.project = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
        this.ancestor = UUID.randomUUID().toString();
        V1ReadIT.writeEntitiesToDatastore(this.options, this.project, this.ancestor, 1000L);
    }

    @After
    public void tearDown() throws @UnknownKeyFor @NonNull @Initialized Exception {
        V1TestUtil.deleteAllEntities(this.options, this.project, this.ancestor);
    }

    @Test
    public void testE2EV1Read() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Query query = V1TestUtil.makeAncestorKindQuery(this.options.getKind(), this.options.getNamespace(), this.ancestor);
        DatastoreV1.Read read = DatastoreIO.v1().read().withProjectId(this.project).withQuery(query).withNamespace(this.options.getNamespace());
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        PCollection count = (PCollection)((PCollection)p.apply((PTransform)read)).apply(Count.globally());
        PAssert.thatSingleton((PCollection)count).isEqualTo((Object)1000L);
        p.run();
    }

    @Test
    public void testE2EV1ReadWithGQLQueryWithNoLimit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testE2EV1ReadWithGQLQuery(0L);
    }

    @Test
    public void testE2EV1ReadWithGQLQueryWithLimit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testE2EV1ReadWithGQLQuery(99L);
    }

    private void testE2EV1ReadWithGQLQuery(@UnknownKeyFor @NonNull @Initialized long limit) throws @UnknownKeyFor @NonNull @Initialized Exception {
        String gqlQuery = String.format("SELECT * from %s WHERE __key__ HAS ANCESTOR KEY(%s, '%s')", this.options.getKind(), this.options.getKind(), this.ancestor);
        long expectedNumEntities = 1000L;
        if (limit > 0L) {
            gqlQuery = String.format("%s LIMIT %d", gqlQuery, limit);
            expectedNumEntities = limit;
        }
        DatastoreV1.Read read = DatastoreIO.v1().read().withProjectId(this.project).withLiteralGqlQuery(gqlQuery).withNamespace(this.options.getNamespace());
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        PCollection count = (PCollection)((PCollection)p.apply((PTransform)read)).apply(Count.globally());
        PAssert.thatSingleton((PCollection)count).isEqualTo((Object)expectedNumEntities);
        p.run();
    }

    private static void writeEntitiesToDatastore(@UnknownKeyFor @NonNull @Initialized V1TestOptions options, @UnknownKeyFor @NonNull @Initialized String project, @UnknownKeyFor @NonNull @Initialized String ancestor, @UnknownKeyFor @NonNull @Initialized long numEntities) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Datastore datastore = V1TestUtil.getDatastore((PipelineOptions)options, project);
        V1TestUtil.V1TestWriter writer = new V1TestUtil.V1TestWriter(datastore, new V1TestUtil.UpsertMutationBuilder());
        Key ancestorKey = V1TestUtil.makeAncestorKey(options.getNamespace(), options.getKind(), ancestor);
        for (long i = 0L; i < numEntities; ++i) {
            Entity entity = V1TestUtil.makeEntity(i, ancestorKey, options.getKind(), options.getNamespace(), 0);
            writer.write(entity);
        }
        writer.close();
    }
}

