/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Query;
import java.util.List;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreV1;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SplitQueryFnIT {
    @Test
    public void testSplitQueryFnWithLargeDataset() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String projectId = "apache-beam-testing";
        String kind = "sort_1G";
        String namespace = null;
        int expectedNumSplits = 32;
        this.testSplitQueryFn(projectId, kind, namespace, expectedNumSplits);
    }

    @Test
    public void testSplitQueryFnWithSmallDataset() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String projectId = "apache-beam-testing";
        String kind = "shakespeare";
        String namespace = null;
        int expectedNumSplits = 12;
        this.testSplitQueryFn(projectId, kind, namespace, expectedNumSplits);
    }

    private void testSplitQueryFn(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String kind, @Nullable @UnknownKeyFor @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized int expectedNumSplits) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Query.Builder query = Query.newBuilder();
        query.addKindBuilder().setName(kind);
        DatastoreV1.Read.SplitQueryFn splitQueryFn = new DatastoreV1.Read.SplitQueryFn(DatastoreV1.Read.V1Options.from((String)projectId, (String)namespace, null), 0);
        DoFnTester doFnTester = DoFnTester.of((DoFn)splitQueryFn);
        List queries = doFnTester.processBundle((Object[])new Query[]{query.build()});
        Assert.assertEquals((long)expectedNumSplits, (long)queries.size());
    }
}

