/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Entity;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.datastore.EntityToRow;
import org.apache.beam.sdk.io.gcp.datastore.RowToEntity;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class EntityToRowRowToEntityTest {
    private static final @UnknownKeyFor @NonNull @Initialized String KIND = "kind";
    private static final @UnknownKeyFor @NonNull @Initialized String UUID_VALUE = UUID.randomUUID().toString();
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Key.Builder KEY = DatastoreHelper.makeKey((Object[])new Object[]{"kind", UUID_VALUE});
    private static final @UnknownKeyFor @NonNull @Initialized DateTime DATE_TIME = EntityToRowRowToEntityTest.parseTimestampWithUTCTimeZone("2018-05-28 20:17:40");
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_KEY_FIELD = "__key__";
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType VARBINARY = Schema.FieldType.BYTES;
    private static final @UnknownKeyFor @NonNull @Initialized Schema NESTED_ROW_SCHEMA = Schema.builder().addNullableField("nestedLong", Schema.FieldType.INT64).build();
    private static final @UnknownKeyFor @NonNull @Initialized Schema SCHEMA = Schema.builder().addNullableField("__key__", VARBINARY).addNullableField("long", Schema.FieldType.INT64).addNullableField("bool", Schema.FieldType.BOOLEAN).addNullableField("datetime", Schema.FieldType.DATETIME).addNullableField("array", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).addNullableField("rowArray", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)NESTED_ROW_SCHEMA))).addNullableField("double", Schema.FieldType.DOUBLE).addNullableField("bytes", Schema.FieldType.BYTES).addNullableField("string", Schema.FieldType.STRING).addNullableField("nullable", Schema.FieldType.INT64).build();
    private static final @UnknownKeyFor @NonNull @Initialized Entity NESTED_ENTITY = Entity.newBuilder().putProperties("nestedLong", DatastoreHelper.makeValue((long)Long.MIN_VALUE).build()).build();
    private static final @UnknownKeyFor @NonNull @Initialized Entity ENTITY = Entity.newBuilder().setKey(KEY).putProperties("long", DatastoreHelper.makeValue((long)Long.MAX_VALUE).build()).putProperties("bool", DatastoreHelper.makeValue((boolean)true).build()).putProperties("datetime", DatastoreHelper.makeValue((Date)DATE_TIME.toDate()).build()).putProperties("array", DatastoreHelper.makeValue((Value.Builder)DatastoreHelper.makeValue((String)"string1"), (Value.Builder)DatastoreHelper.makeValue((String)"string2"), (Value.Builder[])new Value.Builder[0]).build()).putProperties("rowArray", DatastoreHelper.makeValue(Collections.singletonList(DatastoreHelper.makeValue((Entity)NESTED_ENTITY).build())).build()).putProperties("double", DatastoreHelper.makeValue((double)Double.MAX_VALUE).build()).putProperties("bytes", DatastoreHelper.makeValue((ByteString)ByteString.copyFrom((String)"hello", (Charset)Charset.defaultCharset())).build()).putProperties("string", DatastoreHelper.makeValue((String)"string").build()).putProperties("nullable", Value.newBuilder().build()).build();
    private static final @UnknownKeyFor @NonNull @Initialized Row ROW = EntityToRowRowToEntityTest.row(SCHEMA, KEY.build().toByteArray(), Long.MAX_VALUE, true, DATE_TIME, Arrays.asList("string1", "string2"), Collections.singletonList(EntityToRowRowToEntityTest.row(NESTED_ROW_SCHEMA, Long.MIN_VALUE)), Double.MAX_VALUE, "hello".getBytes(Charset.defaultCharset()), "string", null);
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testEntityToRowConverter() {
        PCollection result = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)ENTITY, (Object[])new Entity[0]))).apply((PTransform)EntityToRow.create((Schema)SCHEMA, (String)DEFAULT_KEY_FIELD));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{ROW});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testEntityToRowConverterWithoutKey() {
        Schema schemaWithoutKey = Schema.builder().addFields(SCHEMA.getFields().stream().filter(f -> !f.getName().equals(DEFAULT_KEY_FIELD)).collect(Collectors.toList())).build();
        Row rowWithoutKey = Row.withSchema((Schema)schemaWithoutKey).addValues(schemaWithoutKey.getFieldNames().stream().map(arg_0 -> ((Row)ROW).getValue(arg_0)).collect(Collectors.toList())).build();
        PCollection result = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)ENTITY, (Object[])new Entity[0]))).apply((PTransform)EntityToRow.create((Schema)schemaWithoutKey, (String)DEFAULT_KEY_FIELD));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{rowWithoutKey});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testRowToEntityConverter() {
        PCollection result = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)ROW, (Object[])new Row[0]))).setRowSchema(SCHEMA).apply((PTransform)RowToEntity.createTest((String)UUID_VALUE, (String)DEFAULT_KEY_FIELD, (String)KIND));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Entity[]{ENTITY});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testRowToEntityConverterWithoutKey() {
        Schema schemaWithoutKey = Schema.builder().addFields(SCHEMA.getFields().stream().filter(f -> !f.getName().equals(DEFAULT_KEY_FIELD)).collect(Collectors.toList())).build();
        Row rowWithoutKey = Row.withSchema((Schema)schemaWithoutKey).addValues(schemaWithoutKey.getFieldNames().stream().map(arg_0 -> ((Row)ROW).getValue(arg_0)).collect(Collectors.toList())).build();
        PCollection result = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)rowWithoutKey, (Object[])new Row[0]))).setRowSchema(schemaWithoutKey).apply((PTransform)RowToEntity.createTest((String)UUID_VALUE, (String)DEFAULT_KEY_FIELD, (String)KIND));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Entity[]{ENTITY});
        this.pipeline.run().waitUntilFinish();
    }

    private static @UnknownKeyFor @NonNull @Initialized Row row(@UnknownKeyFor @NonNull @Initialized Schema schema, Object ... values) {
        return Row.withSchema((Schema)schema).addValues(values).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized DateTime parseTimestampWithUTCTimeZone(@UnknownKeyFor @NonNull @Initialized String str) {
        if (str.indexOf(46) == -1) {
            return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC().parseDateTime(str);
        }
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").withZoneUTC().parseDateTime(str);
    }
}

