/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import java.util.Random;
import org.apache.beam.sdk.io.gcp.datastore.AdaptiveThrottler;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class AdaptiveThrottlerTest {
    static final @UnknownKeyFor @NonNull @Initialized long START_TIME_MS = 0L;
    static final @UnknownKeyFor @NonNull @Initialized long SAMPLE_PERIOD_MS = 60000L;
    static final @UnknownKeyFor @NonNull @Initialized long SAMPLE_BUCKET_MS = 1000L;
    static final @UnknownKeyFor @NonNull @Initialized double OVERLOAD_RATIO = 2.0;

    @UnknownKeyFor @NonNull @Initialized AdaptiveThrottler getThrottler() {
        return new AdaptiveThrottler(60000L, 1000L, 2.0);
    }

    @Test
    public void testNoInitialThrottling() throws @UnknownKeyFor @NonNull @Initialized Exception {
        AdaptiveThrottler throttler = this.getThrottler();
        Assert.assertThat((Object)throttler.throttlingProbability(0L), (Matcher)Matchers.equalTo((Object)0.0));
        Assert.assertThat((String)"first request is not throttled", (Object)throttler.throttleRequest(0L), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testNoThrottlingIfNoErrors() throws @UnknownKeyFor @NonNull @Initialized Exception {
        long t;
        AdaptiveThrottler throttler = this.getThrottler();
        for (t = 0L; t < 20L; ++t) {
            Assert.assertFalse((boolean)throttler.throttleRequest(t));
            throttler.successfulRequest(t);
        }
        Assert.assertThat((Object)throttler.throttlingProbability(t), (Matcher)Matchers.equalTo((Object)0.0));
    }

    @Test
    public void testNoThrottlingAfterErrorsExpire() throws @UnknownKeyFor @NonNull @Initialized Exception {
        long t;
        AdaptiveThrottler throttler = this.getThrottler();
        for (t = 0L; t < 60000L; ++t) {
            throttler.throttleRequest(t);
        }
        Assert.assertThat((String)"check that we set up a non-zero probability of throttling", (Object)throttler.throttlingProbability(t), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
        while (t < 120000L) {
            throttler.throttleRequest(t);
            throttler.successfulRequest(t);
            ++t;
        }
        Assert.assertThat((Object)throttler.throttlingProbability(t), (Matcher)Matchers.equalTo((Object)0.0));
    }

    @Test
    public void testThrottlingAfterErrors() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Random mockRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)mockRandom.nextDouble()).thenReturn((Object)0.0, (Object[])new Double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        AdaptiveThrottler throttler = new AdaptiveThrottler(60000L, 1000L, 2.0, mockRandom);
        for (int i = 0; i < 20; ++i) {
            boolean throttled = throttler.throttleRequest(0L + (long)i);
            if (i % 3 == 1) {
                throttler.successfulRequest(0L + (long)i);
            }
            if (i < 10) continue;
            Assert.assertThat((String)String.format("for i=%d", i), (Object)throttler.throttlingProbability(0L + (long)i), (Matcher)Matchers.closeTo((double)0.33, (double)0.1));
            Assert.assertThat((String)String.format("for i=%d", i), (Object)throttled, (Matcher)Matchers.equalTo((Object)(i < 14 ? 1 : 0)));
        }
    }
}

