/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auth.Credentials;
import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableTestOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigtableWriteIT
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized String COLUMN_FAMILY_NAME = "cf";
    private static @UnknownKeyFor @NonNull @Initialized BigtableTestOptions options;
    private @UnknownKeyFor @NonNull @Initialized BigtableOptions bigtableOptions;
    private static @UnknownKeyFor @NonNull @Initialized BigtableSession session;
    private static @UnknownKeyFor @NonNull @Initialized BigtableTableAdminClient tableAdminClient;
    private final @UnknownKeyFor @NonNull @Initialized String tableId = String.format("BigtableWriteIT-%tF-%<tH-%<tM-%<tS-%<tL", new Date());
    private @UnknownKeyFor @NonNull @Initialized String project;

    @Before
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PipelineOptionsFactory.register(BigtableTestOptions.class);
        options = (BigtableTestOptions)TestPipeline.testingPipelineOptions().as(BigtableTestOptions.class);
        this.project = ((GcpOptions)options.as(GcpOptions.class)).getProject();
        this.bigtableOptions = new BigtableOptions.Builder().setProjectId(this.project).setInstanceId(options.getInstanceId()).setUserAgent("apache-beam-test").build();
        session = new BigtableSession(this.bigtableOptions.toBuilder().setCredentialOptions(CredentialOptions.credential((Credentials)((GcpOptions)options.as(GcpOptions.class)).getGcpCredential())).build());
        tableAdminClient = session.getTableAdminClient();
    }

    @Test
    public void testE2EBigtableWrite() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String tableName = this.bigtableOptions.getInstanceName().toTableNameStr(this.tableId);
        String instanceName = this.bigtableOptions.getInstanceName().toString();
        int numRows = 1000;
        final List<KV<ByteString, ByteString>> testData = this.generateTableData(1000);
        this.createEmptyTable(instanceName, this.tableId);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).to(1000L))).apply((PTransform)ParDo.of((DoFn)new DoFn<Long, KV<ByteString, Iterable<Mutation>>>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                int index = ((Long)c.element()).intValue();
                ImmutableList mutations = ImmutableList.of((Object)Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setValue((ByteString)((KV)testData.get(index)).getValue()).setFamilyName(BigtableWriteIT.COLUMN_FAMILY_NAME)).build());
                c.output((Object)KV.of((Object)((ByteString)((KV)testData.get(index)).getKey()), (Object)mutations));
            }
        }))).apply((PTransform)BigtableIO.write().withBigtableOptions(this.bigtableOptions).withTableId(this.tableId));
        p.run();
        Table table = this.getTable(tableName);
        Assert.assertThat(table.getColumnFamiliesMap().keySet(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)table.getColumnFamiliesMap(), (Matcher)Matchers.hasKey((Object)COLUMN_FAMILY_NAME));
        List<KV<ByteString, ByteString>> tableData = this.getTableData(tableName);
        Assert.assertThat(tableData, (Matcher)Matchers.containsInAnyOrder((Object[])testData.toArray()));
    }

    @After
    public void tearDown() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String tableName = this.bigtableOptions.getInstanceName().toTableNameStr(this.tableId);
        this.deleteTable(tableName);
        session.close();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ByteString>> generateTableData(@UnknownKeyFor @NonNull @Initialized int numRows) {
        ArrayList<KV<ByteString, ByteString>> testData = new ArrayList<KV<ByteString, ByteString>>(numRows);
        for (int i = 0; i < numRows; ++i) {
            ByteString key = ByteString.copyFromUtf8((String)String.format("key%09d", i));
            ByteString value = ByteString.copyFromUtf8((String)String.format("value%09d", i));
            testData.add((KV<ByteString, ByteString>)KV.of((Object)key, (Object)value));
        }
        return testData;
    }

    private void createEmptyTable(@UnknownKeyFor @NonNull @Initialized String instanceName, @UnknownKeyFor @NonNull @Initialized String tableId) {
        Table.Builder tableBuilder = Table.newBuilder();
        tableBuilder.putColumnFamilies(COLUMN_FAMILY_NAME, ColumnFamily.newBuilder().build());
        CreateTableRequest.Builder createTableRequestBuilder = CreateTableRequest.newBuilder().setParent(instanceName).setTableId(tableId).setTable(tableBuilder.build());
        tableAdminClient.createTable(createTableRequestBuilder.build());
    }

    private @UnknownKeyFor @NonNull @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        GetTableRequest.Builder getTableRequestBuilder = GetTableRequest.newBuilder().setName(tableName);
        return tableAdminClient.getTable(getTableRequestBuilder.build());
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ByteString>> getTableData(@UnknownKeyFor @NonNull @Initialized String tableName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Row currentRow;
        RowRange range = RowRange.newBuilder().setStartKeyClosed(ByteString.EMPTY).setEndKeyOpen(ByteString.EMPTY).build();
        RowSet rowSet = RowSet.newBuilder().addRowRanges(range).build();
        ReadRowsRequest.Builder readRowsRequestBuilder = ReadRowsRequest.newBuilder().setTableName(tableName).setRows(rowSet);
        ResultScanner scanner = session.getDataClient().readRows(readRowsRequestBuilder.build());
        ArrayList<KV<ByteString, ByteString>> tableData = new ArrayList<KV<ByteString, ByteString>>();
        while ((currentRow = (Row)scanner.next()) != null) {
            ByteString key = currentRow.getKey();
            ByteString value = currentRow.getFamilies(0).getColumns(0).getCells(0).getValue();
            tableData.add((KV<ByteString, ByteString>)KV.of((Object)key, (Object)value));
        }
        scanner.close();
        return tableData;
    }

    private void deleteTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        DeleteTableRequest.Builder deleteTableRequestBuilder = DeleteTableRequest.newBuilder().setName(tableName);
        tableAdminClient.deleteTable(deleteTableRequestBuilder.build());
    }
}

