/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.Row;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableServiceImpl;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigtableServiceImplTest {
    private static final @UnknownKeyFor @NonNull @Initialized BigtableTableName TABLE_NAME = new BigtableInstanceName("project", "instance").toTableName("table");
    @Mock
    private @UnknownKeyFor @NonNull @Initialized BigtableSession mockSession;
    @Mock
    private @UnknownKeyFor @NonNull @Initialized BulkMutation mockBulkMutation;
    @Mock
    private @UnknownKeyFor @NonNull @Initialized BigtableDataClient mockBigtableDataClient;
    @Mock
    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BigtableIO.BigtableSource mockBigtableSource;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        BigtableOptions options = new BigtableOptions.Builder().setProjectId("project").setInstanceId("instance").build();
        Mockito.when((Object)this.mockSession.getOptions()).thenReturn((Object)options);
        Mockito.when((Object)this.mockSession.createBulkMutation((BigtableTableName)Matchers.eq((Object)TABLE_NAME))).thenReturn((Object)this.mockBulkMutation);
        Mockito.when((Object)this.mockSession.getDataClient()).thenReturn((Object)this.mockBigtableDataClient);
    }

    @Test
    public void testRead() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ByteKey start = ByteKey.copyFrom((byte[])"a".getBytes(StandardCharsets.UTF_8));
        ByteKey end = ByteKey.copyFrom((byte[])"b".getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)this.mockBigtableSource.getRanges()).thenReturn(Arrays.asList(ByteKeyRange.of((ByteKey)start, (ByteKey)end)));
        Mockito.when((Object)this.mockBigtableSource.getTableId()).thenReturn((Object)ValueProvider.StaticValueProvider.of((Object)"table_name"));
        ResultScanner mockResultScanner = (ResultScanner)Mockito.mock(ResultScanner.class);
        Row expectedRow = Row.newBuilder().setKey(ByteString.copyFromUtf8((String)"a")).build();
        Mockito.when((Object)((Row)mockResultScanner.next())).thenReturn((Object)expectedRow).thenReturn(null);
        Mockito.when((Object)this.mockBigtableDataClient.readRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class))).thenReturn((Object)mockResultScanner);
        BigtableServiceImpl.BigtableReaderImpl underTest = new BigtableServiceImpl.BigtableReaderImpl(this.mockSession, this.mockBigtableSource);
        underTest.start();
        Assert.assertEquals((Object)expectedRow, (Object)underTest.getCurrentRow());
        Assert.assertFalse((boolean)underTest.advance());
        underTest.close();
        ((ResultScanner)Mockito.verify((Object)mockResultScanner, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testWrite() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        BigtableServiceImpl.BigtableWriterImpl underTest = new BigtableServiceImpl.BigtableWriterImpl(this.mockSession, TABLE_NAME);
        Mutation mutation = Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyName("Family").build()).build();
        ByteString key = ByteString.copyFromUtf8((String)"key");
        SettableFuture fakeResponse = SettableFuture.create();
        Mockito.when((Object)this.mockBulkMutation.add((MutateRowsRequest.Entry)Matchers.any(MutateRowsRequest.Entry.class))).thenReturn((Object)fakeResponse);
        underTest.writeRecord(KV.of((Object)key, (Object)ImmutableList.of((Object)mutation)));
        MutateRowsRequest.Entry expected = MutateRowsRequest.Entry.newBuilder().setRowKey(key).addMutations(mutation).build();
        ((BulkMutation)Mockito.verify((Object)this.mockBulkMutation, (VerificationMode)Mockito.times((int)1))).add(expected);
        underTest.close();
        ((BulkMutation)Mockito.verify((Object)this.mockBulkMutation, (VerificationMode)Mockito.times((int)1))).flush();
    }
}

