/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Row;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRowFlat;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableTestUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Rule;
import org.junit.Test;

public class BigtableRowToBeamRowFlatTest {
    @Rule
    public final @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testBigtableRowToBeamRowFlat() {
        ImmutableMap columnsMapping = ImmutableMap.of((Object)"familyTest", (Object)ImmutableSet.of((Object)"boolColumn", (Object)"longColumn", (Object)"stringColumn", (Object)"doubleColumn"));
        PCollection rows = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)BigtableTestUtils.bigtableRow(1L), (Object[])new Row[]{BigtableTestUtils.bigtableRow(2L)}))).setCoder((Coder)ProtoCoder.of((TypeDescriptor)TypeDescriptor.of(Row.class))).apply((PTransform)new BigtableRowToBeamRowFlat(BigtableTestUtils.TEST_FLAT_SCHEMA, (Map)columnsMapping))).setRowSchema(BigtableTestUtils.TEST_FLAT_SCHEMA);
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new org.apache.beam.sdk.values.Row[]{this.row(1L), this.row(2L)});
        this.pipeline.run().waitUntilFinish();
    }

    private @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row row(@UnknownKeyFor @NonNull @Initialized long i) {
        return org.apache.beam.sdk.values.Row.withSchema((Schema)BigtableTestUtils.TEST_FLAT_SCHEMA).attachValues(new Object[]{"key" + i, false, 2L, "value1", 5.5});
    }
}

