/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Mutation;
import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigtable.BeamRowToBigtableMutation;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableTestUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Rule;
import org.junit.Test;

public class BeamRowToBigtableMutationTest {
    @Rule
    public final @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testBeamRowToBigtableMutation() {
        ImmutableMap columnsMapping = ImmutableMap.of((Object)"familyTest", (Object)ImmutableSet.of((Object)"boolColumn", (Object)"longColumn", (Object)"stringColumn", (Object)"doubleColumn"));
        PCollection rows = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)this.row(1L), (Object[])new Row[]{this.row(2L)}))).setRowSchema(BigtableTestUtils.TEST_FLAT_SCHEMA).apply((PTransform)new BeamRowToBigtableMutation((Map)columnsMapping))).apply((PTransform)MapElements.via((SimpleFunction)new SortMutationsByColumns()));
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new KV[]{BigtableTestUtils.rowMutation(1L), BigtableTestUtils.rowMutation(2L)});
        this.pipeline.run().waitUntilFinish();
    }

    private @UnknownKeyFor @NonNull @Initialized Row row(@UnknownKeyFor @NonNull @Initialized long i) {
        return Row.withSchema((Schema)BigtableTestUtils.TEST_FLAT_SCHEMA).attachValues(new Object[]{"key" + i, false, 2L, "value1", 5.5});
    }

    private static class SortMutationsByColumns
    extends SimpleFunction<KV<ByteString, Iterable<Mutation>>, KV<ByteString, Iterable<Mutation>>> {
        private SortMutationsByColumns() {
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>> apply(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>> input) {
            return KV.of((Object)((ByteString)input.getKey()), (Object)ImmutableList.copyOf((Iterable)((Iterable)input.getValue())).stream().sorted((mutation1, mutation2) -> {
                String qualifier = mutation1.getSetCell().getColumnQualifier().toStringUtf8();
                String other = mutation2.getSetCell().getColumnQualifier().toStringUtf8();
                return qualifier.compareTo(other);
            }).collect(Collectors.toList()));
        }
    }
}

