/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InsertRetryPolicyTest {
    @Test
    public void testNeverRetry() {
        Assert.assertFalse((boolean)InsertRetryPolicy.neverRetry().shouldRetry(new InsertRetryPolicy.Context(new TableDataInsertAllResponse.InsertErrors())));
    }

    @Test
    public void testAlwaysRetry() {
        Assert.assertTrue((boolean)InsertRetryPolicy.alwaysRetry().shouldRetry(new InsertRetryPolicy.Context(new TableDataInsertAllResponse.InsertErrors())));
    }

    @Test
    public void testDontRetryPersistentErrors() {
        InsertRetryPolicy policy = InsertRetryPolicy.retryTransientErrors();
        Assert.assertTrue((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "unavailable"))));
        Assert.assertFalse((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "invalid"))));
        Assert.assertFalse((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "invalidQuery"))));
        Assert.assertFalse((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "notImplemented"))));
    }

    @Test
    public void testCustomRetryPolicy() {
        RetryAllExceptInvalidQuery policy = new RetryAllExceptInvalidQuery();
        Assert.assertTrue((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "unavailable"))));
        Assert.assertTrue((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "invalid"))));
        Assert.assertFalse((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "invalidQuery"))));
        Assert.assertTrue((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "notImplemented"))));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableDataInsertAllResponse.InsertErrors generateErrorAmongMany(@UnknownKeyFor @NonNull @Initialized int numErrors, @UnknownKeyFor @NonNull @Initialized String baseReason, @UnknownKeyFor @NonNull @Initialized String exceptionalReason) {
        ArrayList errorProtos = Lists.newArrayListWithExpectedSize((int)numErrors);
        int exceptionalPosition = ThreadLocalRandom.current().nextInt(numErrors);
        for (int i = 0; i < numErrors; ++i) {
            ErrorProto error = new ErrorProto();
            error.setReason(i == exceptionalPosition ? exceptionalReason : baseReason);
            errorProtos.add(error);
        }
        TableDataInsertAllResponse.InsertErrors errors = new TableDataInsertAllResponse.InsertErrors();
        errors.setErrors((List)errorProtos);
        return errors;
    }

    static class RetryAllExceptInvalidQuery
    extends InsertRetryPolicy {
        RetryAllExceptInvalidQuery() {
        }

        public @UnknownKeyFor @NonNull @Initialized boolean shouldRetry(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy.Context context) {
            if (context.getInsertErrors().getErrors() != null) {
                for (ErrorProto error : context.getInsertErrors().getErrors()) {
                    if (error.getReason() == null || !error.getReason().equals("invalidQuery")) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

