/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class BigQuerySchemaUpdateOptionsIT {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQuerySchemaUpdateOptionsIT.class);
    private static @UnknownKeyFor @NonNull @Initialized String project;
    private static final @UnknownKeyFor @NonNull @Initialized BigqueryClient BQ_CLIENT;
    private static final @UnknownKeyFor @NonNull @Initialized String BIG_QUERY_DATASET_ID;
    private static final @UnknownKeyFor @NonNull @Initialized String TEST_TABLE_NAME_BASE = "test_table_";
    private static final @UnknownKeyFor @NonNull @Initialized TableSchema BASE_TABLE_SCHEMA;

    @BeforeClass
    public static void setupTestEnvironment() throws @UnknownKeyFor @NonNull @Initialized Exception {
        project = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
        BQ_CLIENT.createNewDataset(project, BIG_QUERY_DATASET_ID);
    }

    @AfterClass
    public static void cleanup() {
        LOG.info("Start to clean up tables and datasets.");
        BQ_CLIENT.deleteDataset(project, BIG_QUERY_DATASET_ID);
    }

    public @UnknownKeyFor @NonNull @Initialized String makeTestTable() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String tableName = TEST_TABLE_NAME_BASE + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
        BQ_CLIENT.createNewTable(project, BIG_QUERY_DATASET_ID, new Table().setSchema(BASE_TABLE_SCHEMA).setTableReference(new TableReference().setTableId(tableName).setDatasetId(BIG_QUERY_DATASET_ID).setProjectId(project)));
        return tableName;
    }

    private void runWriteTest(@UnknownKeyFor @NonNull @Initialized Set<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions, @UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized TableSchema schema, @UnknownKeyFor @NonNull @Initialized TableRow rowToInsert, @UnknownKeyFor @NonNull @Initialized String testQuery, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> expectedResult) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Options options = (Options)TestPipeline.testingPipelineOptions().as(Options.class);
        options.setTempLocation(options.getTempRoot() + "/bq_it_temp");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        Create.Values input = Create.of((Object)rowToInsert, (Object[])new TableRow[0]);
        BigQueryIO.Write writer = BigQueryIO.writeTableRows().to(String.format("%s:%s.%s", options.getProject(), BIG_QUERY_DATASET_ID, tableName)).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND).withSchemaUpdateOptions(schemaUpdateOptions);
        ((PCollection)p.apply((PTransform)input)).apply((PTransform)writer);
        p.run().waitUntilFinish();
        QueryResponse response = BQ_CLIENT.queryWithRetries(testQuery, project);
        List result = response.getRows().stream().map(row -> row.getF().stream().map(cell -> cell.getV().toString()).collect(Collectors.toList())).collect(Collectors.toList());
        Assert.assertEquals(expectedResult, result);
    }

    @Test
    public void testAllowFieldAddition() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String tableName = this.makeTestTable();
        EnumSet<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions = EnumSet.of(BigQueryIO.Write.SchemaUpdateOption.ALLOW_FIELD_ADDITION);
        TableSchema newSchema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("new_field").setType("STRING"), (Object)new TableFieldSchema().setName("optional_field").setType("STRING"), (Object)new TableFieldSchema().setName("required_field").setType("STRING").setMode("REQUIRED")));
        String[] values = new String[]{"meow", "bark"};
        TableRow rowToInsert = new TableRow().set("new_field", (Object)values[0]).set("required_field", (Object)values[1]);
        String testQuery = String.format("SELECT new_field, required_field FROM [%s.%s];", BIG_QUERY_DATASET_ID, tableName);
        List<List<String>> expectedResult = Arrays.asList(Arrays.asList(values));
        this.runWriteTest(schemaUpdateOptions, tableName, newSchema, rowToInsert, testQuery, expectedResult);
    }

    @Test
    public void testAllowFieldRelaxation() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String tableName = this.makeTestTable();
        EnumSet<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions = EnumSet.of(BigQueryIO.Write.SchemaUpdateOption.ALLOW_FIELD_RELAXATION);
        TableSchema newSchema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("optional_field").setType("STRING")));
        String value = "hellooo";
        TableRow rowToInsert = new TableRow().set("optional_field", (Object)value);
        String testQuery = String.format("SELECT optional_field FROM [%s.%s];", BIG_QUERY_DATASET_ID, tableName);
        List<List<String>> expectedResult = Arrays.asList(Arrays.asList(value));
        this.runWriteTest(schemaUpdateOptions, tableName, newSchema, rowToInsert, testQuery, expectedResult);
    }

    static {
        BQ_CLIENT = new BigqueryClient("BigQuerySchemaUpdateOptionsIT");
        BIG_QUERY_DATASET_ID = "bq_query_schema_update_options_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
        BASE_TABLE_SCHEMA = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("optional_field").setType("STRING"), (Object)new TableFieldSchema().setName("required_field").setType("STRING").setMode("REQUIRED")));
    }

    public static interface Options
    extends TestPipelineOptions,
    BigQueryOptions {
    }
}

