/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryNestedRecordsIT {
    private static final @UnknownKeyFor @NonNull @Initialized String RECORD_QUERY = "SELECT city.* FROM [apache-beam-testing:big_query_nested_test.source_table]";
    private static final @UnknownKeyFor @NonNull @Initialized String UNFLATTENABLE_QUERY = "SELECT * FROM [apache-beam-testing:big_query_nested_test.genomics_2]";
    private static @UnknownKeyFor @NonNull @Initialized Integer stringifyCount = 0;

    @Test
    public void testNestedRecords() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PipelineOptionsFactory.register(Options.class);
        TestPipelineOptions testOptions = (TestPipelineOptions)TestPipeline.testingPipelineOptions().as(TestPipelineOptions.class);
        Options options = (Options)testOptions.as(Options.class);
        options.setTempLocation(testOptions.getTempRoot() + "/temp-it/");
        BigQueryNestedRecordsIT.runPipeline(options);
    }

    private static void runPipeline(@UnknownKeyFor @NonNull @Initialized Options options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        BigQueryOptions bigQueryOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        PCollection flattenedCollection = (PCollection)p.apply("ReadFlattened", (PTransform)BigQueryIO.readTableRows().fromQuery(options.getInput()));
        PCollection nonFlattenedCollection = (PCollection)p.apply("ReadNonFlattened", (PTransform)BigQueryIO.readTableRows().fromQuery(options.getInput()).withoutResultFlattening());
        PCollection unflattenableCollection = (PCollection)p.apply("ReadUnflattenable", (PTransform)BigQueryIO.readTableRows().fromQuery(options.getUnflattenableInput()).withoutResultFlattening());
        BigqueryClient bigQueryClient = new BigqueryClient(bigQueryOptions.getAppName());
        TableRow queryFlattenedTyped = (TableRow)bigQueryClient.queryWithRetries(options.getInput(), bigQueryOptions.getProject(), true).getRows().get(0);
        TableRow queryUnflattened = (TableRow)bigQueryClient.queryUnflattened(options.getInput(), bigQueryOptions.getProject(), true).get(0);
        TableRow queryUnflattenable = (TableRow)bigQueryClient.queryUnflattened(options.getUnflattenableInput(), bigQueryOptions.getProject(), true).get(0);
        PAssert.thatSingleton((PCollection)flattenedCollection).isEqualTo((Object)queryFlattenedTyped);
        PAssert.thatSingleton((PCollection)nonFlattenedCollection).isEqualTo((Object)queryUnflattened);
        PAssert.thatSingleton((PCollection)unflattenableCollection).isEqualTo((Object)queryUnflattenable);
        PAssert.thatSingleton((PCollection)flattenedCollection).notEqualTo((Object)queryUnflattened);
        p.run().waitUntilFinish();
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Query for the pipeline input.  Must return exactly one result")
        @Default.String(value="SELECT city.* FROM [apache-beam-testing:big_query_nested_test.source_table]")
        public @UnknownKeyFor @NonNull @Initialized String getInput();

        public void setInput(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Query for unflattenable input.  Must return exactly one result")
        @Default.String(value="SELECT * FROM [apache-beam-testing:big_query_nested_test.genomics_2]")
        public @UnknownKeyFor @NonNull @Initialized String getUnflattenableInput();

        public void setunflattenableInput(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

