/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Encoder;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIOWriteTest_InputRecord;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinationsHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.io.gcp.bigquery.WritePartition;
import org.apache.beam.sdk.io.gcp.bigquery.WriteRename;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.gcp.bigquery.WriteTables;
import org.apache.beam.sdk.io.gcp.testing.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.testing.FakeJobService;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;

@RunWith(value=JUnit4.class)
public class BigQueryIOWriteTest
implements Serializable {
    private transient @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
    private transient @UnknownKeyFor @NonNull @Initialized TemporaryFolder testFolder = new TemporaryFolder();
    private transient @UnknownKeyFor @NonNull @Initialized TestPipeline p;
    @Rule
    public final transient @UnknownKeyFor @NonNull @Initialized TestRule folderThenPipeline = new TestRule(){

        public @UnknownKeyFor @NonNull @Initialized Statement apply(final @UnknownKeyFor @NonNull @Initialized Statement base, final @UnknownKeyFor @NonNull @Initialized Description description) {
            Statement withPipeline = new Statement(){

                public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    BigQueryIOWriteTest.this.options = TestPipeline.testingPipelineOptions();
                    ((BigQueryOptions)BigQueryIOWriteTest.this.options.as(BigQueryOptions.class)).setProject("project-id");
                    ((BigQueryOptions)BigQueryIOWriteTest.this.options.as(BigQueryOptions.class)).setTempLocation(BigQueryIOWriteTest.this.testFolder.getRoot().getAbsolutePath());
                    BigQueryIOWriteTest.this.p = TestPipeline.fromOptions((PipelineOptions)BigQueryIOWriteTest.this.options);
                    BigQueryIOWriteTest.this.p.apply(base, description).evaluate();
                }
            };
            return BigQueryIOWriteTest.this.testFolder.apply(withPipeline, description);
        }
    };
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized ExpectedLogs loggedWriteRename = ExpectedLogs.none(WriteRename.class);
    private @UnknownKeyFor @NonNull @Initialized FakeDatasetService fakeDatasetService = new FakeDatasetService();
    private @UnknownKeyFor @NonNull @Initialized FakeJobService fakeJobService = new FakeJobService();
    private @UnknownKeyFor @NonNull @Initialized FakeBigQueryServices fakeBqServices = new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withJobService((BigQueryServices.JobService)this.fakeJobService);
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized InputRecord> INPUT_RECORD_CODER = SerializableCoder.of(InputRecord.class);

    @Before
    public void setUp() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        FakeDatasetService.setUp();
        BigQueryIO.clearCreatedTables();
        this.fakeDatasetService.createDataset("project-id", "dataset-id", "", "", null);
    }

    @After
    public void tearDown() throws @UnknownKeyFor @NonNull @Initialized IOException {
        BigQueryIOWriteTest.testNumFiles(new File(this.options.getTempLocation()), 0);
    }

    @Test
    public void testWriteEmptyPCollection() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableSchema schema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("number").setType("INTEGER")));
        ((PCollection)this.p.apply((PTransform)Create.empty((Coder)TableRowJsonCoder.of()))).apply((PTransform)BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withTestServices((BigQueryServices)this.fakeBqServices).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withSchema(schema).withoutValidation());
        this.p.run();
        Preconditions.checkNotNull((Object)this.fakeDatasetService.getTable(BigQueryHelpers.parseTableSpec((String)"project-id:dataset-id.table-id")));
    }

    @Test
    public void testWriteDynamicDestinationsBatch() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.writeDynamicDestinations(false, false);
    }

    @Test
    public void testWriteDynamicDestinationsBatchWithSchemas() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.writeDynamicDestinations(false, true);
    }

    @Test
    public void testWriteDynamicDestinationsStreaming() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.writeDynamicDestinations(true, false);
    }

    @Test
    public void testWriteDynamicDestinationsStreamingWithSchemas() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.writeDynamicDestinations(true, true);
    }

    public void writeDynamicDestinations(@UnknownKeyFor @NonNull @Initialized boolean streaming, @UnknownKeyFor @NonNull @Initialized boolean schemas) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Schema schema = Schema.builder().addField("name", Schema.FieldType.STRING).addField("id", Schema.FieldType.INT32).build();
        final Pattern userPattern = Pattern.compile("([a-z]+)([0-9]+)");
        final PCollectionView sideInput1 = (PCollectionView)((PCollection)this.p.apply("Create SideInput 1", (PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c"}).withCoder((Coder)StringUtf8Coder.of()))).apply("asList", (PTransform)View.asList());
        final PCollectionView sideInput2 = (PCollectionView)((PCollection)this.p.apply("Create SideInput2", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)"a"), (Object[])new KV[]{KV.of((Object)"b", (Object)"b"), KV.of((Object)"c", (Object)"c")}))).apply("AsMap", (PTransform)View.asMap());
        ImmutableList allUsernames = ImmutableList.of((Object)"bill", (Object)"bob", (Object)"randolph");
        ArrayList userList = Lists.newArrayList();
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 10; ++j) {
                String nickname = (String)allUsernames.get(ThreadLocalRandom.current().nextInt(allUsernames.size()));
                userList.add(nickname + i);
            }
        }
        PCollection users = (PCollection)((PCollection)this.p.apply("CreateUsers", (PTransform)Create.of((Iterable)userList))).apply((PTransform)Window.into(new PartitionedGlobalWindows((SerializableFunction & Serializable)arg -> arg)));
        if (streaming) {
            users = users.setIsBoundedInternal(PCollection.IsBounded.UNBOUNDED);
        }
        if (schemas) {
            users = users.setSchema(schema, TypeDescriptors.strings(), (SerializableFunction & Serializable)user -> {
                Matcher matcher = userPattern.matcher((CharSequence)user);
                Preconditions.checkState((boolean)matcher.matches());
                return Row.withSchema((Schema)schema).addValue((Object)matcher.group(1)).addValue((Object)Integer.valueOf(matcher.group(2))).build();
            }, (SerializableFunction & Serializable)r -> r.getString(0) + r.getInt32(1));
        }
        String partitionDecorator = "20171127";
        BigQueryIO.Write write = BigQueryIO.write().withTestServices((BigQueryServices)this.fakeBqServices).withMaxFilesPerBundle(5).withMaxFileSize(10L).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).to((DynamicDestinations)new StringLongDestinations(){

            public @UnknownKeyFor @NonNull @Initialized Long getDestination(@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized String> element) {
                Assert.assertThat((Object)element.getWindow(), (org.hamcrest.Matcher)Matchers.instanceOf(PartitionedGlobalWindow.class));
                Matcher matcher = userPattern.matcher((CharSequence)element.getValue());
                Preconditions.checkState((boolean)matcher.matches());
                return Long.valueOf(matcher.group(2));
            }

            public @UnknownKeyFor @NonNull @Initialized TableDestination getTable(@UnknownKeyFor @NonNull @Initialized Long userId) {
                this.verifySideInputs();
                return new TableDestination("dataset-id.userid-" + userId + "$" + "20171127", "table for userid " + userId);
            }

            public @UnknownKeyFor @NonNull @Initialized TableSchema getSchema(@UnknownKeyFor @NonNull @Initialized Long userId) {
                this.verifySideInputs();
                return new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("id").setType("INTEGER")));
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
                return ImmutableList.of((Object)sideInput1, (Object)sideInput2);
            }

            private void verifySideInputs() {
                Assert.assertThat((Object)((List)this.sideInput(sideInput1)), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"a", "b", "c"}));
                Map mapSideInput = (Map)this.sideInput(sideInput2);
                Assert.assertEquals((long)3L, (long)mapSideInput.size());
                Assert.assertThat((Object)mapSideInput, (org.hamcrest.Matcher)Matchers.allOf((org.hamcrest.Matcher)Matchers.hasEntry((Object)"a", (Object)"a"), (org.hamcrest.Matcher)Matchers.hasEntry((Object)"b", (Object)"b"), (org.hamcrest.Matcher)Matchers.hasEntry((Object)"c", (Object)"c")));
            }
        }).withoutValidation();
        write = schemas ? write.useBeamSchema() : write.withFormatFunction((SerializableFunction & Serializable)user -> {
            Matcher matcher = userPattern.matcher((CharSequence)user);
            Preconditions.checkState((boolean)matcher.matches());
            return new TableRow().set("name", (Object)matcher.group(1)).set("id", (Object)matcher.group(2));
        });
        users.apply("WriteBigQuery", (PTransform)write);
        this.p.run();
        HashMap expectedTableRows = Maps.newHashMap();
        for (String string : userList) {
            Matcher matcher = userPattern.matcher(string);
            Preconditions.checkState((boolean)matcher.matches());
            String nickname = matcher.group(1);
            Long userid = Long.valueOf(matcher.group(2));
            List expected = expectedTableRows.computeIfAbsent(userid, k -> Lists.newArrayList());
            expected.add(new TableRow().set("name", (Object)nickname).set("id", (Object)userid.toString()));
        }
        for (Map.Entry entry : expectedTableRows.entrySet()) {
            Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "userid-" + entry.getKey()), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)((Iterable)entry.getValue()), TableRow.class))));
        }
    }

    void testTimePartitioningClustering(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.Method insertMethod, @UnknownKeyFor @NonNull @Initialized boolean enablePartitioning, @UnknownKeyFor @NonNull @Initialized boolean enableClustering) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableRow row1 = new TableRow().set("date", (Object)"2018-01-01").set("number", (Object)"1");
        TableRow row2 = new TableRow().set("date", (Object)"2018-01-02").set("number", (Object)"2");
        TimePartitioning timePartitioning = new TimePartitioning().setType("DAY").setField("date");
        Clustering clustering = new Clustering().setFields((List)ImmutableList.of((Object)"date"));
        TableSchema schema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("date").setType("DATE").setName("number").setType("INTEGER")));
        BigQueryIO.Write writeTransform = BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withTestServices((BigQueryServices)this.fakeBqServices).withMethod(insertMethod).withSchema(schema).withoutValidation();
        if (enablePartitioning) {
            writeTransform = writeTransform.withTimePartitioning(timePartitioning);
        }
        if (enableClustering) {
            writeTransform = writeTransform.withClustering(clustering);
        }
        ((PCollection)this.p.apply((PTransform)Create.of((Object)row1, (Object[])new TableRow[]{row2}))).apply((PTransform)writeTransform);
        this.p.run();
        Table table = this.fakeDatasetService.getTable(BigQueryHelpers.parseTableSpec((String)"project-id:dataset-id.table-id"));
        Assert.assertEquals((Object)schema, (Object)table.getSchema());
        if (enablePartitioning) {
            Assert.assertEquals((Object)timePartitioning, (Object)table.getTimePartitioning());
        }
        if (enableClustering) {
            Assert.assertEquals((Object)clustering, (Object)table.getClustering());
        }
    }

    void testTimePartitioning(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.Method insertMethod) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testTimePartitioningClustering(insertMethod, true, false);
    }

    void testClustering(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.Method insertMethod) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testTimePartitioningClustering(insertMethod, true, true);
    }

    @Test
    public void testTimePartitioningStreamingInserts() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testTimePartitioning(BigQueryIO.Write.Method.STREAMING_INSERTS);
    }

    @Test
    public void testTimePartitioningBatchLoads() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testTimePartitioning(BigQueryIO.Write.Method.FILE_LOADS);
    }

    @Test
    public void testClusteringStreamingInserts() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testClustering(BigQueryIO.Write.Method.STREAMING_INSERTS);
    }

    @Test
    public void testClusteringBatchLoads() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testClustering(BigQueryIO.Write.Method.FILE_LOADS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClusteringThrowsWithoutPartitioning() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.p.enableAbandonedNodeEnforcement(false);
        this.testTimePartitioningClustering(BigQueryIO.Write.Method.STREAMING_INSERTS, false, true);
    }

    @Test
    public void testClusteringTableFunction() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableRow row1 = new TableRow().set("date", (Object)"2018-01-01").set("number", (Object)"1");
        TableRow row2 = new TableRow().set("date", (Object)"2018-01-02").set("number", (Object)"2");
        TimePartitioning timePartitioning = new TimePartitioning().setType("DAY").setField("date");
        Clustering clustering = new Clustering().setFields((List)ImmutableList.of((Object)"date"));
        TableSchema schema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("date").setType("DATE").setName("number").setType("INTEGER")));
        ((PCollection)this.p.apply((PTransform)Create.of((Object)row1, (Object[])new TableRow[]{row2}))).apply((PTransform)BigQueryIO.writeTableRows().to((SerializableFunction & Serializable)vsw -> {
            String tableSpec = "project-id:dataset-id.table-" + ((TableRow)vsw.getValue()).get((Object)"number");
            return new TableDestination(tableSpec, null, new TimePartitioning().setType("DAY").setField("date"), new Clustering().setFields((List)ImmutableList.of((Object)"date")));
        }).withTestServices((BigQueryServices)this.fakeBqServices).withMethod(BigQueryIO.Write.Method.FILE_LOADS).withSchema(schema).withClustering().withoutValidation());
        this.p.run();
        Table table = this.fakeDatasetService.getTable(BigQueryHelpers.parseTableSpec((String)"project-id:dataset-id.table-1"));
        Assert.assertEquals((Object)schema, (Object)table.getSchema());
        Assert.assertEquals((Object)timePartitioning, (Object)table.getTimePartitioning());
        Assert.assertEquals((Object)clustering, (Object)table.getClustering());
    }

    @Test
    public void testTriggeredFileLoads() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList elements = Lists.newArrayList();
        for (int i = 0; i < 30; ++i) {
            elements.add(new TableRow().set("number", (Object)i));
        }
        TestStream testStream = TestStream.create((Coder)TableRowJsonCoder.of()).addElements((Object)((TableRow)elements.get(0)), (Object[])((TableRow[])Iterables.toArray(elements.subList(1, 10), TableRow.class))).advanceProcessingTime(Duration.standardMinutes((long)1L)).addElements((Object)((TableRow)elements.get(10)), (Object[])((TableRow[])Iterables.toArray(elements.subList(11, 20), TableRow.class))).advanceProcessingTime(Duration.standardMinutes((long)1L)).addElements((Object)((TableRow)elements.get(20)), (Object[])((TableRow[])Iterables.toArray(elements.subList(21, 30), TableRow.class))).advanceWatermarkToInfinity();
        ((PCollection)this.p.apply((PTransform)testStream)).apply((PTransform)BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("number").setType("INTEGER")))).withTestServices((BigQueryServices)this.fakeBqServices).withTriggeringFrequency(Duration.standardSeconds((long)30L)).withNumFileShards(2).withMethod(BigQueryIO.Write.Method.FILE_LOADS).withoutValidation());
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)elements, TableRow.class))));
    }

    public void testTriggeredFileLoadsWithTempTables(@UnknownKeyFor @NonNull @Initialized String tableRef) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList elements = Lists.newArrayList();
        for (int i = 0; i < 30; ++i) {
            elements.add(new TableRow().set("number", (Object)i));
        }
        TestStream testStream = TestStream.create((Coder)TableRowJsonCoder.of()).addElements((Object)((TableRow)elements.get(0)), (Object[])((TableRow[])Iterables.toArray(elements.subList(1, 10), TableRow.class))).advanceProcessingTime(Duration.standardMinutes((long)1L)).addElements((Object)((TableRow)elements.get(10)), (Object[])((TableRow[])Iterables.toArray(elements.subList(11, 20), TableRow.class))).advanceProcessingTime(Duration.standardMinutes((long)1L)).addElements((Object)((TableRow)elements.get(20)), (Object[])((TableRow[])Iterables.toArray(elements.subList(21, 30), TableRow.class))).advanceWatermarkToInfinity();
        ((PCollection)this.p.apply((PTransform)testStream)).apply((PTransform)BigQueryIO.writeTableRows().to(tableRef).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("number").setType("INTEGER")))).withTestServices((BigQueryServices)this.fakeBqServices).withTriggeringFrequency(Duration.standardSeconds((long)30L)).withNumFileShards(2).withMaxBytesPerPartition(1L).withMaxFilesPerPartition(1).withMethod(BigQueryIO.Write.Method.FILE_LOADS).withoutValidation());
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)elements, TableRow.class))));
    }

    @Test
    public void testTriggeredFileLoadsWithTempTables() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testTriggeredFileLoadsWithTempTables("project-id:dataset-id.table-id");
    }

    @Test
    public void testTriggeredFileLoadsWithTempTablesDefaultProject() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testTriggeredFileLoadsWithTempTables("dataset-id.table-id");
    }

    @Test
    public void testFailuresNoRetryPolicy() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableRow row1 = new TableRow().set("name", (Object)"a").set("number", (Object)"1");
        TableRow row2 = new TableRow().set("name", (Object)"b").set("number", (Object)"2");
        TableRow row3 = new TableRow().set("name", (Object)"c").set("number", (Object)"3");
        TableDataInsertAllResponse.InsertErrors ephemeralError = new TableDataInsertAllResponse.InsertErrors().setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout")));
        this.fakeDatasetService.failOnInsert((Map)ImmutableMap.of((Object)row1, (Object)ImmutableList.of((Object)ephemeralError, (Object)ephemeralError), (Object)row2, (Object)ImmutableList.of((Object)ephemeralError, (Object)ephemeralError)));
        ((PCollection)this.p.apply((PTransform)Create.of((Object)row1, (Object[])new TableRow[]{row2, row3}))).apply((PTransform)BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withMethod(BigQueryIO.Write.Method.STREAMING_INSERTS).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{row1, row2, row3}));
    }

    @Test
    public void testRetryPolicy() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableRow row1 = new TableRow().set("name", (Object)"a").set("number", (Object)"1");
        TableRow row2 = new TableRow().set("name", (Object)"b").set("number", (Object)"2");
        TableRow row3 = new TableRow().set("name", (Object)"c").set("number", (Object)"3");
        TableDataInsertAllResponse.InsertErrors ephemeralError = new TableDataInsertAllResponse.InsertErrors().setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout")));
        TableDataInsertAllResponse.InsertErrors persistentError = new TableDataInsertAllResponse.InsertErrors().setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("invalidQuery")));
        this.fakeDatasetService.failOnInsert((Map)ImmutableMap.of((Object)row1, (Object)ImmutableList.of((Object)ephemeralError, (Object)ephemeralError), (Object)row2, (Object)ImmutableList.of((Object)ephemeralError, (Object)ephemeralError, (Object)persistentError)));
        PCollection failedRows = ((WriteResult)((PCollection)this.p.apply((PTransform)Create.of((Object)row1, (Object[])new TableRow[]{row2, row3}))).apply((PTransform)BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withMethod(BigQueryIO.Write.Method.STREAMING_INSERTS).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).withFailedInsertRetryPolicy(InsertRetryPolicy.retryTransientErrors()).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation())).getFailedInserts();
        PAssert.that((PCollection)failedRows).containsInAnyOrder((Object[])new TableRow[]{row2});
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{row1, row3}));
    }

    @Test
    public void testWrite() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1), (Object[])new TableRow[]{new TableRow().set("name", (Object)"b").set("number", (Object)2), new TableRow().set("name", (Object)"c").set("number", (Object)3)}).withCoder((Coder)TableRowJsonCoder.of()))).apply((PTransform)BigQueryIO.writeTableRows().to("dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.p.run();
    }

    @Test
    public void testWriteWithoutInsertId() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableRow row1 = new TableRow().set("name", (Object)"a").set("number", (Object)1);
        TableRow row2 = new TableRow().set("name", (Object)"b").set("number", (Object)2);
        TableRow row3 = new TableRow().set("name", (Object)"c").set("number", (Object)3);
        ((PCollection)this.p.apply((PTransform)Create.of((Object)row1, (Object[])new TableRow[]{row2, row3}).withCoder((Coder)TableRowJsonCoder.of()))).apply((PTransform)BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withMethod(BigQueryIO.Write.Method.STREAMING_INSERTS).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).withTestServices((BigQueryServices)this.fakeBqServices).ignoreInsertIds().withoutValidation());
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{row1, row2, row3}));
        Assert.assertThat((Object)this.fakeDatasetService.getAllIds("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((org.hamcrest.Matcher[])new org.hamcrest.Matcher[0]));
    }

    @Test
    public void testWriteAvro() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)InputRecord.create("test", 1L, 1.0, Instant.parse((String)"2019-01-01T00:00:00Z")), (Object[])new InputRecord[]{InputRecord.create("test2", 2L, 2.0, Instant.parse((String)"2019-02-01T00:00:00Z"))}).withCoder(INPUT_RECORD_CODER))).apply((PTransform)BigQueryIO.write().to("dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("strVal").setType("STRING"), (Object)new TableFieldSchema().setName("longVal").setType("INTEGER"), (Object)new TableFieldSchema().setName("doubleVal").setType("FLOAT"), (Object)new TableFieldSchema().setName("instantVal").setType("TIMESTAMP")))).withTestServices((BigQueryServices)this.fakeBqServices).withAvroFormatFunction((SerializableFunction & Serializable)r -> {
            GenericData.Record rec = new GenericData.Record(r.getSchema());
            InputRecord i = (InputRecord)r.getElement();
            rec.put("strVal", (Object)i.strVal());
            rec.put("longVal", (Object)i.longVal());
            rec.put("doubleVal", (Object)i.doubleVal());
            rec.put("instantVal", (Object)(i.instantVal().getMillis() * 1000L));
            return rec;
        }).withoutValidation());
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{new TableRow().set("strVal", (Object)"test").set("longVal", (Object)"1").set("doubleVal", (Object)1.0).set("instantVal", (Object)"2019-01-01 00:00:00 UTC"), new TableRow().set("strVal", (Object)"test2").set("longVal", (Object)"2").set("doubleVal", (Object)2.0).set("instantVal", (Object)"2019-02-01 00:00:00 UTC")}));
    }

    @Test
    public void testWriteAvroWithCustomWriter() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SerializableFunction & Serializable formatFunction = (SerializableFunction & Serializable)r -> {
            GenericData.Record rec = new GenericData.Record(r.getSchema());
            InputRecord i = (InputRecord)r.getElement();
            rec.put("strVal", (Object)i.strVal());
            rec.put("longVal", (Object)i.longVal());
            rec.put("doubleVal", (Object)i.doubleVal());
            rec.put("instantVal", (Object)(i.instantVal().getMillis() * 1000L));
            return rec;
        };
        SerializableFunction & Serializable customWriterFactory = (SerializableFunction & Serializable)s -> new GenericDatumWriter<GenericRecord>(){

            protected void writeString(@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema schema, @UnknownKeyFor @NonNull @Initialized Object datum, @UnknownKeyFor @NonNull @Initialized Encoder out) throws @UnknownKeyFor @NonNull @Initialized IOException {
                super.writeString(schema, (Object)(datum.toString() + "_custom"), out);
            }
        };
        ((PCollection)this.p.apply((PTransform)Create.of((Object)InputRecord.create("test", 1L, 1.0, Instant.parse((String)"2019-01-01T00:00:00Z")), (Object[])new InputRecord[]{InputRecord.create("test2", 2L, 2.0, Instant.parse((String)"2019-02-01T00:00:00Z"))}).withCoder(INPUT_RECORD_CODER))).apply((PTransform)BigQueryIO.write().to("dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("strVal").setType("STRING"), (Object)new TableFieldSchema().setName("longVal").setType("INTEGER"), (Object)new TableFieldSchema().setName("doubleVal").setType("FLOAT"), (Object)new TableFieldSchema().setName("instantVal").setType("TIMESTAMP")))).withTestServices((BigQueryServices)this.fakeBqServices).withAvroWriter((SerializableFunction)formatFunction, (SerializableFunction)customWriterFactory).withoutValidation());
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{new TableRow().set("strVal", (Object)"test_custom").set("longVal", (Object)"1").set("doubleVal", (Object)1.0).set("instantVal", (Object)"2019-01-01 00:00:00 UTC"), new TableRow().set("strVal", (Object)"test2_custom").set("longVal", (Object)"2").set("doubleVal", (Object)2.0).set("instantVal", (Object)"2019-02-01 00:00:00 UTC")}));
    }

    @Test
    public void testStreamingWrite() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1), (Object[])new TableRow[]{new TableRow().set("name", (Object)"b").set("number", (Object)2), new TableRow().set("name", (Object)"c").set("number", (Object)3), new TableRow().set("name", (Object)"d").set("number", (Object)4)}).withCoder((Coder)TableRowJsonCoder.of()))).setIsBoundedInternal(PCollection.IsBounded.UNBOUNDED).apply((PTransform)BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{new TableRow().set("name", (Object)"a").set("number", (Object)1), new TableRow().set("name", (Object)"b").set("number", (Object)2), new TableRow().set("name", (Object)"c").set("number", (Object)3), new TableRow().set("name", (Object)"d").set("number", (Object)4)}));
    }

    @Test
    public void testSchemaWriteLoads() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)new SchemaPojo("a", 1), (Object[])new SchemaPojo[]{new SchemaPojo("b", 2), new SchemaPojo("c", 3), new SchemaPojo("d", 4)}))).apply((PTransform)BigQueryIO.write().to("project-id:dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withMethod(BigQueryIO.Write.Method.FILE_LOADS).useBeamSchema().withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{new TableRow().set("name", (Object)"a").set("number", (Object)"1"), new TableRow().set("name", (Object)"b").set("number", (Object)"2"), new TableRow().set("name", (Object)"c").set("number", (Object)"3"), new TableRow().set("name", (Object)"d").set("number", (Object)"4")}));
    }

    @Test
    public void testSchemaWriteStreams() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)new SchemaPojo("a", 1), (Object[])new SchemaPojo[]{new SchemaPojo("b", 2), new SchemaPojo("c", 3), new SchemaPojo("d", 4)}))).apply((PTransform)BigQueryIO.write().to("project-id:dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withMethod(BigQueryIO.Write.Method.STREAMING_INSERTS).useBeamSchema().withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{new TableRow().set("name", (Object)"a").set("number", (Object)"1"), new TableRow().set("name", (Object)"b").set("number", (Object)"2"), new TableRow().set("name", (Object)"c").set("number", (Object)"3"), new TableRow().set("name", (Object)"d").set("number", (Object)"4")}));
    }

    @Test
    public void testStreamingWriteWithDynamicTables() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testWriteWithDynamicTables(true);
    }

    @Test
    public void testBatchWriteWithDynamicTables() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testWriteWithDynamicTables(false);
    }

    public void testWriteWithDynamicTables(@UnknownKeyFor @NonNull @Initialized boolean streaming) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<Integer> inserts = new ArrayList<Integer>();
        for (int i2 = 0; i2 < 10; ++i2) {
            inserts.add(i2);
        }
        PartitionedGlobalWindows windowFn = new PartitionedGlobalWindows((SerializableFunction & Serializable)i -> Integer.toString(i % 5));
        HashMap targetTables = Maps.newHashMap();
        HashMap schemas = Maps.newHashMap();
        for (int i3 = 0; i3 < 5; ++i3) {
            TableDestination destination = new TableDestination("project-id:dataset-id.table-id-" + i3, "");
            targetTables.put(i3, destination);
            schemas.put(destination.getTableSpec(), BigQueryHelpers.toJsonString((Object)new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER"), (Object)new TableFieldSchema().setName("custom_" + i3).setType("STRING")))));
        }
        SerializableFunction & Serializable tableFunction = (SerializableFunction & Serializable)input -> {
            PartitionedGlobalWindow window = (PartitionedGlobalWindow)input.getWindow();
            Preconditions.checkArgument((boolean)window.value.equals(Integer.toString((Integer)input.getValue() % 5)), (Object)"Incorrect element");
            return (TableDestination)targetTables.get((Integer)input.getValue() % 5);
        };
        PCollection input2 = (PCollection)this.p.apply("CreateSource", (PTransform)Create.of(inserts));
        if (streaming) {
            input2 = input2.setIsBoundedInternal(PCollection.IsBounded.UNBOUNDED);
        }
        PCollectionView schemasView = (PCollectionView)((PCollection)this.p.apply("CreateSchemaMap", (PTransform)Create.of((Map)schemas))).apply("ViewSchemaAsMap", (PTransform)View.asMap());
        ((PCollection)input2.apply((PTransform)Window.into(windowFn))).apply((PTransform)BigQueryIO.write().to((SerializableFunction)tableFunction).withFormatFunction((SerializableFunction & Serializable)i -> new TableRow().set("name", (Object)("number" + i)).set("number", i)).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withSchemaFromView(schemasView).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.p.run();
        for (int i4 = 0; i4 < 5; ++i4) {
            String tableId = String.format("table-id-%d", i4);
            String tableSpec = String.format("project-id:dataset-id.%s", tableId);
            Assert.assertThat((Object)BigQueryHelpers.toJsonString((Object)this.fakeDatasetService.getTable(new TableReference().setProjectId("project-id").setDatasetId("dataset-id").setTableId(tableId)).getSchema()), (org.hamcrest.Matcher)Matchers.equalTo((Object)((String)schemas.get(tableSpec))));
            Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", tableId), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{new TableRow().set("name", (Object)String.format("number%d", i4)).set("number", (Object)i4), new TableRow().set("name", (Object)String.format("number%d", i4 + 5)).set("number", (Object)(i4 + 5))}));
        }
    }

    @Test
    public void testWriteUnknown() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1), (Object[])new TableRow[]{new TableRow().set("name", (Object)"b").set("number", (Object)2), new TableRow().set("name", (Object)"c").set("number", (Object)3)}).withCoder((Coder)TableRowJsonCoder.of()))).apply((PTransform)BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_NEVER).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Failed to create job");
        this.p.run();
    }

    @Test
    public void testWriteFailedJobs() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1), (Object[])new TableRow[]{new TableRow().set("name", (Object)"b").set("number", (Object)2), new TableRow().set("name", (Object)"c").set("number", (Object)3)}).withCoder((Coder)TableRowJsonCoder.of()))).apply((PTransform)BigQueryIO.writeTableRows().to("dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_NEVER).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Failed to create job with prefix");
        this.thrown.expectMessage("reached max retries");
        this.thrown.expectMessage("last failed job");
        this.p.run();
    }

    @Test
    public void testWriteWithMissingSchemaFromView() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PCollectionView view = (PCollectionView)((PCollection)this.p.apply("Create schema view", (PTransform)Create.of((Object)KV.of((Object)"foo", (Object)"bar"), (Object[])new KV[]{KV.of((Object)"bar", (Object)"boo")}))).apply((PTransform)View.asMap());
        ((PCollection)this.p.apply((PTransform)Create.empty((Coder)TableRowJsonCoder.of()))).apply((PTransform)BigQueryIO.writeTableRows().to("dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withSchemaFromView(view).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.thrown.expectMessage("does not contain data for table destination dataset-id.table-id");
        this.p.run();
    }

    @Test
    public void testWriteWithBrokenGetTable() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)new TableRow().set("foo", (Object)"bar"), (Object[])new TableRow[0]))).apply((PTransform)BigQueryIO.writeTableRows().to((SerializableFunction & Serializable)input -> null).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_NEVER).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation());
        this.thrown.expectMessage("result of tableFunction can not be null");
        this.thrown.expectMessage("foo");
        this.p.run();
    }

    @Test
    public void testWriteBuilderMethods() {
        BigQueryIO.Write write = BigQueryIO.writeTableRows().to("foo.com:project:somedataset.sometable");
        Assert.assertEquals((Object)"foo.com:project", (Object)((TableReference)write.getTable().get()).getProjectId());
        Assert.assertEquals((Object)"somedataset", (Object)((TableReference)write.getTable().get()).getDatasetId());
        Assert.assertEquals((Object)"sometable", (Object)((TableReference)write.getTable().get()).getTableId());
        Assert.assertNull((Object)write.getJsonSchema());
        Assert.assertNull((Object)write.getSchemaFromView());
        Assert.assertEquals((Object)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED, (Object)write.getCreateDisposition());
        Assert.assertEquals((Object)BigQueryIO.Write.WriteDisposition.WRITE_EMPTY, (Object)write.getWriteDisposition());
        Assert.assertEquals(null, (Object)write.getTableDescription());
        Assert.assertTrue((boolean)write.getValidate());
        Assert.assertFalse((boolean)write.withoutValidation().getValidate());
        TableSchema schema = new TableSchema();
        Assert.assertEquals((Object)schema, (Object)BigQueryHelpers.fromJsonString((String)((String)write.withSchema(schema).getJsonSchema().get()), TableSchema.class));
    }

    @Test
    public void testBuildWriteDefaultProject() {
        BigQueryIO.Write write = BigQueryIO.writeTableRows().to("somedataset.sometable");
        Assert.assertEquals(null, (Object)((TableReference)write.getTable().get()).getProjectId());
        Assert.assertEquals((Object)"somedataset", (Object)((TableReference)write.getTable().get()).getDatasetId());
        Assert.assertEquals((Object)"sometable", (Object)((TableReference)write.getTable().get()).getTableId());
    }

    @Test
    public void testBuildWriteWithTableReference() {
        TableReference table = new TableReference().setProjectId("foo.com:project").setDatasetId("somedataset").setTableId("sometable");
        BigQueryIO.Write write = BigQueryIO.writeTableRows().to(table);
        Assert.assertEquals((Object)"foo.com:project", (Object)((TableReference)write.getTable().get()).getProjectId());
        Assert.assertEquals((Object)"somedataset", (Object)((TableReference)write.getTable().get()).getDatasetId());
        Assert.assertEquals((Object)"sometable", (Object)((TableReference)write.getTable().get()).getTableId());
    }

    @Test
    public void testBuildWriteDisplayData() {
        String tableSpec = "project:dataset.table";
        TableSchema schema = new TableSchema().set("col1", (Object)"type1").set("col2", (Object)"type2");
        String tblDescription = "foo bar table";
        BigQueryIO.Write write = BigQueryIO.writeTableRows().to(tableSpec).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND).withSchemaUpdateOptions(EnumSet.of(BigQueryIO.Write.SchemaUpdateOption.ALLOW_FIELD_ADDITION)).withTableDescription("foo bar table").withoutValidation();
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)displayData, (org.hamcrest.Matcher)DisplayDataMatchers.hasDisplayItem((String)"table"));
        Assert.assertThat((Object)displayData, (org.hamcrest.Matcher)DisplayDataMatchers.hasDisplayItem((String)"schema"));
        Assert.assertThat((Object)displayData, (org.hamcrest.Matcher)DisplayDataMatchers.hasDisplayItem((String)"createDisposition", (String)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED.toString()));
        Assert.assertThat((Object)displayData, (org.hamcrest.Matcher)DisplayDataMatchers.hasDisplayItem((String)"writeDisposition", (String)BigQueryIO.Write.WriteDisposition.WRITE_APPEND.toString()));
        Assert.assertThat((Object)displayData, (org.hamcrest.Matcher)DisplayDataMatchers.hasDisplayItem((String)"schemaUpdateOptions", (String)EnumSet.of(BigQueryIO.Write.SchemaUpdateOption.ALLOW_FIELD_ADDITION).toString()));
        Assert.assertThat((Object)displayData, (org.hamcrest.Matcher)DisplayDataMatchers.hasDisplayItem((String)"tableDescription", (String)"foo bar table"));
        Assert.assertThat((Object)displayData, (org.hamcrest.Matcher)DisplayDataMatchers.hasDisplayItem((String)"validation", (Boolean)false));
    }

    private void testWriteValidatesDataset(@UnknownKeyFor @NonNull @Initialized boolean unbounded) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableReference tableRef = new TableReference();
        tableRef.setDatasetId("somedataset");
        tableRef.setTableId("sometable");
        PCollection tableRows = unbounded ? ((PCollection)((PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L))).apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Long, TableRow>(){

            public @UnknownKeyFor @NonNull @Initialized TableRow apply(@UnknownKeyFor @NonNull @Initialized Long input) {
                return null;
            }
        }))).setCoder((Coder)TableRowJsonCoder.of()) : (PCollection)this.p.apply((PTransform)Create.empty((Coder)TableRowJsonCoder.of()));
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage((org.hamcrest.Matcher)Matchers.either((org.hamcrest.Matcher)Matchers.containsString((String)"Unable to confirm BigQuery dataset presence")).or(Matchers.containsString((String)"BigQuery dataset not found for table")));
        tableRows.apply((PTransform)BigQueryIO.writeTableRows().to(tableRef).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withSchema(new TableSchema()).withTestServices((BigQueryServices)this.fakeBqServices));
        this.p.run();
    }

    @Test
    public void testWriteValidatesDatasetBatch() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testWriteValidatesDataset(false);
    }

    @Test
    public void testWriteValidatesDatasetStreaming() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.testWriteValidatesDataset(true);
    }

    @Test
    public void testCreateNeverWithStreaming() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.p.enableAbandonedNodeEnforcement(false);
        TableReference tableRef = new TableReference();
        tableRef.setDatasetId("dataset");
        tableRef.setTableId("sometable");
        PCollection tableRows = ((PCollection)((PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L))).apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Long, TableRow>(){

            public @UnknownKeyFor @NonNull @Initialized TableRow apply(@UnknownKeyFor @NonNull @Initialized Long input) {
                return null;
            }
        }))).setCoder((Coder)TableRowJsonCoder.of());
        tableRows.apply((PTransform)BigQueryIO.writeTableRows().to(tableRef).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_NEVER).withoutValidation());
    }

    @Test
    public void testBigQueryIOGetName() {
        Assert.assertEquals((Object)"BigQueryIO.Write", (Object)BigQueryIO.write().to("somedataset.sometable").getName());
    }

    @Test
    public void testWriteValidateFailsCreateNoSchema() {
        this.p.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("no schema was provided");
        ((PCollection)this.p.apply((PTransform)Create.empty((Coder)TableRowJsonCoder.of()))).apply((PTransform)BigQueryIO.writeTableRows().to("dataset.table").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED));
    }

    @Test
    public void testWriteValidateFailsNoFormatFunction() {
        this.p.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("A function must be provided to convert the input type into a TableRow or GenericRecord");
        ((PCollection)this.p.apply((PTransform)Create.empty(INPUT_RECORD_CODER))).apply((PTransform)BigQueryIO.write().to("dataset.table").withSchema(new TableSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED));
    }

    @Test
    public void testWriteValidateFailsBothFormatFunctions() {
        this.p.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Only one of withFormatFunction or withAvroFormatFunction/withAvroWriter maybe set, not both.");
        ((PCollection)this.p.apply((PTransform)Create.empty(INPUT_RECORD_CODER))).apply((PTransform)BigQueryIO.write().to("dataset.table").withSchema(new TableSchema()).withFormatFunction((SerializableFunction & Serializable)r -> new TableRow()).withAvroFormatFunction((SerializableFunction & Serializable)r -> new GenericData.Record(r.getSchema())).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED));
    }

    @Test
    public void testWriteValidateFailsWithBeamSchemaAndAvroFormatFunction() {
        this.p.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("avroFormatFunction is unsupported when using Beam schemas");
        ((PCollection)this.p.apply((PTransform)Create.of((Object)new SchemaPojo("a", 1), (Object[])new SchemaPojo[0]))).apply((PTransform)BigQueryIO.write().to("dataset.table").useBeamSchema().withAvroFormatFunction((SerializableFunction & Serializable)r -> new GenericData.Record(r.getSchema())).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED));
    }

    @Test
    public void testWriteValidateFailsWithAvroFormatAndStreamingInserts() {
        this.p.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Writing avro formatted data is only supported for FILE_LOADS");
        ((PCollection)this.p.apply((PTransform)Create.empty(INPUT_RECORD_CODER))).apply((PTransform)BigQueryIO.write().to("dataset.table").withSchema(new TableSchema()).withAvroFormatFunction((SerializableFunction & Serializable)r -> new GenericData.Record(r.getSchema())).withMethod(BigQueryIO.Write.Method.STREAMING_INSERTS).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED));
    }

    @Test
    public void testWritePartitionEmptyData() throws @UnknownKeyFor @NonNull @Initialized Exception {
        long numFiles = 0L;
        long fileSize = 0L;
        long expectedNumPartitions = 1L;
        this.testWritePartition(1L, numFiles, fileSize, expectedNumPartitions);
    }

    @Test
    public void testWritePartitionSinglePartition() throws @UnknownKeyFor @NonNull @Initialized Exception {
        long numFiles = 10000L;
        long fileSize = 1L;
        long expectedNumPartitions = 1L;
        this.testWritePartition(2L, numFiles, fileSize, expectedNumPartitions);
    }

    @Test
    public void testWritePartitionManyFiles() throws @UnknownKeyFor @NonNull @Initialized Exception {
        long numFiles = 30000L;
        long fileSize = 1L;
        long expectedNumPartitions = 3L;
        this.testWritePartition(2L, numFiles, fileSize, expectedNumPartitions);
    }

    @Test
    public void testWritePartitionLargeFileSize() throws @UnknownKeyFor @NonNull @Initialized Exception {
        long numFiles = 10L;
        long fileSize = 0x3AAAAAAAAAAL;
        long expectedNumPartitions = 4L;
        this.testWritePartition(2L, numFiles, fileSize, expectedNumPartitions);
    }

    private void testWritePartition(@UnknownKeyFor @NonNull @Initialized long numTables, @UnknownKeyFor @NonNull @Initialized long numFilesPerTable, @UnknownKeyFor @NonNull @Initialized long fileSize, @UnknownKeyFor @NonNull @Initialized long expectedNumPartitionsPerTable) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.p.enableAbandonedNodeEnforcement(false);
        boolean isSingleton = numTables == 1L && numFilesPerTable == 0L;
        DynamicDestinationsHelpers.ConstantTableDestinations dynamicDestinations = new DynamicDestinationsHelpers.ConstantTableDestinations((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"SINGLETON"), "");
        ArrayList expectedPartitions = Lists.newArrayList();
        if (isSingleton) {
            expectedPartitions.add(ShardedKey.of((Object)new TableDestination("SINGLETON", ""), (int)1));
        } else {
            int i = 0;
            while ((long)i < numTables) {
                int j = 1;
                while ((long)j <= expectedNumPartitionsPerTable) {
                    String tableName = String.format("project-id:dataset-id.tables%05d", i);
                    expectedPartitions.add(ShardedKey.of((Object)new TableDestination(tableName, ""), (int)j));
                    ++j;
                }
                ++i;
            }
        }
        ArrayList files = Lists.newArrayList();
        HashMap filenamesPerTable = Maps.newHashMap();
        int i = 0;
        while ((long)i < numTables) {
            String tableName = String.format("project-id:dataset-id.tables%05d", i);
            List filenames = filenamesPerTable.computeIfAbsent(tableName, k -> Lists.newArrayList());
            int j = 0;
            while ((long)j < numFilesPerTable) {
                String fileName = String.format("%s_files%05d", tableName, j);
                filenames.add(fileName);
                files.add(new WriteBundlesToFiles.Result(fileName, Long.valueOf(fileSize), (Object)new TableDestination(tableName, "")));
                ++j;
            }
            ++i;
        }
        TupleTag<KV<ShardedKey<TableDestination>, List<String>>> multiPartitionsTag = new TupleTag<KV<ShardedKey<TableDestination>, List<String>>>("multiPartitionsTag"){};
        TupleTag<KV<ShardedKey<TableDestination>, List<String>>> singlePartitionTag = new TupleTag<KV<ShardedKey<TableDestination>, List<String>>>("singlePartitionTag"){};
        String tempFilePrefix = this.testFolder.newFolder("BigQueryIOTest").getAbsolutePath();
        PCollectionView tempFilePrefixView = (PCollectionView)((PCollection)this.p.apply((PTransform)Create.of((Object)tempFilePrefix, (Object[])new String[0]))).apply((PTransform)View.asSingleton());
        WritePartition writePartition = new WritePartition(isSingleton, (DynamicDestinations)dynamicDestinations, tempFilePrefixView, 10000, 0xB0000000000L, (TupleTag)multiPartitionsTag, (TupleTag)singlePartitionTag, RowWriterFactory.tableRows((SerializableFunction)SerializableFunctions.identity(), (SerializableFunction)SerializableFunctions.identity()));
        DoFnTester tester = DoFnTester.of((DoFn)writePartition);
        tester.setSideInput(tempFilePrefixView, (BoundedWindow)GlobalWindow.INSTANCE, (Object)tempFilePrefix);
        tester.processElement((Object)files);
        List partitions = expectedNumPartitionsPerTable > 1L ? tester.takeOutputElements((TupleTag)multiPartitionsTag) : tester.takeOutputElements((TupleTag)singlePartitionTag);
        ArrayList partitionsResult = Lists.newArrayList();
        HashMap filesPerTableResult = Maps.newHashMap();
        for (KV partition : partitions) {
            String table = ((TableDestination)((ShardedKey)partition.getKey()).getKey()).getTableSpec();
            partitionsResult.add((ShardedKey)partition.getKey());
            List tableFilesResult = filesPerTableResult.computeIfAbsent(table, k -> Lists.newArrayList());
            tableFilesResult.addAll((Collection)partition.getValue());
        }
        Assert.assertThat((Object)partitionsResult, (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])((ShardedKey[])Iterables.toArray((Iterable)expectedPartitions, ShardedKey.class))));
        if (isSingleton) {
            Assert.assertEquals((long)1L, (long)filesPerTableResult.size());
            List singletonFiles = (List)filesPerTableResult.values().iterator().next();
            Assert.assertTrue((boolean)Files.exists(Paths.get((String)singletonFiles.get(0), new String[0]), new LinkOption[0]));
            Assert.assertThat((Object)Files.readAllBytes(Paths.get((String)singletonFiles.get(0), new String[0])).length, (org.hamcrest.Matcher)Matchers.equalTo((Object)0));
        } else {
            Assert.assertEquals((Object)filenamesPerTable, (Object)filesPerTableResult);
        }
        for (List filenames : filesPerTableResult.values()) {
            for (String filename : filenames) {
                Files.deleteIfExists(Paths.get(filename, new String[0]));
            }
        }
    }

    @Test
    public void testWriteTables() throws @UnknownKeyFor @NonNull @Initialized Exception {
        long numTables = 3L;
        long numPartitions = 3L;
        long numFilesPerPartition = 10L;
        String jobIdToken = "jobId";
        ArrayListMultimap expectedTempTables = ArrayListMultimap.create();
        ArrayList partitions = Lists.newArrayList();
        int i = 0;
        while ((long)i < numTables) {
            String tableName = String.format("project-id:dataset-id.table%05d", i);
            TableDestination tableDestination = new TableDestination(tableName, tableName);
            int j = 0;
            while ((long)j < numPartitions) {
                String tempTableId = BigQueryResourceNaming.createJobIdWithDestination((String)jobIdToken, (TableDestination)tableDestination, (int)j, (long)0L);
                ArrayList filesPerPartition = Lists.newArrayList();
                int k = 0;
                while ((long)k < numFilesPerPartition) {
                    TableRowWriter writer;
                    String filename = Paths.get(this.testFolder.getRoot().getAbsolutePath(), String.format("files0x%08x_%05d", tempTableId.hashCode(), k)).toString();
                    try (TableRowWriter ignored = writer = new TableRowWriter(filename, SerializableFunctions.identity());){
                        TableRow tableRow = new TableRow().set("name", (Object)tableName);
                        writer.write((Object)tableRow);
                    }
                    filesPerPartition.add(writer.getResult().resourceId.toString());
                    ++k;
                }
                partitions.add(KV.of((Object)ShardedKey.of((Object)tableDestination.getTableSpec(), (int)j), (Object)filesPerPartition));
                String json = String.format("{\"datasetId\":\"dataset-id\",\"projectId\":\"project-id\",\"tableId\":\"%s\"}", tempTableId);
                expectedTempTables.put((Object)tableDestination, (Object)json);
                ++j;
            }
            ++i;
        }
        PCollection writeTablesInput = (PCollection)this.p.apply((PTransform)Create.of((Iterable)partitions));
        PCollectionView jobIdTokenView = (PCollectionView)((PCollection)this.p.apply("CreateJobId", (PTransform)Create.of((Object)"jobId", (Object[])new String[0]))).apply((PTransform)View.asSingleton());
        ImmutableList sideInputs = ImmutableList.of((Object)jobIdTokenView);
        this.fakeJobService.setNumFailuresExpected(3);
        WriteTables writeTables = new WriteTables(true, (BigQueryServices)this.fakeBqServices, jobIdTokenView, BigQueryIO.Write.WriteDisposition.WRITE_EMPTY, BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED, (List)sideInputs, (DynamicDestinations)new IdentityDynamicTables(), null, 4, false, null, "NEWLINE_DELIMITED_JSON", false, Collections.emptySet());
        PCollection writeTablesOutput = (PCollection)writeTablesInput.apply((PTransform)writeTables);
        PAssert.thatMultimap((PCollection)writeTablesOutput).satisfies(arg_0 -> BigQueryIOWriteTest.lambda$testWriteTables$c020db9b$1((Multimap)expectedTempTables, arg_0));
        this.p.run();
    }

    @Test
    public void testRemoveTemporaryFiles() throws @UnknownKeyFor @NonNull @Initialized Exception {
        int numFiles = 10;
        ArrayList fileNames = Lists.newArrayList();
        String tempFilePrefix = this.options.getTempLocation() + "/";
        for (int i = 0; i < numFiles; ++i) {
            TableRowWriter writer = new TableRowWriter(tempFilePrefix, SerializableFunctions.identity());
            writer.close();
            fileNames.add(writer.getResult().resourceId.toString());
        }
        fileNames.add(tempFilePrefix + String.format("files%05d", numFiles));
        File tempDir = new File(this.options.getTempLocation());
        BigQueryIOWriteTest.testNumFiles(tempDir, 10);
        WriteTables.removeTemporaryFiles((Iterable)fileNames);
    }

    @Test
    public void testWriteRename() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.p.enableAbandonedNodeEnforcement(false);
        int numFinalTables = 3;
        int numTempTablesPerFinalTable = 3;
        int numRecordsPerTempTable = 10;
        ArrayListMultimap expectedRowsPerTable = ArrayListMultimap.create();
        String jobIdToken = "jobIdToken";
        ArrayListMultimap tempTables = ArrayListMultimap.create();
        ArrayList tempTablesElement = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            String tableName = "project-id:dataset-id.table_" + i;
            TableDestination tableDestination = new TableDestination(tableName, "table_" + i + "_desc");
            int j = 0;
            while (i < 3) {
                TableReference tempTable = new TableReference().setProjectId("project-id").setDatasetId("dataset-id").setTableId(String.format("%s_%05d_%05d", jobIdToken, i, j));
                this.fakeDatasetService.createTable(new Table().setTableReference(tempTable));
                ArrayList rows = Lists.newArrayList();
                for (int k = 0; k < 10; ++k) {
                    rows.add(new TableRow().set("number", (Object)(j * 3 + k)));
                }
                this.fakeDatasetService.insertAll(tempTable, (List)rows, null);
                expectedRowsPerTable.putAll((Object)tableDestination, (Iterable)rows);
                String tableJson = BigQueryHelpers.toJsonString((Object)tempTable);
                tempTables.put((Object)tableDestination, (Object)tableJson);
                tempTablesElement.add(KV.of((Object)tableDestination, (Object)tableJson));
                ++i;
            }
        }
        PCollectionView jobIdTokenView = (PCollectionView)((PCollection)this.p.apply("CreateJobId", (PTransform)Create.of((Object)"jobId", (Object[])new String[0]))).apply((PTransform)View.asSingleton());
        WriteRename writeRename = new WriteRename((BigQueryServices)this.fakeBqServices, jobIdTokenView, BigQueryIO.Write.WriteDisposition.WRITE_EMPTY, BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED, 3, "kms_key");
        DoFnTester tester = DoFnTester.of((DoFn)writeRename);
        tester.setSideInput(jobIdTokenView, (BoundedWindow)GlobalWindow.INSTANCE, (Object)jobIdToken);
        tester.processElement((Object)tempTablesElement);
        tester.finishBundle();
        for (Map.Entry entry : tempTables.asMap().entrySet()) {
            TableDestination tableDestination = (TableDestination)entry.getKey();
            TableReference tableReference = tableDestination.getTableReference();
            Table table = (Table)Preconditions.checkNotNull((Object)this.fakeDatasetService.getTable(tableReference));
            Assert.assertEquals((Object)(tableReference.getTableId() + "_desc"), (Object)tableDestination.getTableDescription());
            Assert.assertEquals((Object)"kms_key", (Object)table.getEncryptionConfiguration().getKmsKeyName());
            Collection expectedRows = expectedRowsPerTable.get((Object)tableDestination);
            Assert.assertThat((Object)this.fakeDatasetService.getAllRows(tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId()), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)expectedRows, TableRow.class))));
            for (String tempTableJson : (Collection)entry.getValue()) {
                TableReference tempTable = (TableReference)BigQueryHelpers.fromJsonString((String)tempTableJson, TableReference.class);
                Assert.assertEquals(null, (Object)this.fakeDatasetService.getTable(tempTable));
            }
        }
    }

    @Test
    public void testRemoveTemporaryTables() throws @UnknownKeyFor @NonNull @Initialized Exception {
        FakeDatasetService datasetService = new FakeDatasetService();
        String projectId = "project";
        String datasetId = "dataset";
        datasetService.createDataset(projectId, datasetId, "", "", null);
        ArrayList tableRefs = Lists.newArrayList((Object[])new TableReference[]{BigQueryHelpers.parseTableSpec((String)String.format("%s:%s.%s", projectId, datasetId, "table1")), BigQueryHelpers.parseTableSpec((String)String.format("%s:%s.%s", projectId, datasetId, "table2")), BigQueryHelpers.parseTableSpec((String)String.format("%s:%s.%s", projectId, datasetId, "table3"))});
        for (TableReference tableRef : tableRefs) {
            datasetService.createTable(new Table().setTableReference(tableRef));
        }
        tableRefs.add(BigQueryHelpers.parseTableSpec((String)String.format("%s:%s.%s", projectId, datasetId, "table4")));
        WriteRename.removeTemporaryTables((BigQueryServices.DatasetService)datasetService, (List)tableRefs);
        for (TableReference ref : tableRefs) {
            this.loggedWriteRename.verifyDebug("Deleting table " + BigQueryHelpers.toJsonString((Object)ref));
            Preconditions.checkState((datasetService.getTable(ref) == null ? 1 : 0) != 0, (Object)("Table " + ref + " was not deleted!"));
        }
    }

    @Test
    public void testRuntimeOptionsNotCalledInApplyOutput() {
        this.p.enableAbandonedNodeEnforcement(false);
        BigQueryIO.Write write = BigQueryIO.writeTableRows().to(this.p.newProvider((Object)"some-table")).withSchema((ValueProvider)ValueProvider.NestedValueProvider.of((ValueProvider)this.p.newProvider((Object)"some-schema"), (SerializableFunction)new BigQueryHelpers.JsonSchemaToTableSchema())).withoutValidation();
        ((PCollection)this.p.apply((PTransform)Create.empty((Coder)TableRowJsonCoder.of()))).apply((PTransform)write);
        DisplayData.from((HasDisplayData)write);
    }

    private static void testNumFiles(@UnknownKeyFor @NonNull @Initialized File tempDir, @UnknownKeyFor @NonNull @Initialized int expectedNumFiles) {
        Assert.assertEquals((long)expectedNumFiles, (long)tempDir.listFiles(File::isFile).length);
    }

    @Test
    public void testWriteToTableDecorator() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableRow row1 = new TableRow().set("name", (Object)"a").set("number", (Object)"1");
        TableRow row2 = new TableRow().set("name", (Object)"b").set("number", (Object)"2");
        TableSchema schema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("number").setType("INTEGER")));
        ((PCollection)this.p.apply((PTransform)Create.of((Object)row1, (Object[])new TableRow[]{row2}))).apply((PTransform)BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id$20171127").withTestServices((BigQueryServices)this.fakeBqServices).withMethod(BigQueryIO.Write.Method.STREAMING_INSERTS).withSchema(schema).withoutValidation());
        this.p.run();
    }

    @Test
    public void testExtendedErrorRetrieval() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableRow row1 = new TableRow().set("name", (Object)"a").set("number", (Object)"1");
        TableRow row2 = new TableRow().set("name", (Object)"b").set("number", (Object)"2");
        TableRow row3 = new TableRow().set("name", (Object)"c").set("number", (Object)"3");
        String tableSpec = "project-id:dataset-id.table-id";
        TableDataInsertAllResponse.InsertErrors ephemeralError = new TableDataInsertAllResponse.InsertErrors().setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout")));
        TableDataInsertAllResponse.InsertErrors persistentError = new TableDataInsertAllResponse.InsertErrors().setErrors((List)Lists.newArrayList((Object[])new ErrorProto[]{new ErrorProto().setReason("invalidQuery")}));
        this.fakeDatasetService.failOnInsert((Map)ImmutableMap.of((Object)row1, (Object)ImmutableList.of((Object)ephemeralError, (Object)ephemeralError), (Object)row2, (Object)ImmutableList.of((Object)ephemeralError, (Object)ephemeralError, (Object)persistentError)));
        PCollection failedRows = ((WriteResult)((PCollection)this.p.apply((PTransform)Create.of((Object)row1, (Object[])new TableRow[]{row2, row3}))).apply((PTransform)BigQueryIO.writeTableRows().to(tableSpec).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withMethod(BigQueryIO.Write.Method.STREAMING_INSERTS).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).withFailedInsertRetryPolicy(InsertRetryPolicy.retryTransientErrors()).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation().withExtendedErrorInfo())).getFailedInsertsWithErr();
        PAssert.that((PCollection)failedRows).containsInAnyOrder((Object[])new BigQueryInsertError[]{new BigQueryInsertError(row2, persistentError, BigQueryHelpers.parseTableSpec((String)tableSpec))});
        this.p.run();
        Assert.assertThat((Object)this.fakeDatasetService.getAllRows("project-id", "dataset-id", "table-id"), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new TableRow[]{row1, row3}));
    }

    @Test
    public void testWrongErrorConfigs() {
        this.p.enableAutoRunIfMissing(true);
        TableRow row1 = new TableRow().set("name", (Object)"a").set("number", (Object)"1");
        BigQueryIO.Write bqIoWrite = BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withMethod(BigQueryIO.Write.Method.STREAMING_INSERTS).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).withFailedInsertRetryPolicy(InsertRetryPolicy.retryTransientErrors()).withTestServices((BigQueryServices)this.fakeBqServices).withoutValidation();
        try {
            ((WriteResult)((PCollection)this.p.apply("Create1", (PTransform)Create.of((Object)row1, (Object[])new TableRow[0]))).apply("Write 1", (PTransform)bqIoWrite)).getFailedInsertsWithErr();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (org.hamcrest.Matcher)Matchers.is((Object)"Cannot use getFailedInsertsWithErr as this WriteResult does not use extended errors. Use getFailedInserts instead"));
        }
        try {
            ((WriteResult)((PCollection)this.p.apply("Create2", (PTransform)Create.of((Object)row1, (Object[])new TableRow[0]))).apply("Write2", (PTransform)bqIoWrite.withExtendedErrorInfo())).getFailedInserts();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (org.hamcrest.Matcher)Matchers.is((Object)"Cannot use getFailedInserts as this WriteResult uses extended errors information. Use getFailedInsertsWithErr instead"));
        }
    }

    void schemaUpdateOptionsTest(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.Method insertMethod, @UnknownKeyFor @NonNull @Initialized Set<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableRow row = new TableRow().set("date", (Object)"2019-01-01").set("number", (Object)"1");
        TableSchema schema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("date").setType("DATE").setName("number").setType("INTEGER")));
        BigQueryIO.Write writeTransform = BigQueryIO.writeTableRows().to("project-id:dataset-id.table-id").withTestServices((BigQueryServices)this.fakeBqServices).withMethod(insertMethod).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND).withSchemaUpdateOptions(schemaUpdateOptions);
        ((PCollection)this.p.apply((PTransform)Create.of((Object)row, (Object[])new TableRow[0]))).apply((PTransform)writeTransform);
        this.p.run();
        List expectedOptions = schemaUpdateOptions.stream().map(Enum::name).collect(Collectors.toList());
        for (Job job : this.fakeJobService.getAllJobs()) {
            JobConfigurationLoad configuration = job.getConfiguration().getLoad();
            Assert.assertEquals(expectedOptions, (Object)configuration.getSchemaUpdateOptions());
        }
    }

    @Test
    public void testWriteFileSchemaUpdateOptionAllowFieldAddition() throws @UnknownKeyFor @NonNull @Initialized Exception {
        EnumSet<BigQueryIO.Write.SchemaUpdateOption> options = EnumSet.of(BigQueryIO.Write.SchemaUpdateOption.ALLOW_FIELD_ADDITION);
        this.schemaUpdateOptionsTest(BigQueryIO.Write.Method.FILE_LOADS, options);
    }

    @Test
    public void testWriteFileSchemaUpdateOptionAllowFieldRelaxation() throws @UnknownKeyFor @NonNull @Initialized Exception {
        EnumSet<BigQueryIO.Write.SchemaUpdateOption> options = EnumSet.of(BigQueryIO.Write.SchemaUpdateOption.ALLOW_FIELD_RELAXATION);
        this.schemaUpdateOptionsTest(BigQueryIO.Write.Method.FILE_LOADS, options);
    }

    @Test
    public void testWriteFileSchemaUpdateOptionAll() throws @UnknownKeyFor @NonNull @Initialized Exception {
        EnumSet<BigQueryIO.Write.SchemaUpdateOption> options = EnumSet.allOf(BigQueryIO.Write.SchemaUpdateOption.class);
        this.schemaUpdateOptionsTest(BigQueryIO.Write.Method.FILE_LOADS, options);
    }

    @Test
    public void testSchemaUpdateOptionsFailsStreamingInserts() throws @UnknownKeyFor @NonNull @Initialized Exception {
        EnumSet<BigQueryIO.Write.SchemaUpdateOption> options = EnumSet.of(BigQueryIO.Write.SchemaUpdateOption.ALLOW_FIELD_ADDITION);
        this.p.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("SchemaUpdateOptions are not supported when method == STREAMING_INSERTS");
        this.schemaUpdateOptionsTest(BigQueryIO.Write.Method.STREAMING_INSERTS, options);
    }

    private static /* synthetic */ Void lambda$testWriteTables$c020db9b$1(Multimap expectedTempTables, Map input) {
        Assert.assertEquals(input.keySet(), (Object)expectedTempTables.keySet());
        for (Map.Entry entry : input.entrySet()) {
            Object[] expectedValues = (String[])Iterables.toArray((Iterable)expectedTempTables.get((Object)((TableDestination)entry.getKey())), String.class);
            Assert.assertThat((Object)((Iterable)entry.getValue()), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])expectedValues));
        }
        return null;
    }

    static class IdentityDynamicTables
    extends DynamicDestinations<String, String> {
        IdentityDynamicTables() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getDestination(@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized String> element) {
            throw new UnsupportedOperationException("getDestination not expected in this test.");
        }

        public @UnknownKeyFor @NonNull @Initialized TableDestination getTable(@UnknownKeyFor @NonNull @Initialized String destination) {
            return new TableDestination(destination, destination);
        }

        public @UnknownKeyFor @NonNull @Initialized TableSchema getSchema(@UnknownKeyFor @NonNull @Initialized String destination) {
            return new TableSchema();
        }
    }

    private static class PartitionedGlobalWindowCoder
    extends AtomicCoder<PartitionedGlobalWindow> {
        private PartitionedGlobalWindowCoder() {
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized PartitionedGlobalWindow window, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(window, outStream, Coder.Context.NESTED);
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized PartitionedGlobalWindow window, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            StringUtf8Coder.of().encode(window.value, outStream, context);
        }

        public @UnknownKeyFor @NonNull @Initialized PartitionedGlobalWindow decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        public @UnknownKeyFor @NonNull @Initialized PartitionedGlobalWindow decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return new PartitionedGlobalWindow(StringUtf8Coder.of().decode(inStream, context));
        }

        public void verifyDeterministic() {
        }
    }

    private static class PartitionedGlobalWindow
    extends BoundedWindow {
        @UnknownKeyFor @NonNull @Initialized String value;

        public PartitionedGlobalWindow(@UnknownKeyFor @NonNull @Initialized String value) {
            this.value = value;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant maxTimestamp() {
            return GlobalWindow.INSTANCE.maxTimestamp();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other instanceof PartitionedGlobalWindow) {
                return this.value.equals(((PartitionedGlobalWindow)((Object)other)).value);
            }
            return false;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.value.hashCode();
        }
    }

    private static class PartitionedGlobalWindows<@UnknownKeyFor T>
    extends NonMergingWindowFn<T, PartitionedGlobalWindow> {
        private @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized String> extractPartition;

        public PartitionedGlobalWindows(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized String> extractPartition) {
            this.extractPartition = extractPartition;
        }

        public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PartitionedGlobalWindow> assignWindows(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized AssignContext c) {
            return Collections.singletonList(new PartitionedGlobalWindow((String)this.extractPartition.apply(c.element())));
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> o) {
            return o instanceof PartitionedGlobalWindows;
        }

        public void verifyCompatibility(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
            if (!this.isCompatible(other)) {
                throw new IncompatibleWindowException(other, String.format("%s is only compatible with %s.", PartitionedGlobalWindows.class.getSimpleName(), PartitionedGlobalWindows.class.getSimpleName()));
            }
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PartitionedGlobalWindow> windowCoder() {
            return new PartitionedGlobalWindowCoder();
        }

        public @UnknownKeyFor @NonNull @Initialized WindowMappingFn<@UnknownKeyFor @NonNull @Initialized PartitionedGlobalWindow> getDefaultWindowMappingFn() {
            throw new UnsupportedOperationException("PartitionedGlobalWindows is not allowed in side inputs");
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getOutputTime(@UnknownKeyFor @NonNull @Initialized Instant inputTimestamp, @UnknownKeyFor @NonNull @Initialized PartitionedGlobalWindow window) {
            return inputTimestamp;
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    static class SchemaPojo {
        final @UnknownKeyFor @NonNull @Initialized String name;
        final @UnknownKeyFor @NonNull @Initialized int number;

        @SchemaCreate
        SchemaPojo(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized int number) {
            this.name = name;
            this.number = number;
        }
    }

    @AutoValue
    static abstract class InputRecord
    implements Serializable {
        InputRecord() {
        }

        public static @UnknownKeyFor @NonNull @Initialized InputRecord create(@UnknownKeyFor @NonNull @Initialized String strValue, @UnknownKeyFor @NonNull @Initialized long longVal, @UnknownKeyFor @NonNull @Initialized double doubleVal, @UnknownKeyFor @NonNull @Initialized Instant instantVal) {
            return new AutoValue_BigQueryIOWriteTest_InputRecord(strValue, longVal, doubleVal, instantVal);
        }

        abstract @UnknownKeyFor @NonNull @Initialized String strVal();

        abstract @UnknownKeyFor @NonNull @Initialized long longVal();

        abstract @UnknownKeyFor @NonNull @Initialized double doubleVal();

        abstract @UnknownKeyFor @NonNull @Initialized Instant instantVal();
    }

    static abstract class StringLongDestinations
    extends DynamicDestinations<String, Long> {
        StringLongDestinations() {
        }
    }
}

