/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.services.bigquery.model.Streamingbuffer;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.AvroRows;
import com.google.cloud.bigquery.storage.v1.AvroSchema;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.StreamStats;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.protobuf.ByteStringCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageStreamSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageTableSource;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.testing.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigQueryIOStorageReadTest {
    private transient @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
    private final transient @UnknownKeyFor @NonNull @Initialized TemporaryFolder testFolder = new TemporaryFolder();
    private transient @UnknownKeyFor @NonNull @Initialized TestPipeline p;
    @Rule
    public final transient @UnknownKeyFor @NonNull @Initialized TestRule folderThenPipeline = new TestRule(){

        public @UnknownKeyFor @NonNull @Initialized Statement apply(final @UnknownKeyFor @NonNull @Initialized Statement base, final @UnknownKeyFor @NonNull @Initialized Description description) {
            Statement withPipeline = new Statement(){

                public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    BigQueryIOStorageReadTest.this.options = TestPipeline.testingPipelineOptions();
                    ((BigQueryOptions)BigQueryIOStorageReadTest.this.options.as(BigQueryOptions.class)).setProject("project-id");
                    ((BigQueryOptions)BigQueryIOStorageReadTest.this.options.as(BigQueryOptions.class)).setTempLocation(BigQueryIOStorageReadTest.this.testFolder.getRoot().getAbsolutePath());
                    BigQueryIOStorageReadTest.this.p = TestPipeline.fromOptions((PipelineOptions)BigQueryIOStorageReadTest.this.options);
                    BigQueryIOStorageReadTest.this.p.apply(base, description).evaluate();
                }
            };
            return BigQueryIOStorageReadTest.this.testFolder.apply(withPipeline, description);
        }
    };
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();
    private final @UnknownKeyFor @NonNull @Initialized FakeDatasetService fakeDatasetService = new FakeDatasetService();
    private static final @UnknownKeyFor @NonNull @Initialized String AVRO_SCHEMA_STRING = "{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"RowRecord\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"number\", \"type\": \"long\"}\n ]\n}";
    private static final @UnknownKeyFor @NonNull @Initialized Schema AVRO_SCHEMA = new Schema.Parser().parse("{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"RowRecord\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"number\", \"type\": \"long\"}\n ]\n}");
    private static final @UnknownKeyFor @NonNull @Initialized String TRIMMED_AVRO_SCHEMA_STRING = "{\"namespace\": \"example.avro\",\n\"type\": \"record\",\n\"name\": \"RowRecord\",\n\"fields\": [\n    {\"name\": \"name\", \"type\": \"string\"}\n ]\n}";
    private static final @UnknownKeyFor @NonNull @Initialized Schema TRIMMED_AVRO_SCHEMA = new Schema.Parser().parse("{\"namespace\": \"example.avro\",\n\"type\": \"record\",\n\"name\": \"RowRecord\",\n\"fields\": [\n    {\"name\": \"name\", \"type\": \"string\"}\n ]\n}");
    private static final @UnknownKeyFor @NonNull @Initialized TableSchema TABLE_SCHEMA = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("number").setType("INTEGER").setMode("REQUIRED")));
    private static final @UnknownKeyFor @NonNull @Initialized EncoderFactory ENCODER_FACTORY = EncoderFactory.get();
    private static final @UnknownKeyFor @NonNull @Initialized double DELTA = 1.0E-6;

    @Before
    public void setUp() throws @UnknownKeyFor @NonNull @Initialized Exception {
        FakeDatasetService.setUp();
    }

    @Test
    public void testBuildTableBasedSource() {
        BigQueryIO.TypedRead typedRead = BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).withCoder((Coder)TableRowJsonCoder.of()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).from("foo.com:project:dataset.table");
        this.checkTypedReadTableObject(typedRead, "foo.com:project", "dataset", "table");
        Assert.assertTrue((boolean)typedRead.getValidate());
    }

    @Test
    public void testBuildTableBasedSourceWithoutValidation() {
        BigQueryIO.TypedRead typedRead = BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).withCoder((Coder)TableRowJsonCoder.of()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).from("foo.com:project:dataset.table").withoutValidation();
        this.checkTypedReadTableObject(typedRead, "foo.com:project", "dataset", "table");
        Assert.assertFalse((boolean)typedRead.getValidate());
    }

    @Test
    public void testBuildTableBasedSourceWithDefaultProject() {
        BigQueryIO.TypedRead typedRead = BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).withCoder((Coder)TableRowJsonCoder.of()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).from("myDataset.myTable");
        this.checkTypedReadTableObject(typedRead, null, "myDataset", "myTable");
    }

    @Test
    public void testBuildTableBasedSourceWithTableReference() {
        TableReference tableReference = new TableReference().setProjectId("foo.com:project").setDatasetId("dataset").setTableId("table");
        BigQueryIO.TypedRead typedRead = BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).withCoder((Coder)TableRowJsonCoder.of()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).from(tableReference);
        this.checkTypedReadTableObject(typedRead, "foo.com:project", "dataset", "table");
    }

    private void checkTypedReadTableObject(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typedRead, @UnknownKeyFor @NonNull @Initialized String project, @UnknownKeyFor @NonNull @Initialized String dataset, @UnknownKeyFor @NonNull @Initialized String table) {
        Assert.assertEquals((Object)project, (Object)typedRead.getTable().getProjectId());
        Assert.assertEquals((Object)dataset, (Object)typedRead.getTable().getDatasetId());
        Assert.assertEquals((Object)table, (Object)typedRead.getTable().getTableId());
        Assert.assertNull((Object)typedRead.getQuery());
        Assert.assertEquals((Object)BigQueryIO.TypedRead.Method.DIRECT_READ, (Object)typedRead.getMethod());
    }

    @Test
    public void testBuildSourceWithTableAndFlatten() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
        this.p.apply("ReadMyTable", (PTransform)BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).withCoder((Coder)TableRowJsonCoder.of()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).from("foo.com:project:dataset.table").withoutResultFlattening());
        this.p.run();
    }

    @Test
    public void testBuildSourceWithTableAndSqlDialect() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid BigQueryIO.Read: Specifies a table with a SQL dialect preference, which only applies to queries");
        this.p.apply("ReadMyTable", (PTransform)BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).withCoder((Coder)TableRowJsonCoder.of()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).from("foo.com:project:dataset.table").usingStandardSql());
        this.p.run();
    }

    @Test
    public void testDisplayData() {
        String tableSpec = "foo.com:project:dataset.table";
        BigQueryIO.TypedRead typedRead = BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).withCoder((Coder)TableRowJsonCoder.of()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).from(tableSpec);
        DisplayData displayData = DisplayData.from((HasDisplayData)typedRead);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"table", (String)tableSpec));
    }

    @Test
    public void testName() {
        Assert.assertEquals((Object)"BigQueryIO.TypedRead", (Object)BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).withCoder((Coder)TableRowJsonCoder.of()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).from("foo.com:project:dataset.table").getName());
    }

    @Test
    public void testCoderInference() {
        SerializableFunction<SchemaAndRecord, KV<ByteString, ReadSession>> parseFn = new SerializableFunction<SchemaAndRecord, KV<ByteString, ReadSession>>(){

            public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ReadSession> apply(@UnknownKeyFor @NonNull @Initialized SchemaAndRecord input) {
                return null;
            }
        };
        Assert.assertEquals((Object)KvCoder.of((Coder)ByteStringCoder.of(), (Coder)ProtoCoder.of(ReadSession.class)), (Object)BigQueryIO.read((SerializableFunction)parseFn).inferCoder(CoderRegistry.createDefault()));
    }

    @Test
    public void testTableSourceEstimatedSize() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.doTableSourceEstimatedSizeTest(false);
    }

    @Test
    public void testTableSourceEstimatedSize_IgnoresStreamingBuffer() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.doTableSourceEstimatedSizeTest(true);
    }

    private void doTableSourceEstimatedSizeTest(@UnknownKeyFor @NonNull @Initialized boolean useStreamingBuffer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.fakeDatasetService.createDataset("foo.com:project", "dataset", "", "", null);
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)"foo.com:project:dataset.table");
        Table table = new Table().setTableReference(tableRef).setNumBytes(Long.valueOf(100L));
        if (useStreamingBuffer) {
            table.setStreamingBuffer(new Streamingbuffer().setEstimatedBytes(BigInteger.TEN));
        }
        this.fakeDatasetService.createTable(table);
        BigQueryStorageTableSource tableSource = BigQueryStorageTableSource.create((ValueProvider)ValueProvider.StaticValueProvider.of((Object)tableRef), null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService));
        Assert.assertEquals((long)100L, (long)tableSource.getEstimatedSizeBytes(this.options));
    }

    @Test
    public void testTableSourceEstimatedSize_WithDefaultProject() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.fakeDatasetService.createDataset("project-id", "dataset", "", "", null);
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)"project-id:dataset.table");
        Table table = new Table().setTableReference(tableRef).setNumBytes(Long.valueOf(100L));
        this.fakeDatasetService.createTable(table);
        BigQueryStorageTableSource tableSource = BigQueryStorageTableSource.create((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.parseTableSpec((String)"dataset.table")), null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService));
        Assert.assertEquals((long)100L, (long)tableSource.getEstimatedSizeBytes(this.options));
    }

    @Test
    public void testTableSourceInitialSplit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.doTableSourceInitialSplitTest(1024L, 1024);
    }

    @Test
    public void testTableSourceInitialSplit_MinSplitCount() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.doTableSourceInitialSplitTest(0x100000L, 10);
    }

    @Test
    public void testTableSourceInitialSplit_MaxSplitCount() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.doTableSourceInitialSplitTest(10L, 10000);
    }

    private void doTableSourceInitialSplitTest(@UnknownKeyFor @NonNull @Initialized long bundleSize, @UnknownKeyFor @NonNull @Initialized int streamCount) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.fakeDatasetService.createDataset("foo.com:project", "dataset", "", "", null);
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)"foo.com:project:dataset.table");
        Table table = new Table().setTableReference(tableRef).setNumBytes(Long.valueOf(0x100000L)).setSchema(TABLE_SCHEMA);
        this.fakeDatasetService.createTable(table);
        CreateReadSessionRequest expectedRequest = CreateReadSessionRequest.newBuilder().setParent("projects/project-id").setReadSession(ReadSession.newBuilder().setTable("projects/foo.com:project/datasets/dataset/tables/table").setDataFormat(DataFormat.AVRO)).setMaxStreamCount(streamCount).build();
        ReadSession.Builder builder = ReadSession.newBuilder().setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING));
        for (int i = 0; i < streamCount; ++i) {
            builder.addStreams(ReadStream.newBuilder().setName("stream-" + i));
        }
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.createReadSession(expectedRequest)).thenReturn((Object)builder.build());
        BigQueryStorageTableSource tableSource = BigQueryStorageTableSource.create((ValueProvider)ValueProvider.StaticValueProvider.of((Object)tableRef), null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withStorageClient(fakeStorageClient));
        List sources = tableSource.split(bundleSize, this.options);
        Assert.assertEquals((long)streamCount, (long)sources.size());
    }

    @Test
    public void testTableSourceInitialSplit_WithSelectedFieldsAndRowRestriction() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.fakeDatasetService.createDataset("foo.com:project", "dataset", "", "", null);
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)"foo.com:project:dataset.table");
        Table table = new Table().setTableReference(tableRef).setNumBytes(Long.valueOf(100L)).setSchema(TABLE_SCHEMA);
        this.fakeDatasetService.createTable(table);
        CreateReadSessionRequest expectedRequest = CreateReadSessionRequest.newBuilder().setParent("projects/project-id").setReadSession(ReadSession.newBuilder().setTable("projects/foo.com:project/datasets/dataset/tables/table").setDataFormat(DataFormat.AVRO).setReadOptions(ReadSession.TableReadOptions.newBuilder().addSelectedFields("name").setRowRestriction("number > 5"))).setMaxStreamCount(10).build();
        ReadSession.Builder builder = ReadSession.newBuilder().setAvroSchema(AvroSchema.newBuilder().setSchema(TRIMMED_AVRO_SCHEMA_STRING));
        for (int i = 0; i < 10; ++i) {
            builder.addStreams(ReadStream.newBuilder().setName("stream-" + i));
        }
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.createReadSession(expectedRequest)).thenReturn((Object)builder.build());
        BigQueryStorageTableSource tableSource = BigQueryStorageTableSource.create((ValueProvider)ValueProvider.StaticValueProvider.of((Object)tableRef), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)Lists.newArrayList((Object[])new String[]{"name"})), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)"number > 5"), (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withStorageClient(fakeStorageClient));
        List sources = tableSource.split(10L, this.options);
        Assert.assertEquals((long)10L, (long)sources.size());
    }

    @Test
    public void testTableSourceInitialSplit_WithDefaultProject() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.fakeDatasetService.createDataset("project-id", "dataset", "", "", null);
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)"project-id:dataset.table");
        Table table = new Table().setTableReference(tableRef).setNumBytes(Long.valueOf(0x100000L)).setSchema(TABLE_SCHEMA);
        this.fakeDatasetService.createTable(table);
        CreateReadSessionRequest expectedRequest = CreateReadSessionRequest.newBuilder().setParent("projects/project-id").setReadSession(ReadSession.newBuilder().setTable("projects/project-id/datasets/dataset/tables/table").setDataFormat(DataFormat.AVRO)).setMaxStreamCount(1024).build();
        ReadSession.Builder builder = ReadSession.newBuilder().setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING));
        for (int i = 0; i < 50; ++i) {
            builder.addStreams(ReadStream.newBuilder().setName("stream-" + i));
        }
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.createReadSession(expectedRequest)).thenReturn((Object)builder.build());
        BigQueryStorageTableSource tableSource = BigQueryStorageTableSource.create((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.parseTableSpec((String)"dataset.table")), null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withStorageClient(fakeStorageClient));
        List sources = tableSource.split(1024L, this.options);
        Assert.assertEquals((long)50L, (long)sources.size());
    }

    @Test
    public void testTableSourceInitialSplit_EmptyTable() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.fakeDatasetService.createDataset("foo.com:project", "dataset", "", "", null);
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)"foo.com:project:dataset.table");
        Table table = new Table().setTableReference(tableRef).setNumBytes(Long.valueOf(0x100000L)).setSchema(new TableSchema());
        this.fakeDatasetService.createTable(table);
        CreateReadSessionRequest expectedRequest = CreateReadSessionRequest.newBuilder().setParent("projects/project-id").setReadSession(ReadSession.newBuilder().setTable("projects/foo.com:project/datasets/dataset/tables/table").setDataFormat(DataFormat.AVRO)).setMaxStreamCount(1024).build();
        ReadSession emptyReadSession = ReadSession.newBuilder().build();
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.createReadSession(expectedRequest)).thenReturn((Object)emptyReadSession);
        BigQueryStorageTableSource tableSource = BigQueryStorageTableSource.create((ValueProvider)ValueProvider.StaticValueProvider.of((Object)tableRef), null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withStorageClient(fakeStorageClient));
        List sources = tableSource.split(1024L, this.options);
        Assert.assertTrue((boolean)sources.isEmpty());
    }

    @Test
    public void testTableSourceCreateReader() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryStorageTableSource tableSource = BigQueryStorageTableSource.create((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.parseTableSpec((String)"foo.com:project:dataset.table")), null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService));
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("BigQuery storage source must be split before reading");
        tableSource.createReader(this.options);
    }

    private static @UnknownKeyFor @NonNull @Initialized GenericRecord createRecord(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        GenericData.Record genericRecord = new GenericData.Record(schema);
        genericRecord.put("name", (Object)name);
        return genericRecord;
    }

    private static @UnknownKeyFor @NonNull @Initialized GenericRecord createRecord(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized long number, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        GenericData.Record genericRecord = new GenericData.Record(schema);
        genericRecord.put("name", (Object)name);
        genericRecord.put("number", (Object)number);
        return genericRecord;
    }

    private static @UnknownKeyFor @NonNull @Initialized ReadRowsResponse createResponse(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized GenericRecord> genericRecords, @UnknownKeyFor @NonNull @Initialized double progressAtResponseStart, @UnknownKeyFor @NonNull @Initialized double progressAtResponseEnd) throws @UnknownKeyFor @NonNull @Initialized Exception {
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryEncoder binaryEncoder = ENCODER_FACTORY.binaryEncoder((OutputStream)outputStream, null);
        for (GenericRecord genericRecord : genericRecords) {
            writer.write((Object)genericRecord, (Encoder)binaryEncoder);
        }
        binaryEncoder.flush();
        return ReadRowsResponse.newBuilder().setAvroRows(AvroRows.newBuilder().setSerializedBinaryRows(ByteString.copyFrom((byte[])outputStream.toByteArray())).setRowCount((long)genericRecords.size())).setRowCount((long)genericRecords.size()).setStats(StreamStats.newBuilder().setProgress(StreamStats.Progress.newBuilder().setAtResponseStart(progressAtResponseStart).setAtResponseEnd(progressAtResponseEnd))).build();
    }

    @Test
    public void testStreamSourceEstimatedSizeBytes() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create((ReadSession)ReadSession.getDefaultInstance(), (ReadStream)ReadStream.getDefaultInstance(), (TableSchema)TABLE_SCHEMA, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices());
        Assert.assertEquals((long)0L, (long)streamSource.getEstimatedSizeBytes(this.options));
    }

    @Test
    public void testStreamSourceSplit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create((ReadSession)ReadSession.getDefaultInstance(), (ReadStream)ReadStream.getDefaultInstance(), (TableSchema)TABLE_SCHEMA, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices());
        MatcherAssert.assertThat((Object)streamSource.split(0L, this.options), (Matcher)Matchers.containsInAnyOrder((Object[])new BoundedSource[]{streamSource}));
    }

    @Test
    public void testReadFromStreamSource() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ReadSession readSession = ReadSession.newBuilder().setName("readSession").setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING)).build();
        ReadRowsRequest expectedRequest = ReadRowsRequest.newBuilder().setReadStream("readStream").build();
        ArrayList records = Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("A", 1L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("B", 2L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA)});
        ArrayList responses = Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(0, 2), 0.0, 0.5), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(2, 3), 0.5, 0.75)});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.readRows(expectedRequest)).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)responses));
        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create((ReadSession)readSession, (ReadStream)ReadStream.newBuilder().setName("readStream").build(), (TableSchema)TABLE_SCHEMA, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withStorageClient(fakeStorageClient));
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        BigQueryStorageStreamSource.BigQueryStorageStreamReader reader = streamSource.createReader(this.options);
        boolean hasNext = reader.start();
        while (hasNext) {
            rows.add((TableRow)reader.getCurrent());
            hasNext = reader.advance();
        }
        System.out.println("Rows: " + rows);
        Assert.assertEquals((long)3L, (long)rows.size());
    }

    @Test
    public void testFractionConsumed() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ReadSession readSession = ReadSession.newBuilder().setName("readSession").setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING)).build();
        ReadRowsRequest expectedRequest = ReadRowsRequest.newBuilder().setReadStream("readStream").build();
        ArrayList records = Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("A", 1L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("B", 2L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("D", 4L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("E", 5L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("F", 6L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("G", 7L, AVRO_SCHEMA)});
        ArrayList responses = Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(0, 2), 0.0, 0.25), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList(), 0.25, 0.25), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(2, 4), 0.3, 0.5), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(4, 7), 0.7, 1.0)});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.readRows(expectedRequest)).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)responses));
        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create((ReadSession)readSession, (ReadStream)ReadStream.newBuilder().setName("readStream").build(), (TableSchema)TABLE_SCHEMA, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withStorageClient(fakeStorageClient));
        ArrayList rows = new ArrayList();
        BigQueryStorageStreamSource.BigQueryStorageStreamReader reader = streamSource.createReader(this.options);
        Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.start());
        Assert.assertEquals((double)0.125, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((double)0.25, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((double)0.4, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((double)0.5, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((double)0.8, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((double)0.9, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertFalse((boolean)reader.advance());
        Assert.assertEquals((Object)1.0, (Object)reader.getFractionConsumed());
    }

    @Test
    public void testFractionConsumedWithSplit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ReadSession readSession = ReadSession.newBuilder().setName("readSession").setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING)).build();
        ReadRowsRequest expectedRequest = ReadRowsRequest.newBuilder().setReadStream("parentStream").build();
        ArrayList records = Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("A", 1L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("B", 2L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("D", 4L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("E", 5L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("F", 6L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("G", 7L, AVRO_SCHEMA)});
        ArrayList parentResponses = Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(0, 2), 0.0, 0.25), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(2, 4), 0.3, 0.5), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(4, 7), 0.8, 0.875)});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.readRows(expectedRequest)).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)parentResponses));
        Mockito.when((Object)fakeStorageClient.splitReadStream(SplitReadStreamRequest.newBuilder().setName("parentStream").setFraction(0.5).build())).thenReturn((Object)SplitReadStreamResponse.newBuilder().setPrimaryStream(ReadStream.newBuilder().setName("primaryStream")).setRemainderStream(ReadStream.newBuilder().setName("remainderStream")).build());
        ArrayList primaryResponses = Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(1, 3), 0.25, 0.75), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(3, 4), 0.8, 1.0)});
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream("primaryStream").setOffset(1L).build())).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)primaryResponses));
        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create((ReadSession)readSession, (ReadStream)ReadStream.newBuilder().setName("parentStream").build(), (TableSchema)TABLE_SCHEMA, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withStorageClient(fakeStorageClient));
        ArrayList rows = new ArrayList();
        BigQueryStorageStreamSource.BigQueryStorageStreamReader reader = streamSource.createReader(this.options);
        Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.start());
        Assert.assertEquals((double)0.125, (double)reader.getFractionConsumed(), (double)1.0E-6);
        reader.splitAtFraction(0.5);
        Assert.assertEquals((double)0.125, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((double)0.5, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((double)0.75, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
        Assert.assertFalse((boolean)reader.advance());
        Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
    }

    @Test
    public void testStreamSourceSplitAtFractionSucceeds() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList parentResponses = Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("A", 1L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("B", 2L, AVRO_SCHEMA)}), 0.0, 0.25), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA)}), 0.25, 0.5), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("D", 4L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("E", 5L, AVRO_SCHEMA)}), 0.5, 0.75)});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream("parentStream").build())).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)parentResponses));
        Mockito.when((Object)fakeStorageClient.splitReadStream(SplitReadStreamRequest.newBuilder().setName("parentStream").setFraction(0.5).build())).thenReturn((Object)SplitReadStreamResponse.newBuilder().setPrimaryStream(ReadStream.newBuilder().setName("primaryStream")).setRemainderStream(ReadStream.newBuilder().setName("remainderStream")).build());
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream("primaryStream").setOffset(2L).build())).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream(parentResponses.subList(1, 2)));
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream("remainderStream").build())).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream(parentResponses.subList(2, parentResponses.size())));
        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create((ReadSession)ReadSession.newBuilder().setName("readSession").setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING)).build(), (ReadStream)ReadStream.newBuilder().setName("parentStream").build(), (TableSchema)TABLE_SCHEMA, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withStorageClient(fakeStorageClient));
        BigQueryStorageStreamSource.BigQueryStorageStreamReader parent = streamSource.createReader(this.options);
        Assert.assertTrue((boolean)parent.start());
        Assert.assertEquals((Object)"A", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)parent.advance());
        Assert.assertEquals((Object)"B", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        BigQueryStorageStreamSource.BigQueryStorageStreamReader primary = parent;
        BoundedSource residualSource = parent.splitAtFraction(0.5);
        Assert.assertNotNull((Object)residualSource);
        BoundedSource.BoundedReader residual = residualSource.createReader(this.options);
        Assert.assertTrue((boolean)primary.advance());
        Assert.assertEquals((Object)"C", (Object)((TableRow)primary.getCurrent()).get((Object)"name"));
        Assert.assertFalse((boolean)primary.advance());
        Assert.assertTrue((boolean)residual.start());
        Assert.assertEquals((Object)"D", (Object)((TableRow)residual.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)residual.advance());
        Assert.assertEquals((Object)"E", (Object)((TableRow)residual.getCurrent()).get((Object)"name"));
        Assert.assertFalse((boolean)residual.advance());
    }

    @Test
    public void testStreamSourceSplitAtFractionRepeated() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList readStreams = Lists.newArrayList((Object[])new ReadStream[]{ReadStream.newBuilder().setName("stream1").build(), ReadStream.newBuilder().setName("stream2").build(), ReadStream.newBuilder().setName("stream3").build()});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream(((ReadStream)readStreams.get(0)).getName()).build())).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("A", 1L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("B", 2L, AVRO_SCHEMA)}), 0.0, 0.25), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("D", 4L, AVRO_SCHEMA)}), 0.25, 0.5), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("E", 5L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("F", 6L, AVRO_SCHEMA)}), 0.5, 0.75)})));
        Mockito.when((Object)fakeStorageClient.splitReadStream(SplitReadStreamRequest.newBuilder().setName(((ReadStream)readStreams.get(0)).getName()).setFraction((double)0.83f).build())).thenReturn((Object)SplitReadStreamResponse.newBuilder().setPrimaryStream((ReadStream)readStreams.get(1)).setRemainderStream(ReadStream.newBuilder().setName("ignored")).build());
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream(((ReadStream)readStreams.get(1)).getName()).setOffset(1L).build())).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("B", 2L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA)}), 0.0, 0.5), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("D", 4L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("E", 5L, AVRO_SCHEMA)}), 0.5, 0.75)})));
        Mockito.when((Object)fakeStorageClient.splitReadStream(SplitReadStreamRequest.newBuilder().setName(((ReadStream)readStreams.get(1)).getName()).setFraction(0.75).build())).thenReturn((Object)SplitReadStreamResponse.newBuilder().setPrimaryStream((ReadStream)readStreams.get(2)).setRemainderStream(ReadStream.newBuilder().setName("ignored")).build());
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream(((ReadStream)readStreams.get(2)).getName()).setOffset(2L).build())).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("D", 4L, AVRO_SCHEMA)}), 0.8, 0.9)})));
        BigQueryStorageStreamSource source = BigQueryStorageStreamSource.create((ReadSession)ReadSession.newBuilder().setName("readSession").setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING)).build(), (ReadStream)((ReadStream)readStreams.get(0)), (TableSchema)TABLE_SCHEMA, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withStorageClient(fakeStorageClient));
        BoundedSource.BoundedReader reader = source.createReader(this.options);
        Assert.assertTrue((boolean)reader.start());
        Assert.assertEquals((Object)"A", (Object)((TableRow)reader.getCurrent()).get((Object)"name"));
        BoundedSource residualSource = reader.splitAtFraction((double)0.83f);
        Assert.assertNotNull((Object)residualSource);
        Assert.assertEquals((Object)"A", (Object)((TableRow)reader.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((Object)"B", (Object)((TableRow)reader.getCurrent()).get((Object)"name"));
        residualSource = reader.splitAtFraction(0.75);
        Assert.assertNotNull((Object)residualSource);
        Assert.assertEquals((Object)"B", (Object)((TableRow)reader.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((Object)"C", (Object)((TableRow)reader.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)reader.advance());
        Assert.assertEquals((Object)"D", (Object)((TableRow)reader.getCurrent()).get((Object)"name"));
        Assert.assertFalse((boolean)reader.advance());
    }

    @Test
    public void testStreamSourceSplitAtFractionFailsWhenSplitIsNotPossible() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList parentResponses = Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("A", 1L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("B", 2L, AVRO_SCHEMA)}), 0.0, 0.25), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA)}), 0.25, 0.5), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("D", 4L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("E", 5L, AVRO_SCHEMA)}), 0.5, 0.75)});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream("parentStream").build())).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)parentResponses));
        Mockito.when((Object)fakeStorageClient.splitReadStream(SplitReadStreamRequest.newBuilder().setName("parentStream").setFraction(0.5).build())).thenReturn((Object)SplitReadStreamResponse.getDefaultInstance());
        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create((ReadSession)ReadSession.newBuilder().setName("readSession").setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING)).build(), (ReadStream)ReadStream.newBuilder().setName("parentStream").build(), (TableSchema)TABLE_SCHEMA, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withStorageClient(fakeStorageClient));
        BigQueryStorageStreamSource.BigQueryStorageStreamReader parent = streamSource.createReader(this.options);
        Assert.assertTrue((boolean)parent.start());
        Assert.assertEquals((Object)"A", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)parent.advance());
        Assert.assertEquals((Object)"B", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertNull((Object)parent.splitAtFraction(0.5));
        ((BigQueryServices.StorageClient)Mockito.verify((Object)fakeStorageClient, (VerificationMode)Mockito.times((int)1))).splitReadStream((SplitReadStreamRequest)ArgumentMatchers.any());
        Assert.assertNull((Object)parent.splitAtFraction(0.5));
        ((BigQueryServices.StorageClient)Mockito.verify((Object)fakeStorageClient, (VerificationMode)Mockito.times((int)1))).splitReadStream((SplitReadStreamRequest)ArgumentMatchers.any());
        Assert.assertTrue((boolean)parent.advance());
        Assert.assertEquals((Object)"C", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)parent.advance());
        Assert.assertEquals((Object)"D", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)parent.advance());
        Assert.assertEquals((Object)"E", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertFalse((boolean)parent.advance());
    }

    @Test
    public void testStreamSourceSplitAtFractionFailsWhenParentIsPastSplitPoint() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList parentResponses = Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("A", 1L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("B", 2L, AVRO_SCHEMA)}), 0.0, 0.25), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA)}), 0.25, 0.5), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("D", 4L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("E", 5L, AVRO_SCHEMA)}), 0.5, 0.75)});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream("parentStream").build())).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)parentResponses));
        Mockito.when((Object)fakeStorageClient.splitReadStream(SplitReadStreamRequest.newBuilder().setName("parentStream").setFraction(0.5).build())).thenReturn((Object)SplitReadStreamResponse.newBuilder().setPrimaryStream(ReadStream.newBuilder().setName("primaryStream")).setRemainderStream(ReadStream.newBuilder().setName("remainderStream")).build());
        Mockito.when((Object)fakeStorageClient.readRows(ReadRowsRequest.newBuilder().setReadStream("primaryStream").setOffset(2L).build())).thenThrow(new Throwable[]{new FailedPreconditionException("Given row offset is invalid for stream.", (Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.FAILED_PRECONDITION), false)});
        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create((ReadSession)ReadSession.newBuilder().setName("readSession").setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING)).build(), (ReadStream)ReadStream.newBuilder().setName("parentStream").build(), (TableSchema)TABLE_SCHEMA, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withStorageClient(fakeStorageClient));
        BigQueryStorageStreamSource.BigQueryStorageStreamReader parent = streamSource.createReader(this.options);
        Assert.assertTrue((boolean)parent.start());
        Assert.assertEquals((Object)"A", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)parent.advance());
        Assert.assertEquals((Object)"B", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertNull((Object)parent.splitAtFraction(0.5));
        Assert.assertTrue((boolean)parent.advance());
        Assert.assertEquals((Object)"C", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)parent.advance());
        Assert.assertEquals((Object)"D", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertTrue((boolean)parent.advance());
        Assert.assertEquals((Object)"E", (Object)((TableRow)parent.getCurrent()).get((Object)"name"));
        Assert.assertFalse((boolean)parent.advance());
    }

    @Test
    public void testReadFromBigQueryIO() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.fakeDatasetService.createDataset("foo.com:project", "dataset", "", "", null);
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)"foo.com:project:dataset.table");
        Table table = new Table().setTableReference(tableRef).setNumBytes(Long.valueOf(10L)).setSchema(TABLE_SCHEMA);
        this.fakeDatasetService.createTable(table);
        CreateReadSessionRequest expectedCreateReadSessionRequest = CreateReadSessionRequest.newBuilder().setParent("projects/project-id").setReadSession(ReadSession.newBuilder().setTable("projects/foo.com:project/datasets/dataset/tables/table").setDataFormat(DataFormat.AVRO)).setMaxStreamCount(10).build();
        ReadSession readSession = ReadSession.newBuilder().setName("readSessionName").setAvroSchema(AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING)).addStreams(ReadStream.newBuilder().setName("streamName")).build();
        ReadRowsRequest expectedReadRowsRequest = ReadRowsRequest.newBuilder().setReadStream("streamName").build();
        ArrayList records = Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("A", 1L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("B", 2L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("C", 3L, AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("D", 4L, AVRO_SCHEMA)});
        ArrayList readRowsResponses = Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(0, 2), 0.0, 0.5), BigQueryIOStorageReadTest.createResponse(AVRO_SCHEMA, records.subList(2, 4), 0.5, 0.75)});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)fakeStorageClient.createReadSession(expectedCreateReadSessionRequest)).thenReturn((Object)readSession);
        Mockito.when((Object)fakeStorageClient.readRows(expectedReadRowsRequest)).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)readRowsResponses));
        PCollection output = (PCollection)this.p.apply((PTransform)BigQueryIO.read((SerializableFunction)new ParseKeyValue()).from("foo.com:project:dataset.table").withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withTestServices((BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withStorageClient(fakeStorageClient)));
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)"A", (Object)1L), (Object)KV.of((Object)"B", (Object)2L), (Object)KV.of((Object)"C", (Object)3L), (Object)KV.of((Object)"D", (Object)4L)));
        this.p.run();
    }

    @Test
    public void testReadFromBigQueryIOWithTrimmedSchema() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.fakeDatasetService.createDataset("foo.com:project", "dataset", "", "", null);
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)"foo.com:project:dataset.table");
        Table table = new Table().setTableReference(tableRef).setNumBytes(Long.valueOf(10L)).setSchema(TABLE_SCHEMA);
        this.fakeDatasetService.createTable(table);
        CreateReadSessionRequest expectedCreateReadSessionRequest = CreateReadSessionRequest.newBuilder().setParent("projects/project-id").setReadSession(ReadSession.newBuilder().setTable("projects/foo.com:project/datasets/dataset/tables/table").setDataFormat(DataFormat.AVRO).setReadOptions(ReadSession.TableReadOptions.newBuilder().addSelectedFields("name"))).setMaxStreamCount(10).build();
        ReadSession readSession = ReadSession.newBuilder().setName("readSessionName").setAvroSchema(AvroSchema.newBuilder().setSchema(TRIMMED_AVRO_SCHEMA_STRING)).addStreams(ReadStream.newBuilder().setName("streamName")).build();
        ReadRowsRequest expectedReadRowsRequest = ReadRowsRequest.newBuilder().setReadStream("streamName").build();
        ArrayList records = Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageReadTest.createRecord("A", TRIMMED_AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("B", TRIMMED_AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("C", TRIMMED_AVRO_SCHEMA), BigQueryIOStorageReadTest.createRecord("D", TRIMMED_AVRO_SCHEMA)});
        ArrayList readRowsResponses = Lists.newArrayList((Object[])new ReadRowsResponse[]{BigQueryIOStorageReadTest.createResponse(TRIMMED_AVRO_SCHEMA, records.subList(0, 2), 0.0, 0.5), BigQueryIOStorageReadTest.createResponse(TRIMMED_AVRO_SCHEMA, records.subList(2, 4), 0.5, 0.75)});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)fakeStorageClient.createReadSession(expectedCreateReadSessionRequest)).thenReturn((Object)readSession);
        Mockito.when((Object)fakeStorageClient.readRows(expectedReadRowsRequest)).thenReturn((Object)new FakeBigQueryServices.FakeBigQueryServerStream((List)readRowsResponses));
        PCollection output = (PCollection)this.p.apply((PTransform)BigQueryIO.readTableRows().from("foo.com:project:dataset.table").withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withSelectedFields((List)Lists.newArrayList((Object[])new String[]{"name"})).withTestServices((BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withStorageClient(fakeStorageClient)));
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)ImmutableList.of((Object)new TableRow().set("name", (Object)"A"), (Object)new TableRow().set("name", (Object)"B"), (Object)new TableRow().set("name", (Object)"C"), (Object)new TableRow().set("name", (Object)"D")));
        this.p.run();
    }

    private static final class ParseKeyValue
    implements SerializableFunction<SchemaAndRecord, KV<String, Long>> {
        private ParseKeyValue() {
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> apply(@UnknownKeyFor @NonNull @Initialized SchemaAndRecord input) {
            return KV.of((Object)input.getRecord().get("name").toString(), (Object)((Long)input.getRecord().get("number")));
        }
    }
}

