/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryIOStorageReadTableRowIT {
    private static final @UnknownKeyFor @NonNull @Initialized String DATASET_ID = "big_query_import_export";
    private static final @UnknownKeyFor @NonNull @Initialized String TABLE_PREFIX = "parallel_read_table_row_";
    private @UnknownKeyFor @NonNull @Initialized BigQueryIOStorageReadTableRowOptions options;

    private void setUpTestEnvironment(@UnknownKeyFor @NonNull @Initialized String tableName) {
        PipelineOptionsFactory.register(BigQueryIOStorageReadTableRowOptions.class);
        this.options = (BigQueryIOStorageReadTableRowOptions)TestPipeline.testingPipelineOptions().as(BigQueryIOStorageReadTableRowOptions.class);
        String project = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
        this.options.setInputTable(project + ":" + DATASET_ID + "." + TABLE_PREFIX + tableName);
        this.options.setTempLocation(this.options.getTempRoot() + "/temp-it/");
    }

    private static void runPipeline(@UnknownKeyFor @NonNull @Initialized BigQueryIOStorageReadTableRowOptions pipelineOptions) {
        Pipeline pipeline = Pipeline.create((PipelineOptions)pipelineOptions);
        PCollection jsonTableRowsFromExport = (PCollection)((PCollection)pipeline.apply("ExportTable", (PTransform)BigQueryIO.readTableRows().from(pipelineOptions.getInputTable()).withMethod(BigQueryIO.TypedRead.Method.EXPORT))).apply("MapExportedRows", (PTransform)MapElements.via((SimpleFunction)new TableRowToKVPairFn()));
        PCollection jsonTableRowsFromDirectRead = (PCollection)((PCollection)pipeline.apply("DirectReadTable", (PTransform)BigQueryIO.readTableRows().from(pipelineOptions.getInputTable()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ))).apply("MapDirectReadRows", (PTransform)MapElements.via((SimpleFunction)new TableRowToKVPairFn()));
        final TupleTag exportTag = new TupleTag();
        final TupleTag directReadTag = new TupleTag();
        PCollection unmatchedRows = (PCollection)((PCollection)KeyedPCollectionTuple.of((TupleTag)exportTag, (PCollection)jsonTableRowsFromExport).and(directReadTag, jsonTableRowsFromDirectRead).apply((PTransform)CoGroupByKey.create())).apply((PTransform)ParDo.of((DoFn)new DoFn<KV<String, CoGbkResult>, KV<String, Set<String>>>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                KV element = (KV)c.element();
                HashSet<String> uniqueRows = new HashSet<String>();
                for (String row : ((CoGbkResult)element.getValue()).getAll(exportTag)) {
                    uniqueRows.add(row);
                }
                for (String row : ((CoGbkResult)element.getValue()).getAll(directReadTag)) {
                    if (uniqueRows.contains(row)) {
                        uniqueRows.remove(row);
                        continue;
                    }
                    uniqueRows.add(row);
                }
                if (!uniqueRows.isEmpty()) {
                    c.output((Object)KV.of((Object)((String)element.getKey()), uniqueRows));
                }
            }
        }));
        PAssert.that((PCollection)unmatchedRows).empty();
        pipeline.run().waitUntilFinish();
    }

    @Test
    public void testBigQueryStorageReadTableRow1() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.setUpTestEnvironment("1");
        BigQueryIOStorageReadTableRowIT.runPipeline(this.options);
    }

    @Test
    public void testBigQueryStorageReadTableRow10k() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.setUpTestEnvironment("10k");
        BigQueryIOStorageReadTableRowIT.runPipeline(this.options);
    }

    @Test
    public void testBigQueryStorageReadTableRow100k() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.setUpTestEnvironment("100k");
        BigQueryIOStorageReadTableRowIT.runPipeline(this.options);
    }

    private static class TableRowToKVPairFn
    extends SimpleFunction<TableRow, KV<String, String>> {
        private TableRowToKVPairFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> apply(@UnknownKeyFor @NonNull @Initialized TableRow input) {
            CharSequence sampleString = (CharSequence)input.get((Object)"sample_string");
            String key = sampleString != null ? sampleString.toString() : "null";
            return KV.of((Object)key, (Object)BigQueryHelpers.toJsonString((Object)input));
        }
    }

    public static interface BigQueryIOStorageReadTableRowOptions
    extends TestPipelineOptions,
    ExperimentalOptions {
        @Description(value="The table to be read")
        @Validation.Required
        public @UnknownKeyFor @NonNull @Initialized String getInputTable();

        public void setInputTable(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

