/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import junit.framework.TestCase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIOMetadata;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryIOMetadataTest {
    @Test
    public void testIsValidCloudLabel() {
        String testStr = "2020-06-29_15_26_09-12838749047888422749";
        TestCase.assertTrue((boolean)BigQueryIOMetadata.isValidCloudLabel((String)testStr));
        testStr = "0";
        TestCase.assertTrue((boolean)BigQueryIOMetadata.isValidCloudLabel((String)testStr));
        testStr = "0123456789abcdefghij0123456789abcdefghij0123456789abcdefghij012";
        TestCase.assertTrue((boolean)BigQueryIOMetadata.isValidCloudLabel((String)testStr));
        testStr = "abcdefghijklmnopqrstuvwxyz";
        for (char testChar : testStr.toCharArray()) {
            TestCase.assertTrue((boolean)BigQueryIOMetadata.isValidCloudLabel((String)String.valueOf(testChar)));
        }
        testStr = "";
        TestCase.assertFalse((boolean)BigQueryIOMetadata.isValidCloudLabel((String)testStr));
        testStr = "0123456789abcdefghij0123456789abcdefghij0123456789abcdefghij0123";
        TestCase.assertFalse((boolean)BigQueryIOMetadata.isValidCloudLabel((String)testStr));
        testStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        for (char testChar : testStr.toCharArray()) {
            TestCase.assertFalse((boolean)BigQueryIOMetadata.isValidCloudLabel((String)String.valueOf(testChar)));
        }
        testStr = "!@#$%^&*()+=[{]};:'\"\\|,<.>?/`~";
        for (char testChar : testStr.toCharArray()) {
            TestCase.assertFalse((boolean)BigQueryIOMetadata.isValidCloudLabel((String)String.valueOf(testChar)));
        }
    }
}

