/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfoCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryHelpersTest {
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();

    @Test
    public void testTableParsing() {
        TableReference ref = BigQueryHelpers.parseTableSpec((String)"my-project:data_set.table_name");
        Assert.assertEquals((Object)"my-project", (Object)ref.getProjectId());
        Assert.assertEquals((Object)"data_set", (Object)ref.getDatasetId());
        Assert.assertEquals((Object)"table_name", (Object)ref.getTableId());
    }

    @Test
    public void testTableParsing_validPatterns() {
        BigQueryHelpers.parseTableSpec((String)"a123-456:foo_bar.d");
        BigQueryHelpers.parseTableSpec((String)"a12345:b.c");
        BigQueryHelpers.parseTableSpec((String)"b12345.c");
    }

    @Test
    public void testTableParsing_noProjectId() {
        TableReference ref = BigQueryHelpers.parseTableSpec((String)"data_set.table_name");
        Assert.assertEquals(null, (Object)ref.getProjectId());
        Assert.assertEquals((Object)"data_set", (Object)ref.getDatasetId());
        Assert.assertEquals((Object)"table_name", (Object)ref.getTableId());
    }

    @Test
    public void testTableParsingError() {
        this.thrown.expect(IllegalArgumentException.class);
        BigQueryHelpers.parseTableSpec((String)"0123456:foo.bar");
    }

    @Test
    public void testTableParsingError_2() {
        this.thrown.expect(IllegalArgumentException.class);
        BigQueryHelpers.parseTableSpec((String)"myproject:.bar");
    }

    @Test
    public void testTableParsingError_3() {
        this.thrown.expect(IllegalArgumentException.class);
        BigQueryHelpers.parseTableSpec((String)":a.b");
    }

    @Test
    public void testTableParsingError_slash() {
        this.thrown.expect(IllegalArgumentException.class);
        BigQueryHelpers.parseTableSpec((String)"a\\b12345:c.d");
    }

    @Test
    public void testTableDecoratorStripping() {
        Assert.assertEquals((Object)"project:dataset.table", (Object)BigQueryHelpers.stripPartitionDecorator((String)"project:dataset.table$20171127"));
        Assert.assertEquals((Object)"project:dataset.table", (Object)BigQueryHelpers.stripPartitionDecorator((String)"project:dataset.table"));
    }

    @Test
    public void testCoder_nullCell() throws @UnknownKeyFor @NonNull @Initialized CoderException {
        TableRow row = new TableRow();
        row.set("temperature", Data.nullOf(Object.class));
        row.set("max_temperature", Data.nullOf(Object.class));
        byte[] bytes = CoderUtils.encodeToByteArray((Coder)TableRowJsonCoder.of(), (Object)row);
        TableRow newRow = (TableRow)CoderUtils.decodeFromByteArray((Coder)TableRowJsonCoder.of(), (byte[])bytes);
        byte[] newBytes = CoderUtils.encodeToByteArray((Coder)TableRowJsonCoder.of(), (Object)newRow);
        Assert.assertArrayEquals((byte[])bytes, (byte[])newBytes);
    }

    @Test
    public void testShardedKeyCoderIsSerializableWithWellKnownCoderType() {
        CoderProperties.coderSerializable((Coder)ShardedKeyCoder.of((Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testTableRowInfoCoderSerializable() {
        CoderProperties.coderSerializable((Coder)TableRowInfoCoder.of((Coder)TableRowJsonCoder.of()));
    }

    @Test
    public void testComplexCoderSerializable() {
        CoderProperties.coderSerializable((Coder)WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of((Coder)StringUtf8Coder.of()), (Coder)TableRowInfoCoder.of((Coder)TableRowJsonCoder.of())), (Coder)IntervalWindow.getCoder()));
    }

    @Test
    public void testPendingJobManager() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryHelpers.PendingJobManager jobManager = new BigQueryHelpers.PendingJobManager(BackOffAdapter.toGcpBackOff((BackOff)FluentBackoff.DEFAULT.withMaxRetries(Integer.MAX_VALUE).withInitialBackoff(Duration.millis((long)10L)).withMaxBackoff(Duration.millis((long)10L)).backoff()));
        HashSet succeeded = Sets.newHashSet();
        for (int i = 0; i < 5; ++i) {
            Job currentJob = new Job();
            currentJob.setKind(" bigquery#job");
            BigQueryHelpers.PendingJob pendingJob = new BigQueryHelpers.PendingJob((SerializableFunction & Serializable)retryId -> {
                if (new Random().nextInt(2) == 0) {
                    throw new RuntimeException("Failing to start.");
                }
                currentJob.setJobReference(new JobReference().setProjectId("").setLocation("").setJobId(retryId.getJobId()));
                return null;
            }, (SerializableFunction & Serializable)retryId -> {
                if (retryId.getRetryIndex() < 5) {
                    currentJob.setStatus(new JobStatus().setErrorResult(new ErrorProto()));
                } else {
                    currentJob.setStatus(new JobStatus().setErrorResult(null));
                }
                return currentJob;
            }, (SerializableFunction & Serializable)retryId -> {
                if (retryId.getJobId().equals(currentJob.getJobReference().getJobId())) {
                    return currentJob;
                }
                return null;
            }, 100, "JOB_" + i);
            jobManager.addPendingJob(pendingJob, (SerializableFunction & Serializable)j -> {
                succeeded.add(j.currentJobId.getJobId());
                return null;
            });
        }
        jobManager.waitForDone();
        ImmutableSet expectedJobs = ImmutableSet.of((Object)"JOB_0-5", (Object)"JOB_1-5", (Object)"JOB_2-5", (Object)"JOB_3-5", (Object)"JOB_4-5");
        Assert.assertEquals((Object)expectedJobs, (Object)succeeded);
    }

    @Test
    public void testCreateTempTableReference() {
        String projectId = "this-is-my-project";
        String jobUuid = "this-is-my-job";
        TableReference noDataset = BigQueryResourceNaming.createTempTableReference((String)projectId, (String)jobUuid, Optional.empty());
        Assert.assertEquals((Object)noDataset.getProjectId(), (Object)projectId);
        Assert.assertEquals((Object)noDataset.getDatasetId(), (Object)("temp_dataset_" + jobUuid));
        Assert.assertEquals((Object)noDataset.getTableId(), (Object)("temp_table_" + jobUuid));
        Optional<String> dataset = Optional.ofNullable("my-tmp-dataset");
        TableReference tempTableReference = BigQueryResourceNaming.createTempTableReference((String)projectId, (String)jobUuid, dataset);
        Assert.assertEquals((Object)tempTableReference.getProjectId(), (Object)noDataset.getProjectId());
        Assert.assertEquals((Object)tempTableReference.getDatasetId(), (Object)dataset.get());
        Assert.assertEquals((Object)tempTableReference.getTableId(), (Object)noDataset.getTableId());
        Assert.assertEquals((Object)dataset.get(), (Object)noDataset.setDatasetId(dataset.get()).getDatasetId());
    }
}

