/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryAvroUtilsTest {
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> subFields = Lists.newArrayList((Object[])new TableFieldSchema[]{new TableFieldSchema().setName("species").setType("STRING").setMode("NULLABLE")});
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fields = Lists.newArrayList((Object[])new TableFieldSchema[]{new TableFieldSchema().setName("number").setType("INTEGER").setMode("REQUIRED"), new TableFieldSchema().setName("species").setType("STRING").setMode("NULLABLE"), new TableFieldSchema().setName("quality").setType("FLOAT"), new TableFieldSchema().setName("quantity").setType("INTEGER"), new TableFieldSchema().setName("birthday").setType("TIMESTAMP").setMode("NULLABLE"), new TableFieldSchema().setName("birthdayMoney").setType("NUMERIC").setMode("NULLABLE"), new TableFieldSchema().setName("flighted").setType("BOOLEAN").setMode("NULLABLE"), new TableFieldSchema().setName("sound").setType("BYTES").setMode("NULLABLE"), new TableFieldSchema().setName("anniversaryDate").setType("DATE").setMode("NULLABLE"), new TableFieldSchema().setName("anniversaryDatetime").setType("DATETIME").setMode("NULLABLE"), new TableFieldSchema().setName("anniversaryTime").setType("TIME").setMode("NULLABLE"), new TableFieldSchema().setName("scion").setType("RECORD").setMode("NULLABLE").setFields(this.subFields), new TableFieldSchema().setName("associates").setType("RECORD").setMode("REPEATED").setFields(this.subFields), new TableFieldSchema().setName("geoPositions").setType("GEOGRAPHY").setMode("NULLABLE")});

    @Test
    public void testConvertGenericRecordToTableRow() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableSchema tableSchema = new TableSchema();
        tableSchema.setFields(this.fields);
        BigDecimal birthdayMoney = new BigDecimal("123456789.123456789");
        Schema birthdayMoneySchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.Decimal birthdayMoneyLogicalType = LogicalTypes.decimal((int)birthdayMoney.precision(), (int)birthdayMoney.scale());
        byte[] birthdayMoneyBytes = new Conversions.DecimalConversion().toBytes(birthdayMoney, birthdayMoneySchema, (LogicalType)birthdayMoneyLogicalType).array();
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (Schema.Field field : AvroCoder.of(Bird.class).getSchema().getFields()) {
            Schema schema = field.schema();
            if ("birthdayMoney".equals(field.name())) {
                schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), birthdayMoneyLogicalType.addToSchema(birthdayMoneySchema)});
            }
            avroFields.add(new Schema.Field(field.name(), schema, field.doc(), field.defaultValue()));
        }
        Schema avroSchema = Schema.createRecord(avroFields);
        GenericData.Record record = new GenericData.Record(avroSchema);
        record.put("number", (Object)5L);
        TableRow convertedRow = BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)record, (TableSchema)tableSchema);
        TableRow row = new TableRow().set("number", (Object)"5").set("associates", new ArrayList());
        Assert.assertEquals((Object)row, (Object)convertedRow);
        TableRow clonedRow = convertedRow.clone();
        Assert.assertEquals((Object)convertedRow, (Object)clonedRow);
        record = new GenericData.Record(avroSchema);
        byte[] soundBytes = "chirp,chirp".getBytes(StandardCharsets.UTF_8);
        ByteBuffer soundByteBuffer = ByteBuffer.wrap(soundBytes);
        soundByteBuffer.rewind();
        record.put("number", (Object)5L);
        record.put("quality", (Object)5.0);
        record.put("birthday", (Object)5L);
        record.put("birthdayMoney", (Object)ByteBuffer.wrap(birthdayMoneyBytes));
        record.put("flighted", (Object)Boolean.TRUE);
        record.put("sound", (Object)soundByteBuffer);
        record.put("anniversaryDate", (Object)new Utf8("2000-01-01"));
        record.put("anniversaryDatetime", (Object)new String("2000-01-01 00:00:00.000005"));
        record.put("anniversaryTime", (Object)new Utf8("00:00:00.000005"));
        record.put("geoPositions", (Object)new String("LINESTRING(1 2, 3 4, 5 6, 7 8)"));
        TableRow convertedRow2 = BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)record, (TableSchema)tableSchema);
        TableRow row2 = new TableRow().set("number", (Object)"5").set("birthday", (Object)"1970-01-01 00:00:00.000005 UTC").set("birthdayMoney", (Object)birthdayMoney.toString()).set("quality", (Object)5.0).set("associates", new ArrayList()).set("flighted", (Object)Boolean.TRUE).set("sound", (Object)BaseEncoding.base64().encode(soundBytes)).set("anniversaryDate", (Object)"2000-01-01").set("anniversaryDatetime", (Object)"2000-01-01 00:00:00.000005").set("anniversaryTime", (Object)"00:00:00.000005").set("geoPositions", (Object)"LINESTRING(1 2, 3 4, 5 6, 7 8)");
        TableRow clonedRow2 = convertedRow2.clone();
        Assert.assertEquals((Object)convertedRow2, (Object)clonedRow2);
        Assert.assertEquals((Object)row2, (Object)convertedRow2);
        Schema subBirdSchema = AvroCoder.of(Bird.SubBird.class).getSchema();
        GenericData.Record nestedRecord = new GenericData.Record(subBirdSchema);
        nestedRecord.put("species", (Object)"other");
        GenericData.Record record2 = new GenericData.Record(avroSchema);
        record2.put("number", (Object)5L);
        record2.put("associates", (Object)Lists.newArrayList((Object[])new GenericRecord[]{nestedRecord}));
        record2.put("birthdayMoney", (Object)ByteBuffer.wrap(birthdayMoneyBytes));
        convertedRow2 = BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)record2, (TableSchema)tableSchema);
        row2 = new TableRow().set("associates", (Object)Lists.newArrayList((Object[])new TableRow[]{new TableRow().set("species", (Object)"other")})).set("number", (Object)"5").set("birthdayMoney", (Object)birthdayMoney.toString());
        Assert.assertEquals((Object)row2, (Object)convertedRow2);
        clonedRow2 = convertedRow2.clone();
        Assert.assertEquals((Object)convertedRow2, (Object)clonedRow2);
    }

    @Test
    public void testConvertBigQuerySchemaToAvroSchema() {
        TableSchema tableSchema = new TableSchema();
        tableSchema.setFields(this.fields);
        Schema avroSchema = BigQueryAvroUtils.toGenericAvroSchema((String)"testSchema", (List)tableSchema.getFields());
        MatcherAssert.assertThat((Object)avroSchema.getField("number").schema(), (Matcher)Matchers.equalTo((Object)Schema.create((Schema.Type)Schema.Type.LONG)));
        MatcherAssert.assertThat((Object)avroSchema.getField("species").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("quality").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.DOUBLE)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("quantity").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("birthday").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("birthdayMoney").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BYTES)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("flighted").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BOOLEAN)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("sound").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BYTES)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("anniversaryDate").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("anniversaryDatetime").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("anniversaryTime").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("geoPositions").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("scion").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.createRecord((String)"scion", (String)"Translated Avro Schema for scion", (String)"org.apache.beam.sdk.io.gcp.bigquery", (boolean)false, (List)ImmutableList.of((Object)new Schema.Field("species", Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)}), null, null)))})));
        MatcherAssert.assertThat((Object)avroSchema.getField("associates").schema(), (Matcher)Matchers.equalTo((Object)Schema.createArray((Schema)Schema.createRecord((String)"associates", (String)"Translated Avro Schema for associates", (String)"org.apache.beam.sdk.io.gcp.bigquery", (boolean)false, (List)ImmutableList.of((Object)new Schema.Field("species", Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)}), null, null))))));
    }

    @Test
    public void testFormatTimestamp() {
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)1452062291123456L), (Matcher)Matchers.equalTo((Object)"2016-01-06 06:38:11.123456 UTC"));
    }

    @Test
    public void testFormatTimestampLeadingZeroesOnMicros() {
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)1452062291000456L), (Matcher)Matchers.equalTo((Object)"2016-01-06 06:38:11.000456 UTC"));
    }

    @Test
    public void testFormatTimestampTrailingZeroesOnMicros() {
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)1452062291123000L), (Matcher)Matchers.equalTo((Object)"2016-01-06 06:38:11.123000 UTC"));
    }

    @Test
    public void testFormatTimestampNegative() {
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)-1L), (Matcher)Matchers.equalTo((Object)"1969-12-31 23:59:59.999999 UTC"));
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)-100000L), (Matcher)Matchers.equalTo((Object)"1969-12-31 23:59:59.900000 UTC"));
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)-1000000L), (Matcher)Matchers.equalTo((Object)"1969-12-31 23:59:59 UTC"));
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)-62135596800000000L), (Matcher)Matchers.equalTo((Object)"0001-01-01 00:00:00 UTC"));
    }

    @DefaultCoder(value=AvroCoder.class)
    static class Bird {
        @UnknownKeyFor @NonNull @Initialized long number;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized String species;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Double quality;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Long quantity;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Long birthday;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized ByteBuffer birthdayMoney;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized String geoPositions;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Boolean flighted;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized ByteBuffer sound;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Utf8 anniversaryDate;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized String anniversaryDatetime;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Utf8 anniversaryTime;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized SubBird scion;
        @UnknownKeyFor @NonNull @Initialized SubBird @UnknownKeyFor @NonNull @Initialized [] associates = new SubBird[1];

        public Bird() {
            this.associates[0] = new SubBird();
        }

        static class SubBird {
            @Nullable
            @UnknownKeyFor @NonNull @Initialized String species;
        }
    }
}

