/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.gcp.spanner.FakeServiceFactory;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationSizeEstimator;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.hamcrest.Matcher;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class SpannerIOWriteTest
implements Serializable {
    private static final long CELLS_PER_KEY = 7L;
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    @Captor
    public transient ArgumentCaptor<Iterable<Mutation>> mutationBatchesCaptor;
    @Captor
    public transient ArgumentCaptor<Iterable<MutationGroup>> mutationGroupListCaptor;
    @Captor
    public transient ArgumentCaptor<MutationGroup> mutationGroupCaptor;
    @Captor
    public transient ArgumentCaptor<List<KV<byte[], byte[]>>> byteArrayKvListCaptor;
    private FakeServiceFactory serviceFactory;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.serviceFactory = new FakeServiceFactory();
        ReadOnlyTransaction tx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().readOnlyTransaction()).thenReturn((Object)tx);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().writeAtLeastOnce((Iterable)this.mutationBatchesCaptor.capture())).thenReturn(null);
        this.preparePkMetadata(tx, Arrays.asList(SpannerIOWriteTest.pkMetadata("tEsT", "key", "ASC")));
        this.prepareColumnMetadata(tx, Arrays.asList(SpannerIOWriteTest.columnMetadata("tEsT", "key", "INT64", 7L)));
    }

    private SpannerSchema getSchema() {
        return SpannerSchema.builder().addColumn("tEsT", "key", "INT64", 7L).addKeyPart("tEsT", "key", false).build();
    }

    private static Struct columnMetadata(String tableName, String columnName, String type, long cellsMutated) {
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("table_name").to(tableName)).set("column_name").to(columnName)).set("spanner_type").to(type)).set("cells_mutated").to(cellsMutated)).build();
    }

    private static Struct pkMetadata(String tableName, String columnName, String ordering) {
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("table_name").to(tableName)).set("column_name").to(columnName)).set("column_ordering").to(ordering)).build();
    }

    private void prepareColumnMetadata(ReadOnlyTransaction tx, List<Struct> rows) {
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"table_name", (Type)Type.string()), Type.StructField.of((String)"column_name", (Type)Type.string()), Type.StructField.of((String)"spanner_type", (Type)Type.string()), Type.StructField.of((String)"cells_mutated", (Type)Type.int64())});
        Mockito.when((Object)tx.executeQuery((Statement)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<Statement>(){

            public boolean matches(Statement argument) {
                if (!(argument instanceof Statement)) {
                    return false;
                }
                Statement st = argument;
                return st.getSql().contains("information_schema.columns");
            }
        }), new Options.QueryOption[0])).thenReturn((Object)ResultSets.forRows((Type)type, rows));
    }

    private void preparePkMetadata(ReadOnlyTransaction tx, List<Struct> rows) {
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"table_name", (Type)Type.string()), Type.StructField.of((String)"column_name", (Type)Type.string()), Type.StructField.of((String)"column_ordering", (Type)Type.string())});
        Mockito.when((Object)tx.executeQuery((Statement)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<Statement>(){

            public boolean matches(Statement argument) {
                if (!(argument instanceof Statement)) {
                    return false;
                }
                Statement st = argument;
                return st.getSql().contains("information_schema.index_columns");
            }
        }), new Options.QueryOption[0])).thenReturn((Object)ResultSets.forRows((Type)type, rows));
    }

    @Test
    public void emptyTransform() throws Exception {
        SpannerIO.Write write = SpannerIO.write();
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("requires instance id to be set with");
        write.expand(null);
    }

    @Test
    public void emptyInstanceId() throws Exception {
        SpannerIO.Write write = SpannerIO.write().withDatabaseId("123");
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("requires instance id to be set with");
        write.expand(null);
    }

    @Test
    public void emptyDatabaseId() throws Exception {
        SpannerIO.Write write = SpannerIO.write().withInstanceId("123");
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("requires database id to be set with");
        write.expand(null);
    }

    @Test
    public void singleMutationPipeline() throws Exception {
        Mutation mutation = SpannerIOWriteTest.m(2L);
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)mutation, (Object[])new Mutation[0]));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory));
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(2L)));
    }

    @Test
    public void singleMutationGroupPipeline() throws Exception {
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)), (Object[])new MutationGroup[0]));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).grouped());
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)));
    }

    private void verifyBatches(Iterable<Mutation> ... batches) {
        for (Iterable<Mutation> b : batches) {
            ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)1))).writeAtLeastOnce(SpannerIOWriteTest.mutationsInNoOrder(b));
        }
    }

    @Test
    public void noBatching() throws Exception {
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), (Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0])}));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(1L).grouped());
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(2L)));
    }

    @Test
    public void streamingWrites() throws Exception {
        TestStream testStream = TestStream.create((Coder)SerializableCoder.of(Mutation.class)).addElements((Object)SpannerIOWriteTest.m(1L), (Object[])new Mutation[]{SpannerIOWriteTest.m(2L)}).advanceProcessingTime(Duration.standardMinutes((long)1L)).addElements((Object)SpannerIOWriteTest.m(3L), (Object[])new Mutation[]{SpannerIOWriteTest.m(4L)}).advanceProcessingTime(Duration.standardMinutes((long)1L)).addElements((Object)SpannerIOWriteTest.m(5L), (Object[])new Mutation[]{SpannerIOWriteTest.m(6L)}).advanceWatermarkToInfinity();
        ((PCollection)this.pipeline.apply((PTransform)testStream)).apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory));
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(3L), SpannerIOWriteTest.m(4L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L)));
    }

    @Test
    public void reportFailures() throws Exception {
        MutationGroup[] mutationGroups = new MutationGroup[10];
        for (int i = 0; i < mutationGroups.length; ++i) {
            mutationGroups[i] = SpannerIOWriteTest.g(SpannerIOWriteTest.m(Long.valueOf(i)), new Mutation[0]);
        }
        List<MutationGroup> mutationGroupList = Arrays.asList(mutationGroups);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().writeAtLeastOnce((Iterable)Matchers.any())).thenAnswer(invocationOnMock -> {
            Preconditions.checkNotNull((Object)invocationOnMock.getArguments()[0]);
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ALREADY_EXISTS, (String)"oops");
        });
        SpannerWriteResult result = (SpannerWriteResult)((PCollection)this.pipeline.apply((PTransform)Create.of(mutationGroupList))).apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(0L).withFailureMode(SpannerIO.FailureMode.REPORT_FAILURES).grouped());
        PAssert.that((PCollection)result.getFailedMutations()).satisfies((SerializableFunction & Serializable)m -> {
            Assert.assertEquals((long)mutationGroups.length, (long)Iterables.size((Iterable)m));
            return null;
        });
        PAssert.that((PCollection)result.getFailedMutations()).containsInAnyOrder(mutationGroupList);
        this.pipeline.run().waitUntilFinish();
        ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)20))).writeAtLeastOnce((Iterable)Matchers.any());
    }

    @Test
    public void deadlineExceededRetries() throws InterruptedException {
        List<Mutation> mutationList = Arrays.asList(SpannerIOWriteTest.m(1L));
        SpannerIO.WriteToSpannerFn.sleeper = (Sleeper)Mockito.mock(Sleeper.class);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().writeAtLeastOnce((Iterable)Matchers.any())).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)"simulated Timeout 1")}).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)"simulated Timeout 2")}).thenReturn((Object)Timestamp.now());
        SpannerWriteResult result = (SpannerWriteResult)((PCollection)this.pipeline.apply((PTransform)Create.of(mutationList))).apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(0L).withFailureMode(SpannerIO.FailureMode.REPORT_FAILURES));
        PAssert.that((PCollection)result.getFailedMutations()).satisfies((SerializableFunction & Serializable)m -> {
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)m));
            return null;
        });
        this.pipeline.run().waitUntilFinish();
        ((Sleeper)Mockito.verify((Object)SpannerIO.WriteToSpannerFn.sleeper, (VerificationMode)Mockito.times((int)2))).sleep(ArgumentMatchers.anyLong());
        ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)3))).writeAtLeastOnce((Iterable)Matchers.any());
    }

    @Test
    public void deadlineExceededFailsAfterRetries() throws InterruptedException {
        List<Mutation> mutationList = Arrays.asList(SpannerIOWriteTest.m(1L));
        SpannerIO.WriteToSpannerFn.sleeper = (Sleeper)Mockito.mock(Sleeper.class);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().writeAtLeastOnce((Iterable)Matchers.any())).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)"simulated Timeout")});
        SpannerWriteResult result = (SpannerWriteResult)((PCollection)this.pipeline.apply((PTransform)Create.of(mutationList))).apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(0L).withMaxCumulativeBackoff(Duration.standardHours((long)2L)).withFailureMode(SpannerIO.FailureMode.REPORT_FAILURES));
        PAssert.that((PCollection)result.getFailedMutations()).satisfies((SerializableFunction & Serializable)m -> {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)m));
            return null;
        });
        this.pipeline.run().waitUntilFinish();
        int numSleeps = Mockito.mockingDetails((Object)SpannerIO.WriteToSpannerFn.sleeper).getInvocations().size();
        Assert.assertTrue((String)String.format("Should be least 16 sleeps, got %d", numSleeps), (numSleeps > 16 ? 1 : 0) != 0);
        long totalSleep = Mockito.mockingDetails((Object)SpannerIO.WriteToSpannerFn.sleeper).getInvocations().stream().mapToLong(i -> (Long)i.getArgument(0)).reduce(0L, Long::sum);
        Assert.assertTrue((String)String.format("Should be least 7200s of sleep, got %d", totalSleep), (totalSleep >= Duration.standardHours((long)2L).getMillis() ? 1 : 0) != 0);
        ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)(numSleeps + 2)))).writeAtLeastOnce((Iterable)Matchers.any());
    }

    @Test
    public void displayData() throws Exception {
        SpannerIO.Write write = SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withBatchSizeBytes(123L);
        DisplayData data = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)data.items(), (Matcher)org.hamcrest.Matchers.hasSize((int)4));
        Assert.assertThat((Object)data, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId", (String)"test-project"));
        Assert.assertThat((Object)data, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"instanceId", (String)"test-instance"));
        Assert.assertThat((Object)data, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"databaseId", (String)"test-database"));
        Assert.assertThat((Object)data, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"batchSizeBytes", (long)123L));
    }

    @Test
    public void testBatchableMutationFilterFn_cells() {
        Mutation all = Mutation.delete((String)"test", (KeySet)KeySet.all());
        Mutation prefix = Mutation.delete((String)"test", (KeySet)KeySet.prefixRange((Key)Key.of((Object[])new Object[]{1L})));
        Mutation range = Mutation.delete((String)"test", (KeySet)KeySet.range((KeyRange)KeyRange.openOpen((Key)Key.of((Object[])new Object[]{1L}), (Key)Key.newBuilder().build())));
        MutationGroup[] mutationGroups = new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L), SpannerIOWriteTest.m(4L), SpannerIOWriteTest.m(5L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.del(5L, 6L), new Mutation[0]), SpannerIOWriteTest.g(all, new Mutation[0]), SpannerIOWriteTest.g(prefix, new Mutation[0]), SpannerIOWriteTest.g(range, new Mutation[0])};
        SpannerIO.BatchableMutationFilterFn testFn = new SpannerIO.BatchableMutationFilterFn(null, null, 10000000L, 21L, 1000L);
        DoFn.ProcessContext mockProcessContext = (DoFn.ProcessContext)Mockito.mock(DoFn.ProcessContext.class);
        Mockito.when((Object)mockProcessContext.sideInput((PCollectionView)Matchers.any())).thenReturn((Object)this.getSchema());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output(this.mutationGroupCaptor.capture());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output((TupleTag)Matchers.any(), this.mutationGroupListCaptor.capture());
        for (MutationGroup m : mutationGroups) {
            Mockito.when((Object)mockProcessContext.element()).thenReturn((Object)m);
            testFn.processElement(mockProcessContext);
        }
        Assert.assertThat((Object)this.mutationGroupCaptor.getAllValues(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(1L), new Mutation[0])}));
        Iterable unbatchableMutations = Iterables.concat((Iterable)this.mutationGroupListCaptor.getAllValues());
        Assert.assertThat((Object)unbatchableMutations, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L), SpannerIOWriteTest.m(4L), SpannerIOWriteTest.m(5L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(5L, 6L), new Mutation[0]), SpannerIOWriteTest.g(all, new Mutation[0]), SpannerIOWriteTest.g(prefix, new Mutation[0]), SpannerIOWriteTest.g(range, new Mutation[0])}));
    }

    @Test
    public void testBatchableMutationFilterFn_size() {
        Mutation all = Mutation.delete((String)"test", (KeySet)KeySet.all());
        Mutation prefix = Mutation.delete((String)"test", (KeySet)KeySet.prefixRange((Key)Key.of((Object[])new Object[]{1L})));
        Mutation range = Mutation.delete((String)"test", (KeySet)KeySet.range((KeyRange)KeyRange.openOpen((Key)Key.of((Object[])new Object[]{1L}), (Key)Key.newBuilder().build())));
        MutationGroup[] mutationGroups = new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)), SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(3L), SpannerIOWriteTest.m(4L), SpannerIOWriteTest.m(5L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.del(5L, 6L), new Mutation[0]), SpannerIOWriteTest.g(all, new Mutation[0]), SpannerIOWriteTest.g(prefix, new Mutation[0]), SpannerIOWriteTest.g(range, new Mutation[0])};
        long mutationSize = MutationSizeEstimator.sizeOf((Mutation)SpannerIOWriteTest.m(1L));
        SpannerIO.BatchableMutationFilterFn testFn = new SpannerIO.BatchableMutationFilterFn(null, null, mutationSize * 3L, 1000L, 1000L);
        DoFn.ProcessContext mockProcessContext = (DoFn.ProcessContext)Mockito.mock(DoFn.ProcessContext.class);
        Mockito.when((Object)mockProcessContext.sideInput((PCollectionView)Matchers.any())).thenReturn((Object)this.getSchema());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output(this.mutationGroupCaptor.capture());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output((TupleTag)Matchers.any(), this.mutationGroupListCaptor.capture());
        for (MutationGroup m : mutationGroups) {
            Mockito.when((Object)mockProcessContext.element()).thenReturn((Object)m);
            testFn.processElement(mockProcessContext);
        }
        Assert.assertThat((Object)this.mutationGroupCaptor.getAllValues(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(1L), new Mutation[0])}));
        Iterable unbatchableMutations = Iterables.concat((Iterable)this.mutationGroupListCaptor.getAllValues());
        Assert.assertThat((Object)unbatchableMutations, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(3L), SpannerIOWriteTest.m(4L), SpannerIOWriteTest.m(5L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(5L, 6L), new Mutation[0]), SpannerIOWriteTest.g(all, new Mutation[0]), SpannerIOWriteTest.g(prefix, new Mutation[0]), SpannerIOWriteTest.g(range, new Mutation[0])}));
    }

    @Test
    public void testBatchableMutationFilterFn_rows() {
        Mutation all = Mutation.delete((String)"test", (KeySet)KeySet.all());
        Mutation prefix = Mutation.delete((String)"test", (KeySet)KeySet.prefixRange((Key)Key.of((Object[])new Object[]{1L})));
        Mutation range = Mutation.delete((String)"test", (KeySet)KeySet.range((KeyRange)KeyRange.openOpen((Key)Key.of((Object[])new Object[]{1L}), (Key)Key.newBuilder().build())));
        MutationGroup[] mutationGroups = new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)), SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(3L), SpannerIOWriteTest.m(4L), SpannerIOWriteTest.m(5L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.del(5L, 6L), new Mutation[0]), SpannerIOWriteTest.g(all, new Mutation[0]), SpannerIOWriteTest.g(prefix, new Mutation[0]), SpannerIOWriteTest.g(range, new Mutation[0])};
        long mutationSize = MutationSizeEstimator.sizeOf((Mutation)SpannerIOWriteTest.m(1L));
        SpannerIO.BatchableMutationFilterFn testFn = new SpannerIO.BatchableMutationFilterFn(null, null, 1000L, 1000L, 3L);
        DoFn.ProcessContext mockProcessContext = (DoFn.ProcessContext)Mockito.mock(DoFn.ProcessContext.class);
        Mockito.when((Object)mockProcessContext.sideInput((PCollectionView)Matchers.any())).thenReturn((Object)this.getSchema());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output(this.mutationGroupCaptor.capture());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output((TupleTag)Matchers.any(), this.mutationGroupListCaptor.capture());
        for (MutationGroup m : mutationGroups) {
            Mockito.when((Object)mockProcessContext.element()).thenReturn((Object)m);
            testFn.processElement(mockProcessContext);
        }
        Assert.assertThat((Object)this.mutationGroupCaptor.getAllValues(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(1L), new Mutation[0])}));
        Iterable unbatchableMutations = Iterables.concat((Iterable)this.mutationGroupListCaptor.getAllValues());
        Assert.assertThat((Object)unbatchableMutations, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(3L), SpannerIOWriteTest.m(4L), SpannerIOWriteTest.m(5L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(5L, 6L), new Mutation[0]), SpannerIOWriteTest.g(all, new Mutation[0]), SpannerIOWriteTest.g(prefix, new Mutation[0]), SpannerIOWriteTest.g(range, new Mutation[0])}));
    }

    @Test
    public void testBatchableMutationFilterFn_batchingDisabled() {
        Object[] mutationGroups = new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.del(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.del(5L, 6L), new Mutation[0])};
        SpannerIO.BatchableMutationFilterFn testFn = new SpannerIO.BatchableMutationFilterFn(null, null, 0L, 0L, 0L);
        DoFn.ProcessContext mockProcessContext = (DoFn.ProcessContext)Mockito.mock(DoFn.ProcessContext.class);
        Mockito.when((Object)mockProcessContext.sideInput((PCollectionView)Matchers.any())).thenReturn((Object)this.getSchema());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output(this.mutationGroupCaptor.capture());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output((TupleTag)Matchers.any(), this.mutationGroupListCaptor.capture());
        for (MutationGroup mutationGroup : mutationGroups) {
            Mockito.when((Object)mockProcessContext.element()).thenReturn((Object)mutationGroup);
            testFn.processElement(mockProcessContext);
        }
        Assert.assertTrue((boolean)this.mutationGroupCaptor.getAllValues().isEmpty());
        Iterable unbatchableMutations = Iterables.concat((Iterable)this.mutationGroupListCaptor.getAllValues());
        Assert.assertThat((Object)unbatchableMutations, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])mutationGroups));
    }

    @Test
    public void testGatherBundleAndSortFn() throws Exception {
        SpannerIO.GatherBundleAndSortFn testFn = new SpannerIO.GatherBundleAndSortFn(10000000L, 10L, 1000L, 100L, null);
        DoFn.ProcessContext mockProcessContext = (DoFn.ProcessContext)Mockito.mock(DoFn.ProcessContext.class);
        DoFn.FinishBundleContext mockFinishBundleContext = (DoFn.FinishBundleContext)Mockito.mock(DoFn.FinishBundleContext.class);
        Mockito.when((Object)mockProcessContext.sideInput((PCollectionView)Matchers.any())).thenReturn((Object)this.getSchema());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output(this.byteArrayKvListCaptor.capture());
        ((DoFn.FinishBundleContext)Mockito.doNothing().when((Object)mockFinishBundleContext)).output(this.byteArrayKvListCaptor.capture(), (Instant)Matchers.any(), (BoundedWindow)Matchers.any());
        MutationGroup[] mutationGroups = new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L)), SpannerIOWriteTest.g(SpannerIOWriteTest.del(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0])};
        testFn.startBundle();
        for (MutationGroup m : mutationGroups) {
            Mockito.when((Object)mockProcessContext.element()).thenReturn((Object)m);
            testFn.processElement(mockProcessContext);
        }
        testFn.finishBundle(mockFinishBundleContext);
        ((DoFn.ProcessContext)Mockito.verify((Object)mockProcessContext, (VerificationMode)Mockito.never())).output(Matchers.any());
        ((DoFn.FinishBundleContext)Mockito.verify((Object)mockFinishBundleContext, (VerificationMode)Mockito.times((int)1))).output(Matchers.any(), (Instant)Matchers.any(), (BoundedWindow)Matchers.any());
        List sorted = ((List)this.byteArrayKvListCaptor.getValue()).stream().map(kv -> SpannerIO.WriteGrouped.decode((byte[])((byte[])kv.getValue()))).collect(Collectors.toList());
        Assert.assertThat(sorted, (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.del(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L))}));
    }

    @Test
    public void testGatherBundleAndSortFn_flushOversizedBundle() throws Exception {
        SpannerIO.GatherBundleAndSortFn testFn = new SpannerIO.GatherBundleAndSortFn(10000000L, 7L, 1000L, 3L, null);
        DoFn.ProcessContext mockProcessContext = (DoFn.ProcessContext)Mockito.mock(DoFn.ProcessContext.class);
        DoFn.FinishBundleContext mockFinishBundleContext = (DoFn.FinishBundleContext)Mockito.mock(DoFn.FinishBundleContext.class);
        Mockito.when((Object)mockProcessContext.sideInput((PCollectionView)Matchers.any())).thenReturn((Object)this.getSchema());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output(this.byteArrayKvListCaptor.capture());
        ((DoFn.FinishBundleContext)Mockito.doNothing().when((Object)mockFinishBundleContext)).output(this.byteArrayKvListCaptor.capture(), (Instant)Matchers.any(), (BoundedWindow)Matchers.any());
        MutationGroup[] mutationGroups = new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L)), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(11L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0])};
        testFn.startBundle();
        for (MutationGroup m : mutationGroups) {
            Mockito.when((Object)mockProcessContext.element()).thenReturn((Object)m);
            testFn.processElement(mockProcessContext);
        }
        testFn.finishBundle(mockFinishBundleContext);
        ((DoFn.ProcessContext)Mockito.verify((Object)mockProcessContext, (VerificationMode)Mockito.times((int)3))).output(Matchers.any());
        ((DoFn.FinishBundleContext)Mockito.verify((Object)mockFinishBundleContext, (VerificationMode)Mockito.times((int)1))).output(Matchers.any(), (Instant)Matchers.any(), (BoundedWindow)Matchers.any());
        List kvGroups = this.byteArrayKvListCaptor.getAllValues();
        Assert.assertEquals((long)4L, (long)kvGroups.size());
        List mgListGroups = kvGroups.stream().map(l -> l.stream().map(kv -> SpannerIO.WriteGrouped.decode((byte[])((byte[])kv.getValue()))).collect(Collectors.toList())).collect(Collectors.toList());
        Assert.assertThat((Object)((List)mgListGroups.get(0)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0])}));
        Assert.assertThat((Object)((List)mgListGroups.get(1)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L))}));
        Assert.assertThat((Object)((List)mgListGroups.get(2)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(11L), new Mutation[0])}));
        Assert.assertThat((Object)((List)mgListGroups.get(3)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0])}));
    }

    @Test
    public void testBatchFn_cells() throws Exception {
        SpannerIO.BatchFn testFn = new SpannerIO.BatchFn(10000000L, 21L, 1000L, null);
        DoFn.ProcessContext mockProcessContext = (DoFn.ProcessContext)Mockito.mock(DoFn.ProcessContext.class);
        Mockito.when((Object)mockProcessContext.sideInput((PCollectionView)Matchers.any())).thenReturn((Object)this.getSchema());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output(this.mutationGroupListCaptor.capture());
        List<MutationGroup> mutationGroups = Arrays.asList(SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L)), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(11L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]));
        List encodedInput = mutationGroups.stream().map(mg -> KV.of((Object)null, (Object)SpannerIO.WriteGrouped.encode((MutationGroup)mg))).collect(Collectors.toList());
        Mockito.when((Object)mockProcessContext.element()).thenReturn(encodedInput);
        testFn.processElement(mockProcessContext);
        ((DoFn.ProcessContext)Mockito.verify((Object)mockProcessContext, (VerificationMode)Mockito.times((int)4))).output(Matchers.any());
        List batches = this.mutationGroupListCaptor.getAllValues();
        Assert.assertEquals((long)4L, (long)batches.size());
        Assert.assertThat((Object)((Iterable)batches.get(0)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0])}));
        Assert.assertThat((Object)((Iterable)batches.get(1)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L))}));
        Assert.assertThat((Object)((Iterable)batches.get(2)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(11L), new Mutation[0])}));
        Assert.assertThat((Object)((Iterable)batches.get(3)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0])}));
    }

    @Test
    public void testBatchFn_size() throws Exception {
        long mutationSize = MutationSizeEstimator.sizeOf((Mutation)SpannerIOWriteTest.m(1L));
        SpannerIO.BatchFn testFn = new SpannerIO.BatchFn(mutationSize * 3L, 1000L, 1000L, null);
        DoFn.ProcessContext mockProcessContext = (DoFn.ProcessContext)Mockito.mock(DoFn.ProcessContext.class);
        Mockito.when((Object)mockProcessContext.sideInput((PCollectionView)Matchers.any())).thenReturn((Object)this.getSchema());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output(this.mutationGroupListCaptor.capture());
        List<MutationGroup> mutationGroups = Arrays.asList(SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L)), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(11L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]));
        List encodedInput = mutationGroups.stream().map(mg -> KV.of((Object)null, (Object)SpannerIO.WriteGrouped.encode((MutationGroup)mg))).collect(Collectors.toList());
        Mockito.when((Object)mockProcessContext.element()).thenReturn(encodedInput);
        testFn.processElement(mockProcessContext);
        ((DoFn.ProcessContext)Mockito.verify((Object)mockProcessContext, (VerificationMode)Mockito.times((int)4))).output(Matchers.any());
        List batches = this.mutationGroupListCaptor.getAllValues();
        Assert.assertEquals((long)4L, (long)batches.size());
        Assert.assertThat((Object)((Iterable)batches.get(0)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0])}));
        Assert.assertThat((Object)((Iterable)batches.get(1)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L))}));
        Assert.assertThat((Object)((Iterable)batches.get(2)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(11L), new Mutation[0])}));
        Assert.assertThat((Object)((Iterable)batches.get(3)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0])}));
    }

    @Test
    public void testBatchFn_rows() throws Exception {
        SpannerIO.BatchFn testFn = new SpannerIO.BatchFn(10000000L, 1000L, 3L, null);
        DoFn.ProcessContext mockProcessContext = (DoFn.ProcessContext)Mockito.mock(DoFn.ProcessContext.class);
        Mockito.when((Object)mockProcessContext.sideInput((PCollectionView)Matchers.any())).thenReturn((Object)this.getSchema());
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)mockProcessContext)).output(this.mutationGroupListCaptor.capture());
        List<MutationGroup> mutationGroups = Arrays.asList(SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L)), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(11L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]));
        List encodedInput = mutationGroups.stream().map(mg -> KV.of((Object)null, (Object)SpannerIO.WriteGrouped.encode((MutationGroup)mg))).collect(Collectors.toList());
        Mockito.when((Object)mockProcessContext.element()).thenReturn(encodedInput);
        testFn.processElement(mockProcessContext);
        ((DoFn.ProcessContext)Mockito.verify((Object)mockProcessContext, (VerificationMode)Mockito.times((int)4))).output(Matchers.any());
        List batches = this.mutationGroupListCaptor.getAllValues();
        Assert.assertEquals((long)4L, (long)batches.size());
        Assert.assertThat((Object)((Iterable)batches.get(0)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0])}));
        Assert.assertThat((Object)((Iterable)batches.get(1)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L))}));
        Assert.assertThat((Object)((Iterable)batches.get(2)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(11L), new Mutation[0])}));
        Assert.assertThat((Object)((Iterable)batches.get(3)), (Matcher)org.hamcrest.Matchers.contains((Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0])}));
    }

    private static MutationGroup g(Mutation m, Mutation ... other) {
        return MutationGroup.create((Mutation)m, (Mutation[])other);
    }

    private static Mutation m(Long key) {
        return ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(key)).build();
    }

    private static Iterable<Mutation> batch(Mutation ... m) {
        return Arrays.asList(m);
    }

    private static Mutation del(Long ... keys) {
        KeySet.Builder builder = KeySet.newBuilder();
        for (Long key : keys) {
            builder.addKey(Key.of((Object[])new Object[]{key}));
        }
        return Mutation.delete((String)"test", (KeySet)builder.build());
    }

    private static Mutation delRange(Long start, Long end) {
        return Mutation.delete((String)"test", (KeySet)KeySet.range((KeyRange)KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{start}), (Key)Key.of((Object[])new Object[]{end}))));
    }

    private static Iterable<Mutation> mutationsInNoOrder(Iterable<Mutation> expected) {
        final ImmutableSet mutations = ImmutableSet.copyOf(expected);
        return (Iterable)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<Iterable<Mutation>>(){

            public boolean matches(Iterable<Mutation> argument) {
                if (!(argument instanceof Iterable)) {
                    return false;
                }
                ImmutableSet actual = ImmutableSet.copyOf(argument);
                return actual.equals((Object)mutations);
            }

            public String toString() {
                return "Iterable must match " + mutations;
            }
        });
    }

    private Iterable<Mutation> iterableOfSize(final int size) {
        return (Iterable)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<Iterable<Mutation>>(){

            public boolean matches(Iterable<Mutation> argument) {
                return argument instanceof Iterable && Iterables.size(argument) == size;
            }

            public String toString() {
                return "The size of the iterable must equal " + size;
            }
        });
    }
}

