/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import java.util.List;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_OrderedCodeTest_BytesTest;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_OrderedCodeTest_UnsignedNumber;
import org.apache.beam.sdk.io.gcp.spanner.OrderedCode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Bytes;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.UnsignedBytes;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.UnsignedInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OrderedCodeTest {
    @Test
    public void testUnsignedEncoding() {
        this.testEncoding((List<? extends CodingTestCase<?>>)UnsignedNumber.TEST_CASES);
    }

    @Test
    public void testUnsignedDecoding() {
        this.testDecoding((List<? extends CodingTestCase<?>>)UnsignedNumber.TEST_CASES);
    }

    @Test
    public void testUnsignedOrdering() {
        this.testOrdering((List<? extends CodingTestCase<?>>)UnsignedNumber.TEST_CASES);
    }

    @Test
    public void testBytesEncoding() {
        this.testEncoding((List<? extends CodingTestCase<?>>)BytesTest.TEST_CASES);
    }

    @Test
    public void testBytesDecoding() {
        this.testDecoding((List<? extends CodingTestCase<?>>)BytesTest.TEST_CASES);
    }

    @Test
    public void testBytesOrdering() {
        this.testOrdering((List<? extends CodingTestCase<?>>)BytesTest.TEST_CASES);
    }

    private void testEncoding(List<? extends CodingTestCase<?>> testCases) {
        for (CodingTestCase<?> testCase : testCases) {
            byte[] actualIncreasing = testCase.encodeIncreasing();
            byte[] expectedIncreasing = OrderedCodeTest.bytesFromHexString(testCase.increasingBytes());
            Assert.assertEquals((long)0L, (long)this.compare(actualIncreasing, expectedIncreasing));
            byte[] actualDecreasing = testCase.encodeDecreasing();
            byte[] expectedDecreasing = OrderedCodeTest.bytesFromHexString(testCase.decreasingBytes());
            Assert.assertEquals((long)0L, (long)this.compare(actualDecreasing, expectedDecreasing));
        }
    }

    private void testDecoding(List<? extends CodingTestCase<?>> testCases) {
        for (CodingTestCase<?> testCase : testCases) {
            Assert.assertEquals(testCase.value(), testCase.decodeIncreasing());
            Assert.assertEquals(testCase.value(), testCase.decodeDecreasing());
        }
    }

    private void testOrdering(List<? extends CodingTestCase<?>> testCases) {
        for (int caseIndex = 0; caseIndex < testCases.size() - 1; ++caseIndex) {
            byte[] nextEncodedValue;
            byte[] encodedValue = testCases.get(caseIndex).encodeIncreasing();
            Assert.assertTrue((this.compare(encodedValue, nextEncodedValue = testCases.get(caseIndex + 1).encodeIncreasing()) < 0 ? 1 : 0) != 0);
            encodedValue = testCases.get(caseIndex).encodeDecreasing();
            nextEncodedValue = testCases.get(caseIndex + 1).encodeDecreasing();
            Assert.assertTrue((this.compare(encodedValue, nextEncodedValue) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteInfinity() {
        OrderedCode orderedCode = new OrderedCode();
        try {
            orderedCode.readInfinity();
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        orderedCode.writeInfinity();
        Assert.assertTrue((boolean)orderedCode.readInfinity());
        try {
            orderedCode.readInfinity();
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteInfinityDecreasing() {
        OrderedCode orderedCode = new OrderedCode();
        try {
            orderedCode.readInfinityDecreasing();
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        orderedCode.writeInfinityDecreasing();
        Assert.assertTrue((boolean)orderedCode.readInfinityDecreasing());
        try {
            orderedCode.readInfinityDecreasing();
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteBytes() {
        byte[] first = new byte[]{97, 98, 99};
        byte[] second = new byte[]{100, 101, 102};
        byte[] last = new byte[]{120, 121, 122};
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeBytes(first);
        byte[] firstEncoded = orderedCode.getEncodedBytes();
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])first);
        orderedCode.writeBytes(first);
        orderedCode.writeBytes(second);
        orderedCode.writeBytes(last);
        byte[] allEncoded = orderedCode.getEncodedBytes();
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])first);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])second);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])last);
        orderedCode = new OrderedCode(firstEncoded);
        orderedCode.writeBytes(second);
        orderedCode.writeBytes(last);
        Assert.assertArrayEquals((byte[])orderedCode.getEncodedBytes(), (byte[])allEncoded);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])first);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])second);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])last);
        orderedCode = new OrderedCode(allEncoded);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])first);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])second);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])last);
    }

    @Test
    public void testWriteBytesDecreasing() {
        byte[] first = new byte[]{97, 98, 99};
        byte[] second = new byte[]{100, 101, 102};
        byte[] last = new byte[]{120, 121, 122};
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeBytesDecreasing(first);
        byte[] firstEncoded = orderedCode.getEncodedBytes();
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])first);
        orderedCode.writeBytesDecreasing(first);
        orderedCode.writeBytesDecreasing(second);
        orderedCode.writeBytesDecreasing(last);
        byte[] allEncoded = orderedCode.getEncodedBytes();
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])first);
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])second);
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])last);
        orderedCode = new OrderedCode(firstEncoded);
        orderedCode.writeBytesDecreasing(second);
        orderedCode.writeBytesDecreasing(last);
        Assert.assertArrayEquals((byte[])orderedCode.getEncodedBytes(), (byte[])allEncoded);
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])first);
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])second);
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])last);
        orderedCode = new OrderedCode(allEncoded);
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])first);
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])second);
        Assert.assertArrayEquals((byte[])orderedCode.readBytesDecreasing(), (byte[])last);
    }

    @Test
    public void testWriteNumIncreasing() {
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeNumIncreasing(0L);
        orderedCode.writeNumIncreasing(1L);
        orderedCode.writeNumIncreasing(Long.MIN_VALUE);
        orderedCode.writeNumIncreasing(Long.MAX_VALUE);
        Assert.assertEquals((long)0L, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)1L, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)orderedCode.readNumIncreasing());
    }

    @Test
    public void testWriteNumIncreasing_unsignedInt() {
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeNumIncreasing(UnsignedInteger.fromIntBits((int)0));
        orderedCode.writeNumIncreasing(UnsignedInteger.fromIntBits((int)1));
        orderedCode.writeNumIncreasing(UnsignedInteger.fromIntBits((int)Integer.MIN_VALUE));
        orderedCode.writeNumIncreasing(UnsignedInteger.fromIntBits((int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)1L, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)0x80000000L, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)orderedCode.readNumIncreasing());
    }

    @Test
    public void testWriteNumDecreasing() {
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeNumDecreasing(0L);
        orderedCode.writeNumDecreasing(1L);
        orderedCode.writeNumDecreasing(Long.MIN_VALUE);
        orderedCode.writeNumDecreasing(Long.MAX_VALUE);
        Assert.assertEquals((long)0L, (long)orderedCode.readNumDecreasing());
        Assert.assertEquals((long)1L, (long)orderedCode.readNumDecreasing());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)orderedCode.readNumDecreasing());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)orderedCode.readNumDecreasing());
    }

    @Test
    public void testWriteNumDecreasing_unsignedInt() {
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeNumDecreasing(UnsignedInteger.fromIntBits((int)0));
        orderedCode.writeNumDecreasing(UnsignedInteger.fromIntBits((int)1));
        orderedCode.writeNumDecreasing(UnsignedInteger.fromIntBits((int)Integer.MIN_VALUE));
        orderedCode.writeNumDecreasing(UnsignedInteger.fromIntBits((int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)orderedCode.readNumDecreasing());
        Assert.assertEquals((long)1L, (long)orderedCode.readNumDecreasing());
        Assert.assertEquals((long)0x80000000L, (long)orderedCode.readNumDecreasing());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)orderedCode.readNumDecreasing());
    }

    private static void assertSignedNumIncreasingEncodingEquals(String expectedHexEncoding, long num) {
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeSignedNumIncreasing(num);
        Assert.assertEquals((String)("Unexpected encoding for " + num), (Object)expectedHexEncoding, (Object)OrderedCodeTest.bytesToHexString(orderedCode.getEncodedBytes()));
    }

    @Test
    public void testSignedNumIncreasing_write() {
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("003f8000000000000000", Long.MIN_VALUE);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("003f8000000000000001", -9223372036854775807L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("077fffffff", -2147483649L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("0780000000", Integer.MIN_VALUE);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("0780000001", -2147483647L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("3fbf", -65L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("40", -64L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("41", -63L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("7d", -3L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("7e", -2L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("7f", -1L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("80", 0L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("81", 1L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("82", 2L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("83", 3L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("bf", 63L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("c040", 64L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("c041", 65L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("f87ffffffe", 0x7FFFFFFEL);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("f87fffffff", Integer.MAX_VALUE);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("f880000000", 0x80000000L);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("ffc07ffffffffffffffe", 0x7FFFFFFFFFFFFFFEL);
        OrderedCodeTest.assertSignedNumIncreasingEncodingEquals("ffc07fffffffffffffff", Long.MAX_VALUE);
    }

    private static byte[] bytesFromHexString(String hexDigits) {
        return BaseEncoding.base16().lowerCase().decode((CharSequence)hexDigits);
    }

    private static String bytesToHexString(byte[] bytes) {
        return BaseEncoding.base16().lowerCase().encode(bytes);
    }

    private static void assertDecodedSignedNumIncreasingEquals(long expectedNum, String encodedHexString) {
        OrderedCode orderedCode = new OrderedCode(OrderedCodeTest.bytesFromHexString(encodedHexString));
        Assert.assertEquals((String)("Unexpected value when decoding 0x" + encodedHexString), (long)expectedNum, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertFalse((String)("Unexpected encoded bytes remain after decoding 0x" + encodedHexString), (boolean)orderedCode.hasRemainingEncodedBytes());
    }

    @Test
    public void testSignedNumIncreasing_read() {
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(Long.MIN_VALUE, "003f8000000000000000");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(-9223372036854775807L, "003f8000000000000001");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(-2147483649L, "077fffffff");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(Integer.MIN_VALUE, "0780000000");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(-2147483647L, "0780000001");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(-65L, "3fbf");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(-64L, "40");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(-63L, "41");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(-3L, "7d");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(-2L, "7e");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(-1L, "7f");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(0L, "80");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(1L, "81");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(2L, "82");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(3L, "83");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(63L, "bf");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(64L, "c040");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(65L, "c041");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(0x7FFFFFFEL, "f87ffffffe");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(Integer.MAX_VALUE, "f87fffffff");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(0x80000000L, "f880000000");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(0x7FFFFFFFFFFFFFFEL, "ffc07ffffffffffffffe");
        OrderedCodeTest.assertDecodedSignedNumIncreasingEquals(Long.MAX_VALUE, "ffc07fffffffffffffff");
    }

    private static void assertSignedNumIncreasingWriteAndReadIsLossless(long num) {
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeSignedNumIncreasing(num);
        Assert.assertEquals((String)("Unexpected result when decoding writeSignedNumIncreasing(" + num + ")"), (long)num, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertFalse((String)("Unexpected remaining encoded bytes after decoding " + num), (boolean)orderedCode.hasRemainingEncodedBytes());
    }

    @Test
    public void testSignedNumIncreasing_writeAndRead() {
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(Long.MIN_VALUE);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(-9223372036854775807L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(-2147483649L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(Integer.MIN_VALUE);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(-2147483647L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(-65L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(-64L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(-63L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(-3L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(-2L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(-1L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(0L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(1L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(2L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(3L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(63L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(64L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(65L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(0x7FFFFFFEL);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(Integer.MAX_VALUE);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(0x80000000L);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(0x7FFFFFFFFFFFFFFEL);
        OrderedCodeTest.assertSignedNumIncreasingWriteAndReadIsLossless(Long.MAX_VALUE);
    }

    private static void assertSignedNumDecreasingWriteAndReadIsLossless(long num) {
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeSignedNumDecreasing(num);
        Assert.assertEquals((String)("Unexpected result when decoding writeSignedNumDecreasing(" + num + ")"), (long)num, (long)orderedCode.readSignedNumDecreasing());
        Assert.assertFalse((String)("Unexpected remaining encoded bytes after decoding " + num), (boolean)orderedCode.hasRemainingEncodedBytes());
    }

    @Test
    public void testSignedNumDecreasing_writeAndRead() {
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(Long.MIN_VALUE);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(-9223372036854775807L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(-2147483649L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(Integer.MIN_VALUE);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(-2147483647L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(-65L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(-64L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(-63L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(-3L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(-2L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(-1L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(0L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(1L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(2L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(3L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(63L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(64L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(65L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(0x7FFFFFFEL);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(Integer.MAX_VALUE);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(0x80000000L);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(0x7FFFFFFFFFFFFFFEL);
        OrderedCodeTest.assertSignedNumDecreasingWriteAndReadIsLossless(Long.MAX_VALUE);
    }

    @Test
    public void testDecreasing() {
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeSignedNumDecreasing(10L);
        byte[] ten = orderedCode.getEncodedBytes();
        orderedCode = new OrderedCode();
        orderedCode.writeSignedNumDecreasing(20L);
        byte[] twenty = orderedCode.getEncodedBytes();
        Assert.assertTrue((this.compare(twenty, ten) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLog2Floor_Positive() {
        OrderedCode orderedCode = new OrderedCode();
        Assert.assertEquals((long)0L, (long)orderedCode.log2Floor(1L));
        Assert.assertEquals((long)1L, (long)orderedCode.log2Floor(2L));
        Assert.assertEquals((long)1L, (long)orderedCode.log2Floor(3L));
        Assert.assertEquals((long)2L, (long)orderedCode.log2Floor(4L));
        Assert.assertEquals((long)5L, (long)orderedCode.log2Floor(63L));
        Assert.assertEquals((long)6L, (long)orderedCode.log2Floor(64L));
        Assert.assertEquals((long)62L, (long)orderedCode.log2Floor(Long.MAX_VALUE));
    }

    @Test
    public void testLog2Floor_zero() {
        OrderedCode orderedCode = new OrderedCode();
        Assert.assertEquals((long)-1L, (long)orderedCode.log2Floor(0L));
    }

    @Test
    public void testLog2Floor_negative() {
        OrderedCode orderedCode = new OrderedCode();
        try {
            orderedCode.log2Floor(-1L);
            Assert.fail((String)"Expected an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSignedEncodingLength() {
        OrderedCode orderedCode = new OrderedCode();
        Assert.assertEquals((long)10L, (long)orderedCode.getSignedEncodingLength(Long.MIN_VALUE));
        Assert.assertEquals((long)10L, (long)orderedCode.getSignedEncodingLength(-4611686018427387905L));
        Assert.assertEquals((long)9L, (long)orderedCode.getSignedEncodingLength(-4611686018427387904L));
        Assert.assertEquals((long)3L, (long)orderedCode.getSignedEncodingLength(-8193L));
        Assert.assertEquals((long)2L, (long)orderedCode.getSignedEncodingLength(-8192L));
        Assert.assertEquals((long)2L, (long)orderedCode.getSignedEncodingLength(-65L));
        Assert.assertEquals((long)1L, (long)orderedCode.getSignedEncodingLength(-64L));
        Assert.assertEquals((long)1L, (long)orderedCode.getSignedEncodingLength(-2L));
        Assert.assertEquals((long)1L, (long)orderedCode.getSignedEncodingLength(-1L));
        Assert.assertEquals((long)1L, (long)orderedCode.getSignedEncodingLength(0L));
        Assert.assertEquals((long)1L, (long)orderedCode.getSignedEncodingLength(1L));
        Assert.assertEquals((long)1L, (long)orderedCode.getSignedEncodingLength(63L));
        Assert.assertEquals((long)2L, (long)orderedCode.getSignedEncodingLength(64L));
        Assert.assertEquals((long)2L, (long)orderedCode.getSignedEncodingLength(8191L));
        Assert.assertEquals((long)3L, (long)orderedCode.getSignedEncodingLength(8192L));
        Assert.assertEquals((long)9L, (long)(orderedCode.getSignedEncodingLength(0x4000000000000000L) - 1));
        Assert.assertEquals((long)10L, (long)orderedCode.getSignedEncodingLength(0x4000000000000000L));
        Assert.assertEquals((long)10L, (long)orderedCode.getSignedEncodingLength(Long.MAX_VALUE));
    }

    @Test
    public void testWriteTrailingBytes() {
        byte[] escapeChars = new byte[]{0, -1, 1, -1, -1, 0};
        byte[] anotherArray = new byte[]{97, 98, 99, 100, 101};
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeTrailingBytes(escapeChars);
        Assert.assertArrayEquals((byte[])orderedCode.getEncodedBytes(), (byte[])escapeChars);
        Assert.assertArrayEquals((byte[])orderedCode.readTrailingBytes(), (byte[])escapeChars);
        try {
            orderedCode.readInfinity();
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        orderedCode = new OrderedCode();
        orderedCode.writeTrailingBytes(anotherArray);
        Assert.assertArrayEquals((byte[])orderedCode.getEncodedBytes(), (byte[])anotherArray);
        Assert.assertArrayEquals((byte[])orderedCode.readTrailingBytes(), (byte[])anotherArray);
    }

    @Test
    public void testMixedWrite() {
        byte[] first = new byte[]{97, 98, 99};
        byte[] second = new byte[]{100, 101, 102};
        byte[] last = new byte[]{120, 121, 122};
        byte[] escapeChars = new byte[]{0, -1, 1, -1, -1, 0};
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeBytes(first);
        orderedCode.writeBytes(second);
        orderedCode.writeBytes(last);
        orderedCode.writeInfinity();
        orderedCode.writeNumIncreasing(0L);
        orderedCode.writeNumIncreasing(1L);
        orderedCode.writeNumIncreasing(Long.MIN_VALUE);
        orderedCode.writeNumIncreasing(Long.MAX_VALUE);
        orderedCode.writeSignedNumIncreasing(0L);
        orderedCode.writeSignedNumIncreasing(1L);
        orderedCode.writeSignedNumIncreasing(Long.MIN_VALUE);
        orderedCode.writeSignedNumIncreasing(Long.MAX_VALUE);
        orderedCode.writeTrailingBytes(escapeChars);
        byte[] allEncoded = orderedCode.getEncodedBytes();
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])first);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])second);
        Assert.assertFalse((boolean)orderedCode.readInfinity());
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])last);
        Assert.assertTrue((boolean)orderedCode.readInfinity());
        Assert.assertEquals((long)0L, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)1L, (long)orderedCode.readNumIncreasing());
        Assert.assertFalse((boolean)orderedCode.readInfinity());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)0L, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertEquals((long)1L, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertFalse((boolean)orderedCode.readInfinity());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertArrayEquals((byte[])orderedCode.getEncodedBytes(), (byte[])escapeChars);
        Assert.assertArrayEquals((byte[])orderedCode.readTrailingBytes(), (byte[])escapeChars);
        orderedCode = new OrderedCode(allEncoded);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])first);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])second);
        Assert.assertFalse((boolean)orderedCode.readInfinity());
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])last);
        Assert.assertTrue((boolean)orderedCode.readInfinity());
        Assert.assertEquals((long)0L, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)1L, (long)orderedCode.readNumIncreasing());
        Assert.assertFalse((boolean)orderedCode.readInfinity());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)orderedCode.readNumIncreasing());
        Assert.assertEquals((long)0L, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertEquals((long)1L, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertFalse((boolean)orderedCode.readInfinity());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)orderedCode.readSignedNumIncreasing());
        Assert.assertArrayEquals((byte[])orderedCode.getEncodedBytes(), (byte[])escapeChars);
        Assert.assertArrayEquals((byte[])orderedCode.readTrailingBytes(), (byte[])escapeChars);
    }

    @Test
    public void testEdgeCases() {
        byte[] ffChar = new byte[]{0};
        byte[] nullChar = new byte[]{-1};
        byte[] separatorEncoded = new byte[]{0, 1};
        byte[] ffCharEncoded = new byte[]{0, -1};
        byte[] nullCharEncoded = new byte[]{-1, 0};
        byte[] infinityEncoded = new byte[]{-1, -1};
        OrderedCode orderedCode = new OrderedCode();
        orderedCode.writeBytes(ffChar);
        orderedCode.writeBytes(nullChar);
        orderedCode.writeInfinity();
        Assert.assertArrayEquals((byte[])orderedCode.getEncodedBytes(), (byte[])Bytes.concat((byte[][])new byte[][]{ffCharEncoded, separatorEncoded, nullCharEncoded, separatorEncoded, infinityEncoded}));
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])ffChar);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])nullChar);
        Assert.assertTrue((boolean)orderedCode.readInfinity());
        orderedCode = new OrderedCode(Bytes.concat((byte[][])new byte[][]{ffCharEncoded, separatorEncoded}));
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])ffChar);
        orderedCode = new OrderedCode(Bytes.concat((byte[][])new byte[][]{nullCharEncoded, separatorEncoded}));
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])nullChar);
        byte[] invalidEncodingForRead = new byte[]{-1, -1, 0, 1};
        orderedCode = new OrderedCode(invalidEncodingForRead);
        try {
            orderedCode.readBytes();
            Assert.fail((String)"Should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertTrue((boolean)orderedCode.hasRemainingEncodedBytes());
    }

    @Test
    public void testHasRemainingEncodedBytes() {
        byte[] bytes = new byte[]{97, 98, 99};
        long number = 12345L;
        OrderedCode orderedCode = new OrderedCode();
        Assert.assertFalse((boolean)orderedCode.hasRemainingEncodedBytes());
        orderedCode.writeBytes(bytes);
        Assert.assertTrue((boolean)orderedCode.hasRemainingEncodedBytes());
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])bytes);
        Assert.assertFalse((boolean)orderedCode.hasRemainingEncodedBytes());
        orderedCode.writeNumIncreasing(number);
        Assert.assertTrue((boolean)orderedCode.hasRemainingEncodedBytes());
        Assert.assertEquals((long)orderedCode.readNumIncreasing(), (long)number);
        Assert.assertFalse((boolean)orderedCode.hasRemainingEncodedBytes());
        orderedCode.writeSignedNumIncreasing(number);
        Assert.assertTrue((boolean)orderedCode.hasRemainingEncodedBytes());
        Assert.assertEquals((long)orderedCode.readSignedNumIncreasing(), (long)number);
        Assert.assertFalse((boolean)orderedCode.hasRemainingEncodedBytes());
        orderedCode.writeInfinity();
        Assert.assertTrue((boolean)orderedCode.hasRemainingEncodedBytes());
        Assert.assertTrue((boolean)orderedCode.readInfinity());
        Assert.assertFalse((boolean)orderedCode.hasRemainingEncodedBytes());
        orderedCode.writeTrailingBytes(bytes);
        Assert.assertTrue((boolean)orderedCode.hasRemainingEncodedBytes());
        Assert.assertArrayEquals((byte[])orderedCode.readTrailingBytes(), (byte[])bytes);
        Assert.assertFalse((boolean)orderedCode.hasRemainingEncodedBytes());
        orderedCode.writeBytes(bytes);
        orderedCode.writeBytes(bytes);
        Assert.assertTrue((boolean)orderedCode.hasRemainingEncodedBytes());
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])bytes);
        Assert.assertArrayEquals((byte[])orderedCode.readBytes(), (byte[])bytes);
        Assert.assertFalse((boolean)orderedCode.hasRemainingEncodedBytes());
    }

    @Test
    public void testOrderingInfinity() {
        OrderedCode inf = new OrderedCode();
        inf.writeInfinity();
        OrderedCode negInf = new OrderedCode();
        negInf.writeInfinityDecreasing();
        OrderedCode longValue = new OrderedCode();
        longValue.writeSignedNumIncreasing(1L);
        Assert.assertTrue((this.compare(inf.getEncodedBytes(), negInf.getEncodedBytes()) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.compare(longValue.getEncodedBytes(), negInf.getEncodedBytes()) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.compare(inf.getEncodedBytes(), longValue.getEncodedBytes()) > 0 ? 1 : 0) != 0);
    }

    private int compare(byte[] bytes1, byte[] bytes2) {
        return UnsignedBytes.lexicographicalComparator().compare(bytes1, bytes2);
    }

    @AutoValue
    static abstract class BytesTest
    extends CodingTestCase<String> {
        private static final ImmutableList<BytesTest> TEST_CASES = ImmutableList.of((Object)BytesTest.testCase("", "0001", "fffe"), (Object)BytesTest.testCase("00", "00ff0001", "ff00fffe"), (Object)BytesTest.testCase("0000", "00ff00ff0001", "ff00ff00fffe"), (Object)BytesTest.testCase("0001", "00ff010001", "ff00fefffe"), (Object)BytesTest.testCase("0041", "00ff410001", "ff00befffe"), (Object)BytesTest.testCase("00ff", "00ffff000001", "ff0000fffffe"), (Object)BytesTest.testCase("01", "010001", "fefffe"), (Object)BytesTest.testCase("0100", "0100ff0001", "feff00fffe"), (Object)BytesTest.testCase("6f776c", "6f776c0001", "908893fffe"), (Object)BytesTest.testCase("ff", "ff000001", "00fffffe"), (Object)BytesTest.testCase("ff00", "ff0000ff0001", "00ffff00fffe"), (Object)BytesTest.testCase("ff01", "ff00010001", "00fffefffe"), (Object[])new BytesTest[]{BytesTest.testCase("ffff", "ff00ff000001", "00ff00fffffe"), BytesTest.testCase("ffffff", "ff00ff00ff000001", "00ff00ff00fffffe")});

        BytesTest() {
        }

        @Override
        byte[] encodeIncreasing() {
            OrderedCode orderedCode = new OrderedCode();
            orderedCode.writeBytes(OrderedCodeTest.bytesFromHexString((String)this.value()));
            return orderedCode.getEncodedBytes();
        }

        @Override
        byte[] encodeDecreasing() {
            OrderedCode orderedCode = new OrderedCode();
            orderedCode.writeBytesDecreasing(OrderedCodeTest.bytesFromHexString((String)this.value()));
            return orderedCode.getEncodedBytes();
        }

        @Override
        String decodeIncreasing(OrderedCode orderedCode) {
            return OrderedCodeTest.bytesToHexString(orderedCode.readBytes());
        }

        @Override
        String decodeDecreasing(OrderedCode orderedCode) {
            return OrderedCodeTest.bytesToHexString(orderedCode.readBytesDecreasing());
        }

        private static BytesTest testCase(String value, String increasingBytes, String decreasingBytes) {
            return new AutoValue_OrderedCodeTest_BytesTest(value, increasingBytes, decreasingBytes);
        }
    }

    @AutoValue
    static abstract class UnsignedNumber
    extends CodingTestCase<Long> {
        private static final ImmutableList<UnsignedNumber> TEST_CASES = ImmutableList.of((Object)UnsignedNumber.testCase(0L, "00", "ff"), (Object)UnsignedNumber.testCase(1L, "0101", "fefe"), (Object)UnsignedNumber.testCase(33L, "0121", "fede"), (Object)UnsignedNumber.testCase(55000L, "02d6d8", "fd2927"), (Object)UnsignedNumber.testCase(Integer.MAX_VALUE, "047fffffff", "fb80000000"), (Object)UnsignedNumber.testCase(Long.MAX_VALUE, "087fffffffffffffff", "f78000000000000000"), (Object)UnsignedNumber.testCase(Long.MIN_VALUE, "088000000000000000", "f77fffffffffffffff"), (Object)UnsignedNumber.testCase(-100L, "08ffffffffffffff9c", "f70000000000000063"), (Object)UnsignedNumber.testCase(-1L, "08ffffffffffffffff", "f70000000000000000"));

        UnsignedNumber() {
        }

        @Override
        byte[] encodeIncreasing() {
            OrderedCode orderedCode = new OrderedCode();
            orderedCode.writeNumIncreasing(((Long)this.value()).longValue());
            return orderedCode.getEncodedBytes();
        }

        @Override
        byte[] encodeDecreasing() {
            OrderedCode orderedCode = new OrderedCode();
            orderedCode.writeNumDecreasing(((Long)this.value()).longValue());
            return orderedCode.getEncodedBytes();
        }

        @Override
        Long decodeIncreasing(OrderedCode orderedCode) {
            return orderedCode.readNumIncreasing();
        }

        @Override
        Long decodeDecreasing(OrderedCode orderedCode) {
            return orderedCode.readNumDecreasing();
        }

        private static UnsignedNumber testCase(long value, String increasingBytes, String decreasingBytes) {
            return new AutoValue_OrderedCodeTest_UnsignedNumber(value, increasingBytes, decreasingBytes);
        }
    }

    static abstract class CodingTestCase<T> {
        CodingTestCase() {
        }

        abstract T value();

        abstract String increasingBytes();

        abstract String decreasingBytes();

        abstract byte[] encodeIncreasing();

        abstract byte[] encodeDecreasing();

        T decodeIncreasing() {
            return this.decodeIncreasing(new OrderedCode(OrderedCodeTest.bytesFromHexString(this.increasingBytes())));
        }

        T decodeDecreasing() {
            return this.decodeDecreasing(new OrderedCode(OrderedCodeTest.bytesFromHexString(this.decreasingBytes())));
        }

        abstract T decodeIncreasing(OrderedCode var1);

        abstract T decodeDecreasing(OrderedCode var1);
    }
}

