/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithMessageIdCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PubsubMessageWithMessageIdCoderTest {
    private static final String DATA = "testData";
    private static final String MESSAGE_ID = "testMessageId";
    private static final Coder<PubsubMessage> TEST_CODER = PubsubMessageWithMessageIdCoder.of();
    private static final PubsubMessage TEST_VALUE = new PubsubMessage("testData".getBytes(StandardCharsets.UTF_8), null, "testMessageId");

    @Test
    public void testValueEncodable() throws Exception {
        SerializableUtils.ensureSerializableByCoder(TEST_CODER, (Object)TEST_VALUE, (String)"error");
    }

    @Test
    public void testCoderDecodeEncodeEqual() throws Exception {
        CoderProperties.structuralValueDecodeEncodeEqual(TEST_CODER, (Object)TEST_VALUE);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        TypeDescriptor<PubsubMessage> typeDescriptor = new TypeDescriptor<PubsubMessage>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)typeDescriptor));
    }
}

