/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesAndMessageIdCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PubsubMessageWithAttributesAndMessageIdCoderTest {
    private static final String DATA = "testData";
    private static final String MESSAGE_ID = "testMessageId";
    private static final Map<String, String> ATTRIBUTES = new ImmutableMap.Builder().put((Object)"1", (Object)"hello").build();
    private static final Coder<PubsubMessage> TEST_CODER = PubsubMessageWithAttributesAndMessageIdCoder.of();
    private static final PubsubMessage TEST_VALUE = new PubsubMessage("testData".getBytes(StandardCharsets.UTF_8), ATTRIBUTES, "testMessageId");

    @Test
    public void testValueEncodable() throws Exception {
        SerializableUtils.ensureSerializableByCoder(TEST_CODER, (Object)TEST_VALUE, (String)"error");
    }

    @Test
    public void testCoderDecodeEncodeEqual() throws Exception {
        CoderProperties.structuralValueDecodeEncodeEqual(TEST_CODER, (Object)TEST_VALUE);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        TypeDescriptor<PubsubMessage> typeDescriptor = new TypeDescriptor<PubsubMessage>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)typeDescriptor));
    }
}

