/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.ListSubscriptionsResponse;
import com.google.api.services.pubsub.model.ListTopicsResponse;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PublishResponse;
import com.google.api.services.pubsub.model.PubsubMessage;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.ReceivedMessage;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.Topic;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubJsonClient;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class PubsubJsonClientTest {
    private Pubsub mockPubsub;
    private PubsubClient client;
    private static final PubsubClient.ProjectPath PROJECT = PubsubClient.projectPathFromId((String)"testProject");
    private static final PubsubClient.TopicPath TOPIC = PubsubClient.topicPathFromName((String)"testProject", (String)"testTopic");
    private static final PubsubClient.SubscriptionPath SUBSCRIPTION = PubsubClient.subscriptionPathFromName((String)"testProject", (String)"testSubscription");
    private static final long REQ_TIME = 1234L;
    private static final long PUB_TIME = 3456L;
    private static final long MESSAGE_TIME = 6789L;
    private static final String TIMESTAMP_ATTRIBUTE = "timestamp";
    private static final String ID_ATTRIBUTE = "id";
    private static final String MESSAGE_ID = "testMessageId";
    private static final String DATA = "testData";
    private static final String RECORD_ID = "testRecordId";
    private static final String ACK_ID = "testAckId";
    private static final String ORDERING_KEY = "testOrderingKey";

    @Before
    public void setup() {
        this.mockPubsub = (Pubsub)Mockito.mock(Pubsub.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.client = new PubsubJsonClient(TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, this.mockPubsub);
    }

    @After
    public void teardown() throws IOException {
        this.client.close();
        this.client = null;
        this.mockPubsub = null;
    }

    @Test
    public void pullOneMessage() throws IOException {
        String expectedSubscription = SUBSCRIPTION.getPath();
        PullRequest expectedRequest = new PullRequest().setReturnImmediately(Boolean.valueOf(true)).setMaxMessages(Integer.valueOf(10));
        PubsubMessage expectedPubsubMessage = new PubsubMessage().setMessageId(MESSAGE_ID).encodeData(DATA.getBytes(StandardCharsets.UTF_8)).setPublishTime(String.valueOf(3456L)).setAttributes((Map)ImmutableMap.of((Object)TIMESTAMP_ATTRIBUTE, (Object)String.valueOf(6789L), (Object)ID_ATTRIBUTE, (Object)RECORD_ID)).set("orderingKey", (Object)ORDERING_KEY);
        ReceivedMessage expectedReceivedMessage = new ReceivedMessage().setMessage(expectedPubsubMessage).setAckId(ACK_ID);
        PullResponse expectedResponse = new PullResponse().setReceivedMessages((List)ImmutableList.of((Object)expectedReceivedMessage));
        Mockito.when((Object)this.mockPubsub.projects().subscriptions().pull(expectedSubscription, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        List acutalMessages = this.client.pull(1234L, SUBSCRIPTION, 10, true);
        Assert.assertEquals((long)1L, (long)acutalMessages.size());
        PubsubClient.IncomingMessage actualMessage = (PubsubClient.IncomingMessage)acutalMessages.get(0);
        Assert.assertEquals((Object)ACK_ID, (Object)actualMessage.ackId());
        Assert.assertEquals((Object)DATA, (Object)actualMessage.message().getData().toStringUtf8());
        Assert.assertEquals((Object)RECORD_ID, (Object)actualMessage.recordId());
        Assert.assertEquals((long)1234L, (long)actualMessage.requestTimeMsSinceEpoch());
        Assert.assertEquals((long)6789L, (long)actualMessage.timestampMsSinceEpoch());
        Assert.assertEquals((Object)ORDERING_KEY, (Object)actualMessage.message().getOrderingKey());
    }

    @Test
    public void pullOneMessageEmptyAttributes() throws IOException {
        this.client = new PubsubJsonClient(null, null, this.mockPubsub);
        String expectedSubscription = SUBSCRIPTION.getPath();
        PullRequest expectedRequest = new PullRequest().setReturnImmediately(Boolean.valueOf(true)).setMaxMessages(Integer.valueOf(10));
        PubsubMessage expectedPubsubMessage = new PubsubMessage().setMessageId(MESSAGE_ID).encodeData(DATA.getBytes(StandardCharsets.UTF_8)).setPublishTime(String.valueOf(3456L));
        ReceivedMessage expectedReceivedMessage = new ReceivedMessage().setMessage(expectedPubsubMessage).setAckId(ACK_ID);
        PullResponse expectedResponse = new PullResponse().setReceivedMessages((List)ImmutableList.of((Object)expectedReceivedMessage));
        Mockito.when((Object)this.mockPubsub.projects().subscriptions().pull(expectedSubscription, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        List acutalMessages = this.client.pull(1234L, SUBSCRIPTION, 10, true);
        Assert.assertEquals((long)1L, (long)acutalMessages.size());
        PubsubClient.IncomingMessage actualMessage = (PubsubClient.IncomingMessage)acutalMessages.get(0);
        Assert.assertEquals((Object)ACK_ID, (Object)actualMessage.ackId());
        Assert.assertEquals((Object)DATA, (Object)actualMessage.message().getData().toStringUtf8());
        Assert.assertEquals((long)1234L, (long)actualMessage.requestTimeMsSinceEpoch());
        Assert.assertEquals((long)3456L, (long)actualMessage.timestampMsSinceEpoch());
    }

    @Test
    public void pullOneMessageWithNoData() throws IOException {
        String expectedSubscription = SUBSCRIPTION.getPath();
        PullRequest expectedRequest = new PullRequest().setReturnImmediately(Boolean.valueOf(true)).setMaxMessages(Integer.valueOf(10));
        PubsubMessage expectedPubsubMessage = new PubsubMessage().setMessageId(MESSAGE_ID).setPublishTime(String.valueOf(3456L)).setAttributes((Map)ImmutableMap.of((Object)TIMESTAMP_ATTRIBUTE, (Object)String.valueOf(6789L), (Object)ID_ATTRIBUTE, (Object)RECORD_ID));
        ReceivedMessage expectedReceivedMessage = new ReceivedMessage().setMessage(expectedPubsubMessage).setAckId(ACK_ID);
        PullResponse expectedResponse = new PullResponse().setReceivedMessages((List)ImmutableList.of((Object)expectedReceivedMessage));
        Mockito.when((Object)this.mockPubsub.projects().subscriptions().pull(expectedSubscription, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        List acutalMessages = this.client.pull(1234L, SUBSCRIPTION, 10, true);
        Assert.assertEquals((long)1L, (long)acutalMessages.size());
        PubsubClient.IncomingMessage actualMessage = (PubsubClient.IncomingMessage)acutalMessages.get(0);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])actualMessage.message().getData().toByteArray());
    }

    @Test
    public void publishOneMessage() throws IOException {
        String expectedTopic = TOPIC.getPath();
        PubsubMessage expectedPubsubMessage = new PubsubMessage().encodeData(DATA.getBytes(StandardCharsets.UTF_8)).setAttributes((Map)ImmutableMap.builder().put((Object)TIMESTAMP_ATTRIBUTE, (Object)String.valueOf(6789L)).put((Object)ID_ATTRIBUTE, (Object)RECORD_ID).put((Object)"k", (Object)"v").build()).set("orderingKey", (Object)ORDERING_KEY);
        PublishRequest expectedRequest = new PublishRequest().setMessages((List)ImmutableList.of((Object)expectedPubsubMessage));
        PublishResponse expectedResponse = new PublishResponse().setMessageIds((List)ImmutableList.of((Object)MESSAGE_ID));
        Mockito.when((Object)this.mockPubsub.projects().topics().publish(expectedTopic, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("k", "v");
        PubsubClient.OutgoingMessage actualMessage = PubsubClient.OutgoingMessage.of((com.google.pubsub.v1.PubsubMessage)com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)DATA)).putAllAttributes(attrs).setOrderingKey(ORDERING_KEY).build(), (long)6789L, (String)RECORD_ID);
        int n = this.client.publish(TOPIC, (List)ImmutableList.of((Object)actualMessage));
        Assert.assertEquals((long)1L, (long)n);
    }

    @Test
    public void publishOneMessageWithOnlyTimestampAndIdAttributes() throws IOException {
        String expectedTopic = TOPIC.getPath();
        PubsubMessage expectedPubsubMessage = new PubsubMessage().encodeData(DATA.getBytes(StandardCharsets.UTF_8)).setAttributes((Map)ImmutableMap.builder().put((Object)TIMESTAMP_ATTRIBUTE, (Object)String.valueOf(6789L)).put((Object)ID_ATTRIBUTE, (Object)RECORD_ID).build());
        PublishRequest expectedRequest = new PublishRequest().setMessages((List)ImmutableList.of((Object)expectedPubsubMessage));
        PublishResponse expectedResponse = new PublishResponse().setMessageIds((List)ImmutableList.of((Object)MESSAGE_ID));
        Mockito.when((Object)this.mockPubsub.projects().topics().publish(expectedTopic, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        PubsubClient.OutgoingMessage actualMessage = PubsubClient.OutgoingMessage.of((com.google.pubsub.v1.PubsubMessage)com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)DATA)).build(), (long)6789L, (String)RECORD_ID);
        int n = this.client.publish(TOPIC, (List)ImmutableList.of((Object)actualMessage));
        Assert.assertEquals((long)1L, (long)n);
    }

    @Test
    public void publishOneMessageWithNoTimestampOrIdAttribute() throws IOException {
        this.client = new PubsubJsonClient(null, null, this.mockPubsub);
        String expectedTopic = TOPIC.getPath();
        PubsubMessage expectedPubsubMessage = new PubsubMessage().encodeData(DATA.getBytes(StandardCharsets.UTF_8)).setAttributes((Map)ImmutableMap.builder().put((Object)"k", (Object)"v").build());
        PublishRequest expectedRequest = new PublishRequest().setMessages((List)ImmutableList.of((Object)expectedPubsubMessage));
        PublishResponse expectedResponse = new PublishResponse().setMessageIds((List)ImmutableList.of((Object)MESSAGE_ID));
        Mockito.when((Object)this.mockPubsub.projects().topics().publish(expectedTopic, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("k", "v");
        PubsubClient.OutgoingMessage actualMessage = PubsubClient.OutgoingMessage.of((com.google.pubsub.v1.PubsubMessage)com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)DATA)).putAllAttributes(attrs).build(), (long)6789L, (String)RECORD_ID);
        int n = this.client.publish(TOPIC, (List)ImmutableList.of((Object)actualMessage));
        Assert.assertEquals((long)1L, (long)n);
    }

    @Test
    public void listTopics() throws Exception {
        ListTopicsResponse expectedResponse1 = new ListTopicsResponse();
        expectedResponse1.setTopics(Collections.singletonList(PubsubJsonClientTest.buildTopic(1)));
        expectedResponse1.setNextPageToken("AVgJH3Z7aHxiDBs");
        ListTopicsResponse expectedResponse2 = new ListTopicsResponse();
        expectedResponse2.setTopics(Collections.singletonList(PubsubJsonClientTest.buildTopic(2)));
        Pubsub.Projects.Topics.List request = this.mockPubsub.projects().topics().list(PROJECT.getPath());
        Mockito.when((Object)request.execute()).thenReturn((Object)expectedResponse1, new Object[]{expectedResponse2});
        List topicPaths = this.client.listTopics(PROJECT);
        Assert.assertEquals((long)2L, (long)topicPaths.size());
    }

    private static Topic buildTopic(int i) {
        Topic topic = new Topic();
        topic.setName(PubsubClient.topicPathFromName((String)PROJECT.getId(), (String)("Topic" + i)).getPath());
        return topic;
    }

    @Test
    public void listSubscriptions() throws Exception {
        ListSubscriptionsResponse expectedResponse1 = new ListSubscriptionsResponse();
        expectedResponse1.setSubscriptions(Collections.singletonList(PubsubJsonClientTest.buildSubscription(1)));
        expectedResponse1.setNextPageToken("AVgJH3Z7aHxiDBs");
        ListSubscriptionsResponse expectedResponse2 = new ListSubscriptionsResponse();
        expectedResponse2.setSubscriptions(Collections.singletonList(PubsubJsonClientTest.buildSubscription(2)));
        Pubsub.Projects.Subscriptions.List request = this.mockPubsub.projects().subscriptions().list(PROJECT.getPath());
        Mockito.when((Object)request.execute()).thenReturn((Object)expectedResponse1, new Object[]{expectedResponse2});
        PubsubClient.TopicPath topic101 = PubsubClient.topicPathFromName((String)"testProject", (String)"Topic2");
        List subscriptionPaths = this.client.listSubscriptions(PROJECT, topic101);
        Assert.assertEquals((long)1L, (long)subscriptionPaths.size());
    }

    private static Subscription buildSubscription(int i) {
        Subscription subscription = new Subscription();
        subscription.setName(PubsubClient.subscriptionPathFromName((String)PROJECT.getId(), (String)("Subscription" + i)).getPath());
        subscription.setTopic(PubsubClient.topicPathFromName((String)PROJECT.getId(), (String)("Topic" + i)).getPath());
        return subscription;
    }
}

