/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableRow;
import java.math.BigInteger;
import java.util.List;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.io.gcp.testing.BigqueryMatcher;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BigqueryClient.class})
public class BigqueryMatcherTest {
    private final String appName = "test-app";
    private final String projectId = "test-project";
    private final String query = "test-query";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    private BigqueryClient mockBigqueryClient;
    @Mock
    private PipelineResult mockResult;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(BigqueryClient.class, (Class[])new Class[0]);
        Mockito.when((Object)BigqueryClient.getClient((String)Matchers.anyString())).thenReturn((Object)this.mockBigqueryClient);
    }

    @Test
    public void testBigqueryMatcherThatSucceeds() throws Exception {
        BigqueryMatcher matcher = (BigqueryMatcher)Mockito.spy((Object)new BigqueryMatcher("test-app", "test-project", "test-query", "9bb47f5c90d2a99cad526453dff5ed5ec74650dc"));
        Mockito.when((Object)this.mockBigqueryClient.queryWithRetries(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.createResponseContainingTestData());
        MatcherAssert.assertThat((Object)this.mockResult, (Matcher)matcher);
    }

    @Test
    public void testBigqueryMatcherFailsForChecksumMismatch() throws Exception {
        BigqueryMatcher matcher = (BigqueryMatcher)Mockito.spy((Object)new BigqueryMatcher("test-app", "test-project", "test-query", "incorrect-checksum"));
        Mockito.when((Object)this.mockBigqueryClient.queryWithRetries(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.createResponseContainingTestData());
        this.thrown.expect(AssertionError.class);
        this.thrown.expectMessage("Total number of rows are: 1");
        this.thrown.expectMessage("abc");
        MatcherAssert.assertThat((Object)this.mockResult, (Matcher)matcher);
    }

    @Test
    public void testBigqueryMatcherFailsWhenQueryJobNotComplete() throws Exception {
        BigqueryMatcher matcher = (BigqueryMatcher)Mockito.spy((Object)new BigqueryMatcher("test-app", "test-project", "test-query", "some-checksum"));
        Mockito.when((Object)this.mockBigqueryClient.queryWithRetries(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)new QueryResponse().setJobComplete(Boolean.valueOf(false)));
        this.thrown.expect(AssertionError.class);
        this.thrown.expectMessage("The query job hasn't completed.");
        this.thrown.expectMessage("jobComplete=false");
        MatcherAssert.assertThat((Object)this.mockResult, (Matcher)matcher);
    }

    private QueryResponse createResponseContainingTestData() {
        TableCell field1 = new TableCell();
        field1.setV((Object)"abc");
        TableCell field2 = new TableCell();
        field2.setV((Object)"2");
        TableCell field3 = new TableCell();
        field3.setV((Object)"testing BigQuery matcher.");
        TableRow row = new TableRow();
        row.setF((List)Lists.newArrayList((Object[])new TableCell[]{field1, field2, field3}));
        QueryResponse response = new QueryResponse();
        response.setJobComplete(Boolean.valueOf(true));
        response.setRows((List)Lists.newArrayList((Object[])new TableRow[]{row}));
        response.setTotalRows(BigInteger.ONE);
        return response;
    }
}

