/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.FileChecksumMatcher;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.testing.UsesKms;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
@Category(value={UsesKms.class})
public class GcsKmsKeyIT {
    private static final String INPUT_FILE = "gs://dataflow-samples/shakespeare/kinglear.txt";
    private static final String EXPECTED_CHECKSUM = "b9778bfac7fa8b934e42a322ef4bd4706b538fd0";

    @Test
    public void testGcsWriteWithKmsKey() {
        TestPipelineOptions options = (TestPipelineOptions)TestPipeline.testingPipelineOptions().as(TestPipelineOptions.class);
        Assert.assertNotNull((Object)options.getTempRoot());
        options.setTempLocation(options.getTempRoot() + "/testGcsWriteWithKmsKey");
        GcsOptions gcsOptions = (GcsOptions)options.as(GcsOptions.class);
        ResourceId filenamePrefix = FileSystems.matchNewResource((String)gcsOptions.getGcpTempLocation(), (boolean)true).resolve(String.format("GcsKmsKeyIT-%tF-%<tH-%<tM-%<tS-%<tL.output", new Date()), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)p.apply("ReadLines", (PTransform)TextIO.read().from(INPUT_FILE))).apply("WriteLines", (PTransform)TextIO.write().to(filenamePrefix));
        PipelineResult result = p.run();
        PipelineResult.State state = result.waitUntilFinish();
        MatcherAssert.assertThat((Object)state, (Matcher)CoreMatchers.equalTo((Object)PipelineResult.State.DONE));
        String filePattern = filenamePrefix + "*-of-*";
        MatcherAssert.assertThat((Object)result, (Matcher)new FileChecksumMatcher(EXPECTED_CHECKSUM, filePattern));
        try {
            MatchResult matchResult = (MatchResult)Iterables.getOnlyElement((Iterable)FileSystems.match(Collections.singletonList(filePattern)));
            GcsUtil gcsUtil = gcsOptions.getGcsUtil();
            for (MatchResult.Metadata metadata : matchResult.metadata()) {
                String kmsKey = gcsUtil.getObject(GcsPath.fromUri((String)metadata.resourceId().toString())).getKmsKeyName();
                Assert.assertNotNull((Object)kmsKey);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

