/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.FakeBatchTransactionId;
import com.google.cloud.spanner.FakePartitionFactory;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.gcp.spanner.BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.FakeServiceFactory;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SpannerIOReadTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);
    @Rule
    public final transient ExpectedException thrown = ExpectedException.none();
    private FakeServiceFactory serviceFactory;
    private BatchReadOnlyTransaction mockBatchTx;
    private static final Type FAKE_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"id", (Type)Type.int64()), Type.StructField.of((String)"name", (Type)Type.string())});
    private static final List<Struct> FAKE_ROWS = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)1L))).set("name").to("Alice")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)2L))).set("name").to("Bob")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)3L))).set("name").to("Carl")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)4L))).set("name").to("Dan")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)5L))).set("name").to("Evan")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)6L))).set("name").to("Floyd")).build());

    @Before
    public void setUp() throws Exception {
        this.serviceFactory = new FakeServiceFactory();
        this.mockBatchTx = (BatchReadOnlyTransaction)Mockito.mock(BatchReadOnlyTransaction.class);
    }

    @Test
    public void runQuery() throws Exception {
        SpannerIO.Read read = SpannerIO.read().withProjectId("test").withInstanceId("123").withDatabaseId("aaa").withQuery("SELECT * FROM users").withServiceFactory((ServiceFactory)this.serviceFactory);
        List<Partition> fakePartitions = Arrays.asList((Partition)Mockito.mock(Partition.class), (Partition)Mockito.mock(Partition.class), (Partition)Mockito.mock(Partition.class));
        BatchTransactionId id = (BatchTransactionId)Mockito.mock(BatchTransactionId.class);
        Transaction tx = Transaction.create((BatchTransactionId)id);
        PCollectionView txView = (PCollectionView)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)tx, (Object[])new Transaction[0]))).apply((PTransform)View.asSingleton());
        BatchSpannerRead.GeneratePartitionsFn fn = new BatchSpannerRead.GeneratePartitionsFn(read.getSpannerConfig(), txView);
        DoFnTester fnTester = DoFnTester.of((DoFn)fn);
        fnTester.setSideInput(txView, (BoundedWindow)GlobalWindow.INSTANCE, (Object)tx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(id)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.any(Statement.class), new Options.QueryOption[0])).thenReturn(fakePartitions);
        List result = fnTester.processBundle((Object[])new ReadOperation[]{read.getReadOperation()});
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])fakePartitions.toArray()));
        ((BatchClient)Mockito.verify((Object)this.serviceFactory.mockBatchClient())).batchReadOnlyTransaction(id);
        ((BatchReadOnlyTransaction)Mockito.verify((Object)this.mockBatchTx)).partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)"SELECT * FROM users")), new Options.QueryOption[0]);
    }

    @Test
    public void runRead() throws Exception {
        SpannerIO.Read read = SpannerIO.read().withProjectId("test").withInstanceId("123").withDatabaseId("aaa").withTable("users").withColumns(new String[]{"id", "name"}).withServiceFactory((ServiceFactory)this.serviceFactory);
        List<Partition> fakePartitions = Arrays.asList((Partition)Mockito.mock(Partition.class), (Partition)Mockito.mock(Partition.class), (Partition)Mockito.mock(Partition.class));
        BatchTransactionId id = (BatchTransactionId)Mockito.mock(BatchTransactionId.class);
        Transaction tx = Transaction.create((BatchTransactionId)id);
        PCollectionView txView = (PCollectionView)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)tx, (Object[])new Transaction[0]))).apply((PTransform)View.asSingleton());
        BatchSpannerRead.GeneratePartitionsFn fn = new BatchSpannerRead.GeneratePartitionsFn(read.getSpannerConfig(), txView);
        DoFnTester fnTester = DoFnTester.of((DoFn)fn);
        fnTester.setSideInput(txView, (BoundedWindow)GlobalWindow.INSTANCE, (Object)tx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(id)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[0])).thenReturn(fakePartitions);
        List result = fnTester.processBundle((Object[])new ReadOperation[]{read.getReadOperation()});
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])fakePartitions.toArray()));
        ((BatchClient)Mockito.verify((Object)this.serviceFactory.mockBatchClient())).batchReadOnlyTransaction(id);
        ((BatchReadOnlyTransaction)Mockito.verify((Object)this.mockBatchTx)).partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[0]);
    }

    @Test
    public void runReadUsingIndex() throws Exception {
        SpannerIO.Read read = SpannerIO.read().withProjectId("test").withInstanceId("123").withDatabaseId("aaa").withTimestamp(Timestamp.now()).withTable("users").withColumns(new String[]{"id", "name"}).withIndex("theindex").withServiceFactory((ServiceFactory)this.serviceFactory);
        List<Partition> fakePartitions = Arrays.asList((Partition)Mockito.mock(Partition.class), (Partition)Mockito.mock(Partition.class), (Partition)Mockito.mock(Partition.class));
        FakeBatchTransactionId id = new FakeBatchTransactionId("one");
        Transaction tx = Transaction.create((BatchTransactionId)id);
        PCollectionView txView = (PCollectionView)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)tx, (Object[])new Transaction[0]))).apply((PTransform)View.asSingleton());
        BatchSpannerRead.GeneratePartitionsFn fn = new BatchSpannerRead.GeneratePartitionsFn(read.getSpannerConfig(), txView);
        DoFnTester fnTester = DoFnTester.of((DoFn)fn);
        fnTester.setSideInput(txView, (BoundedWindow)GlobalWindow.INSTANCE, (Object)tx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)id)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.mockBatchTx.partitionReadUsingIndex((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (String)Matchers.eq((Object)"theindex"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[0])).thenReturn(fakePartitions);
        List result = fnTester.processBundle((Object[])new ReadOperation[]{read.getReadOperation()});
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])fakePartitions.toArray()));
        ((BatchClient)Mockito.verify((Object)this.serviceFactory.mockBatchClient())).batchReadOnlyTransaction((BatchTransactionId)id);
        ((BatchReadOnlyTransaction)Mockito.verify((Object)this.mockBatchTx)).partitionReadUsingIndex((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (String)Matchers.eq((Object)"theindex"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[0]);
    }

    @Test
    public void readPipeline() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = SpannerConfig.create().withProjectId("test").withInstanceId("123").withDatabaseId("aaa").withServiceFactory((ServiceFactory)this.serviceFactory);
        PCollection one = (PCollection)this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withQuery("SELECT * FROM users").withTimestampBound(timestampBound));
        FakeBatchTransactionId txId = new FakeBatchTransactionId("readPipelineTest");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)txId);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeQueryPartition(ByteString.copyFromUtf8((String)"one"));
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)"SELECT * FROM users")), new Options.QueryOption[0])).thenReturn(Arrays.asList(fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
    }

    @Test
    public void readAllPipeline() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = SpannerConfig.create().withProjectId("test").withInstanceId("123").withDatabaseId("aaa").withServiceFactory((ServiceFactory)this.serviceFactory);
        PCollectionView tx = (PCollectionView)this.pipeline.apply("tx", (PTransform)SpannerIO.createTransaction().withSpannerConfig(spannerConfig).withTimestampBound(timestampBound));
        PCollection reads = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)ReadOperation.create().withQuery("SELECT * FROM users"), (Object[])new ReadOperation[]{ReadOperation.create().withTable("users").withColumns(new String[]{"id", "name"})}));
        PCollection one = (PCollection)reads.apply("read all", (PTransform)SpannerIO.readAll().withSpannerConfig(spannerConfig).withTransaction(tx));
        FakeBatchTransactionId txId = new FakeBatchTransactionId("tx");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)txId);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeReadPartition(ByteString.copyFromUtf8((String)"partition"));
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)"SELECT * FROM users")), new Options.QueryOption[0])).thenReturn(Arrays.asList(fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[0])).thenReturn(Arrays.asList(fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
    }
}

