/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.gcp.spanner.FakeServiceFactory;
import org.apache.beam.sdk.io.gcp.spanner.ReadSpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ReadSpannerSchemaTest {
    @Rule
    public final transient ExpectedException thrown = ExpectedException.none();
    private FakeServiceFactory serviceFactory;
    private ReadOnlyTransaction mockTx;

    private static Struct columnMetadata(String tableName, String columnName, String type) {
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("table_name").to(tableName)).set("column_name").to(columnName)).set("spanner_type").to(type)).set("cells_mutated").to(3L)).build();
    }

    private static Struct pkMetadata(String tableName, String columnName, String ordering) {
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("table_name").to(tableName)).set("column_name").to(columnName)).set("column_ordering").to(ordering)).build();
    }

    private void prepareColumnMetadata(ReadOnlyTransaction tx, List<Struct> rows) {
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"table_name", (Type)Type.string()), Type.StructField.of((String)"column_name", (Type)Type.string()), Type.StructField.of((String)"spanner_type", (Type)Type.string()), Type.StructField.of((String)"cells_mutated", (Type)Type.int64())});
        Mockito.when((Object)tx.executeQuery((Statement)org.mockito.Matchers.argThat((Matcher)new ArgumentMatcher<Statement>(){

            public boolean matches(Object argument) {
                if (!(argument instanceof Statement)) {
                    return false;
                }
                Statement st = (Statement)argument;
                return st.getSql().contains("information_schema.columns");
            }
        }), new Options.QueryOption[0])).thenReturn((Object)ResultSets.forRows((Type)type, rows));
    }

    private void preparePkMetadata(ReadOnlyTransaction tx, List<Struct> rows) {
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"table_name", (Type)Type.string()), Type.StructField.of((String)"column_name", (Type)Type.string()), Type.StructField.of((String)"column_ordering", (Type)Type.string())});
        Mockito.when((Object)tx.executeQuery((Statement)org.mockito.Matchers.argThat((Matcher)new ArgumentMatcher<Statement>(){

            public boolean matches(Object argument) {
                if (!(argument instanceof Statement)) {
                    return false;
                }
                Statement st = (Statement)argument;
                return st.getSql().contains("information_schema.index_columns");
            }
        }), new Options.QueryOption[0])).thenReturn((Object)ResultSets.forRows((Type)type, rows));
    }

    @Before
    public void setUp() throws Exception {
        this.serviceFactory = new FakeServiceFactory();
        this.mockTx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
    }

    @Test
    public void simple() throws Exception {
        ReadOnlyTransaction tx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().readOnlyTransaction()).thenReturn((Object)tx);
        this.preparePkMetadata(tx, Arrays.asList(ReadSpannerSchemaTest.pkMetadata("test", "key", "ASC")));
        this.prepareColumnMetadata(tx, Arrays.asList(ReadSpannerSchemaTest.columnMetadata("test", "key", "INT64")));
        SpannerConfig config = SpannerConfig.create().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory);
        DoFnTester tester = DoFnTester.of((DoFn)new ReadSpannerSchema(config));
        List schemas = tester.processBundle(Arrays.asList(new Void[]{null}));
        Assert.assertEquals((long)1L, (long)schemas.size());
        SpannerSchema schema = (SpannerSchema)schemas.get(0);
        Assert.assertEquals((long)1L, (long)schema.getTables().size());
        SpannerSchema.Column column = SpannerSchema.Column.create((String)"key", (Type)Type.int64());
        SpannerSchema.KeyPart keyPart = SpannerSchema.KeyPart.create((String)"key", (boolean)false);
        Assert.assertThat((Object)schema.getColumns("test"), (Matcher)Matchers.contains((Object[])new SpannerSchema.Column[]{column}));
        Assert.assertThat((Object)schema.getKeyParts("test"), (Matcher)Matchers.contains((Object[])new SpannerSchema.KeyPart[]{keyPart}));
    }
}

