/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import java.util.UUID;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreIO;
import org.apache.beam.sdk.io.gcp.datastore.V1TestOptions;
import org.apache.beam.sdk.io.gcp.datastore.V1TestUtil;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class V1WriteIT {
    private V1TestOptions options;
    private String project;
    private String ancestor;
    private final long numEntities = 1000L;

    @Before
    public void setup() {
        PipelineOptionsFactory.register(V1TestOptions.class);
        this.options = (V1TestOptions)TestPipeline.testingPipelineOptions().as(V1TestOptions.class);
        this.project = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
        this.ancestor = UUID.randomUUID().toString();
    }

    @Test
    public void testE2EV1Write() throws Exception {
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        ((PCollection)((PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).to(1000L))).apply((PTransform)ParDo.of((DoFn)new V1TestUtil.CreateEntityFn(this.options.getKind(), this.options.getNamespace(), this.ancestor, 0)))).apply((PTransform)DatastoreIO.v1().write().withProjectId(this.project));
        p.run();
        long numEntitiesWritten = V1TestUtil.countEntities(this.options, this.project, this.ancestor);
        Assert.assertEquals((long)1000L, (long)numEntitiesWritten);
    }

    @Test
    public void testE2EV1WriteWithLargeEntities() throws Exception {
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        int rawPropertySize = 900000;
        int numLargeEntities = 100;
        ((PCollection)((PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).to(100L))).apply((PTransform)ParDo.of((DoFn)new V1TestUtil.CreateEntityFn(this.options.getKind(), this.options.getNamespace(), this.ancestor, 900000)))).apply((PTransform)DatastoreIO.v1().write().withProjectId(this.project));
        p.run();
        long numEntitiesWritten = V1TestUtil.countEntities(this.options, this.project, this.ancestor);
        Assert.assertEquals((long)100L, (long)numEntitiesWritten);
    }

    @After
    public void tearDown() throws Exception {
        V1TestUtil.deleteAllEntities(this.options, this.project, this.ancestor);
    }
}

