/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.Entity;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.PropertyFilter;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.datastore.v1.client.DatastoreOptions;
import com.google.protobuf.Int32Value;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.io.gcp.datastore.V1TestOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class V1TestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(V1TestUtil.class);

    V1TestUtil() {
    }

    static Key makeAncestorKey(@Nullable String namespace, String kind, String ancestor) {
        Key.Builder keyBuilder = DatastoreHelper.makeKey((Object[])new Object[]{kind, ancestor});
        if (namespace != null) {
            keyBuilder.getPartitionIdBuilder().setNamespaceId(namespace);
        }
        return keyBuilder.build();
    }

    static Query makeAncestorKindQuery(String kind, @Nullable String namespace, String ancestor) {
        Query.Builder q = Query.newBuilder();
        q.addKindBuilder().setName(kind);
        q.setFilter(DatastoreHelper.makeFilter((String)"__key__", (PropertyFilter.Operator)PropertyFilter.Operator.HAS_ANCESTOR, (Value.Builder)DatastoreHelper.makeValue((Key)V1TestUtil.makeAncestorKey(namespace, kind, ancestor))));
        return q.build();
    }

    static Entity makeEntity(Long value, Key ancestorKey, String kind, @Nullable String namespace, int largePropertySize) {
        Entity.Builder entityBuilder = Entity.newBuilder();
        Key.Builder keyBuilder = DatastoreHelper.makeKey((Object[])new Object[]{ancestorKey, kind, UUID.randomUUID().toString()});
        if (namespace != null) {
            keyBuilder.getPartitionIdBuilder().setNamespaceId(namespace);
        }
        entityBuilder.setKey(keyBuilder.build());
        entityBuilder.putProperties("value", DatastoreHelper.makeValue((long)value).build());
        if (largePropertySize > 0) {
            entityBuilder.putProperties("unindexed_value", DatastoreHelper.makeValue((String)new String(new char[largePropertySize]).replace("\u0000", "A")).setExcludeFromIndexes(true).build());
        }
        return entityBuilder.build();
    }

    static Datastore getDatastore(PipelineOptions pipelineOptions, String projectId) {
        Credentials credential = ((GcpOptions)pipelineOptions.as(GcpOptions.class)).getGcpCredential();
        Object initializer = credential != null ? new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), new RetryHttpRequestInitializer()}) : new RetryHttpRequestInitializer();
        DatastoreOptions.Builder builder = new DatastoreOptions.Builder().projectId(projectId).initializer((HttpRequestInitializer)initializer);
        return DatastoreFactory.get().create(builder.build());
    }

    private static RunQueryRequest makeRequest(Query query, @Nullable String namespace) {
        RunQueryRequest.Builder requestBuilder = RunQueryRequest.newBuilder().setQuery(query);
        if (namespace != null) {
            requestBuilder.getPartitionIdBuilder().setNamespaceId(namespace);
        }
        return requestBuilder.build();
    }

    static void deleteAllEntities(V1TestOptions options, String project, String ancestor) throws Exception {
        Datastore datastore = V1TestUtil.getDatastore((PipelineOptions)options, project);
        Query query = V1TestUtil.makeAncestorKindQuery(options.getKind(), options.getNamespace(), ancestor);
        V1TestReader reader = new V1TestReader(datastore, query, options.getNamespace());
        V1TestWriter writer = new V1TestWriter(datastore, new DeleteMutationBuilder());
        long numEntities = 0L;
        while (reader.advance()) {
            Entity entity = reader.getCurrent();
            ++numEntities;
            writer.write(entity);
        }
        writer.close();
        LOG.info("Successfully deleted {} entities", (Object)numEntities);
    }

    static long countEntities(V1TestOptions options, String project, String ancestor) throws Exception {
        Datastore datastore = V1TestUtil.getDatastore((PipelineOptions)options, project);
        Query query = V1TestUtil.makeAncestorKindQuery(options.getKind(), options.getNamespace(), ancestor);
        V1TestReader reader = new V1TestReader(datastore, query, options.getNamespace());
        long numEntitiesRead = 0L;
        while (reader.advance()) {
            reader.getCurrent();
            ++numEntitiesRead;
        }
        return numEntitiesRead;
    }

    static class V1TestReader {
        private static final int QUERY_BATCH_LIMIT = 500;
        private final Datastore datastore;
        private final Query query;
        @Nullable
        private final String namespace;
        private boolean moreResults;
        private Iterator<EntityResult> entities;
        private QueryResultBatch currentBatch;
        private Entity currentEntity;

        V1TestReader(Datastore datastore, Query query, @Nullable String namespace) {
            this.datastore = datastore;
            this.query = query;
            this.namespace = namespace;
        }

        Entity getCurrent() {
            return this.currentEntity;
        }

        boolean advance() throws IOException {
            if (this.entities == null || !this.entities.hasNext() && this.moreResults) {
                try {
                    this.entities = this.getIteratorAndMoveCursor();
                }
                catch (DatastoreException e) {
                    throw new IOException(e);
                }
            }
            if (this.entities == null || !this.entities.hasNext()) {
                this.currentEntity = null;
                return false;
            }
            this.currentEntity = this.entities.next().getEntity();
            return true;
        }

        private Iterator<EntityResult> getIteratorAndMoveCursor() throws DatastoreException {
            Query.Builder query = this.query.toBuilder();
            query.setLimit(Int32Value.newBuilder().setValue(500));
            if (this.currentBatch != null && !this.currentBatch.getEndCursor().isEmpty()) {
                query.setStartCursor(this.currentBatch.getEndCursor());
            }
            RunQueryRequest request = V1TestUtil.makeRequest(query.build(), this.namespace);
            RunQueryResponse response = this.datastore.runQuery(request);
            this.currentBatch = response.getBatch();
            int numFetch = this.currentBatch.getEntityResultsCount();
            boolean bl = this.moreResults = numFetch == 500 || this.currentBatch.getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED;
            if (numFetch == 0) {
                return null;
            }
            return this.currentBatch.getEntityResultsList().iterator();
        }
    }

    static class V1TestWriter {
        private static final Logger LOG = LoggerFactory.getLogger(V1TestWriter.class);
        private static final int DATASTORE_BATCH_UPDATE_LIMIT = 500;
        private static final int MAX_RETRIES = 5;
        private static final Duration INITIAL_BACKOFF = Duration.standardSeconds((long)5L);
        private final Datastore datastore;
        private final MutationBuilder mutationBuilder;
        private final List<Entity> entities = new ArrayList<Entity>();

        static boolean isValidKey(Key key) {
            List elementList = key.getPathList();
            if (elementList.isEmpty()) {
                return false;
            }
            Key.PathElement lastElement = (Key.PathElement)elementList.get(elementList.size() - 1);
            return lastElement.getId() != 0L || !lastElement.getName().isEmpty();
        }

        V1TestWriter(Datastore datastore, MutationBuilder mutationBuilder) {
            this.datastore = datastore;
            this.mutationBuilder = mutationBuilder;
        }

        void write(Entity value) throws Exception {
            if (!V1TestWriter.isValidKey(value.getKey())) {
                throw new IllegalArgumentException("Entities to be written to the Datastore must have complete keys");
            }
            this.entities.add(value);
            if (this.entities.size() >= 500) {
                this.flushBatch();
            }
        }

        void close() throws Exception {
            if (this.entities.size() > 0) {
                this.flushBatch();
            }
        }

        private void flushBatch() throws DatastoreException, IOException, InterruptedException {
            LOG.info("Writing batch of {} entities", (Object)this.entities.size());
            Sleeper sleeper = Sleeper.DEFAULT;
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(5).withInitialBackoff(INITIAL_BACKOFF).backoff();
            while (true) {
                try {
                    CommitRequest.Builder commitRequest = CommitRequest.newBuilder();
                    for (Entity entity : this.entities) {
                        commitRequest.addMutations(this.mutationBuilder.apply(entity));
                    }
                    commitRequest.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
                    this.datastore.commit(commitRequest.build());
                }
                catch (DatastoreException exception) {
                    LOG.error("Error writing to the Datastore ({}): {}", (Object)exception.getCode(), (Object)exception.getMessage());
                    if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) continue;
                    LOG.error("Aborting after {} retries.", (Object)5);
                    throw exception;
                }
                break;
            }
            LOG.info("Successfully wrote {} entities", (Object)this.entities.size());
            this.entities.clear();
        }
    }

    static class DeleteMutationBuilder
    implements MutationBuilder {
        DeleteMutationBuilder() {
        }

        @Override
        public Mutation.Builder apply(Entity entity) {
            return DatastoreHelper.makeDelete((Key)entity.getKey());
        }
    }

    static class UpsertMutationBuilder
    implements MutationBuilder {
        UpsertMutationBuilder() {
        }

        @Override
        public Mutation.Builder apply(Entity entity) {
            return DatastoreHelper.makeUpsert((Entity)entity);
        }
    }

    static interface MutationBuilder {
        public Mutation.Builder apply(Entity var1);
    }

    static class CreateEntityFn
    extends DoFn<Long, Entity> {
        private final String kind;
        @Nullable
        private final String namespace;
        private final int largePropertySize;
        private Key ancestorKey;

        CreateEntityFn(String kind, @Nullable String namespace, String ancestor, int largePropertySize) {
            this.kind = kind;
            this.namespace = namespace;
            this.largePropertySize = largePropertySize;
            this.ancestorKey = V1TestUtil.makeAncestorKey(namespace, kind, ancestor);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            c.output((Object)V1TestUtil.makeEntity((Long)c.element(), this.ancestorKey, this.kind, this.namespace, this.largePropertySize));
        }
    }
}

