/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auth.Credentials;
import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.BulkOptions;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.extensions.gcp.auth.TestCredential;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.protobuf.ByteStringCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteResult;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigtableIOTest {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public ExpectedLogs logged = ExpectedLogs.none(BigtableIO.class);
    static final ValueProvider<String> NOT_ACCESSIBLE_VALUE = new ValueProvider<String>(){

        public String get() {
            throw new IllegalStateException("Value is not accessible");
        }

        public boolean isAccessible() {
            return false;
        }
    };
    private static BigtableConfig config;
    private static FakeBigtableService service;
    private static final BigtableOptions BIGTABLE_OPTIONS;
    private static BigtableIO.Read defaultRead;
    private static BigtableIO.Write defaultWrite;
    private Coder<KV<ByteString, Iterable<Mutation>>> bigtableCoder;
    private static final TypeDescriptor<KV<ByteString, Iterable<Mutation>>> BIGTABLE_WRITE_TYPE;
    private static final SerializableFunction<BigtableOptions.Builder, BigtableOptions.Builder> PORT_CONFIGURATOR;
    private static final String COLUMN_FAMILY_NAME = "family";
    private static final ByteString COLUMN_NAME;
    private static final Column TEST_COLUMN;
    private static final Family TEST_FAMILY;

    @Before
    public void setup() throws Exception {
        service = new FakeBigtableService();
        defaultRead = defaultRead.withBigtableService((BigtableService)service);
        defaultWrite = defaultWrite.withBigtableService((BigtableService)service);
        this.bigtableCoder = this.p.getCoderRegistry().getCoder(BIGTABLE_WRITE_TYPE);
        config = BigtableConfig.builder().setValidate(true).setBigtableService((BigtableService)service).build();
    }

    private static ByteKey makeByteKey(ByteString key) {
        return ByteKey.copyFrom((ByteBuffer)key.asReadOnlyByteBuffer());
    }

    @Test
    public void testReadBuildsCorrectly() {
        BigtableIO.Read read = BigtableIO.read().withBigtableOptions(BIGTABLE_OPTIONS).withTableId("table").withInstanceId("instance").withProjectId("project").withBigtableOptionsConfigurator(PORT_CONFIGURATOR);
        Assert.assertEquals((Object)"options_project", (Object)read.getBigtableOptions().getProjectId());
        Assert.assertEquals((Object)"options_instance", (Object)read.getBigtableOptions().getInstanceId());
        Assert.assertEquals((Object)"instance", (Object)read.getBigtableConfig().getInstanceId().get());
        Assert.assertEquals((Object)"project", (Object)read.getBigtableConfig().getProjectId().get());
        Assert.assertEquals((Object)"table", (Object)read.getTableId());
        Assert.assertEquals(PORT_CONFIGURATOR, (Object)read.getBigtableConfig().getBigtableOptionsConfigurator());
    }

    @Test
    public void testReadValidationFailsMissingTable() {
        BigtableIO.Read read = BigtableIO.read().withBigtableOptions(BIGTABLE_OPTIONS);
        this.thrown.expect(IllegalArgumentException.class);
        read.expand(null);
    }

    @Test
    public void testReadValidationFailsMissingInstanceId() {
        BigtableIO.Read read = BigtableIO.read().withTableId("table").withProjectId("project").withBigtableOptions(new BigtableOptions.Builder().build());
        this.thrown.expect(IllegalArgumentException.class);
        read.expand(null);
    }

    @Test
    public void testReadValidationFailsMissingProjectId() {
        BigtableIO.Read read = BigtableIO.read().withTableId("table").withInstanceId("instance").withBigtableOptions(new BigtableOptions.Builder().build());
        this.thrown.expect(IllegalArgumentException.class);
        read.expand(null);
    }

    @Test
    public void testReadValidationFailsMissingInstanceIdAndProjectId() {
        BigtableIO.Read read = BigtableIO.read().withTableId("table").withBigtableOptions(new BigtableOptions.Builder().build());
        this.thrown.expect(IllegalArgumentException.class);
        read.expand(null);
    }

    @Test
    public void testReadWithRuntimeParametersValidationFailed() {
        ReadOptions options = (ReadOptions)PipelineOptionsFactory.fromArgs((String[])new String[0]).withValidation().as(ReadOptions.class);
        BigtableIO.Read read = BigtableIO.read().withProjectId(options.getBigtableProject()).withInstanceId(options.getBigtableInstanceId()).withTableId(options.getBigtableTableId());
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("tableId was not supplied");
        this.p.apply((PTransform)read);
    }

    @Test
    public void testReadWithRuntimeParametersValidationDisabled() {
        ReadOptions options = (ReadOptions)PipelineOptionsFactory.fromArgs((String[])new String[0]).withValidation().as(ReadOptions.class);
        BigtableIO.Read read = BigtableIO.read().withoutValidation().withProjectId(options.getBigtableProject()).withInstanceId(options.getBigtableInstanceId()).withTableId(options.getBigtableTableId());
        this.thrown.expect(TestPipeline.PipelineRunMissingException.class);
        this.p.apply((PTransform)read);
    }

    @Test
    public void testWriteBuildsCorrectly() {
        BigtableIO.Write write = BigtableIO.write().withBigtableOptions(BIGTABLE_OPTIONS).withTableId("table").withInstanceId("instance").withProjectId("project");
        Assert.assertEquals((Object)"table", (Object)write.getBigtableConfig().getTableId().get());
        Assert.assertEquals((Object)"options_project", (Object)write.getBigtableOptions().getProjectId());
        Assert.assertEquals((Object)"options_instance", (Object)write.getBigtableOptions().getInstanceId());
        Assert.assertEquals((Object)"instance", (Object)write.getBigtableConfig().getInstanceId().get());
        Assert.assertEquals((Object)"project", (Object)write.getBigtableConfig().getProjectId().get());
    }

    @Test
    public void testWriteValidationFailsMissingInstanceId() {
        BigtableIO.WriteWithResults write = BigtableIO.write().withTableId("table").withProjectId("project").withBigtableOptions(new BigtableOptions.Builder().build()).withWriteResults();
        this.thrown.expect(IllegalArgumentException.class);
        write.expand(null);
    }

    @Test
    public void testWriteValidationFailsMissingProjectId() {
        BigtableIO.WriteWithResults write = BigtableIO.write().withTableId("table").withInstanceId("instance").withBigtableOptions(new BigtableOptions.Builder().build()).withWriteResults();
        this.thrown.expect(IllegalArgumentException.class);
        write.expand(null);
    }

    @Test
    public void testWriteValidationFailsMissingInstanceIdAndProjectId() {
        BigtableIO.WriteWithResults write = BigtableIO.write().withTableId("table").withBigtableOptions(new BigtableOptions.Builder().build()).withWriteResults();
        this.thrown.expect(IllegalArgumentException.class);
        write.expand(null);
    }

    @Test
    public void testWriteValidationFailsMissingOptionsAndInstanceAndProject() {
        BigtableIO.WriteWithResults write = BigtableIO.write().withTableId("table").withWriteResults();
        this.thrown.expect(IllegalArgumentException.class);
        write.expand(null);
    }

    private static KV<ByteString, Iterable<Mutation>> makeWrite(String key, String value) {
        ByteString rowKey = ByteString.copyFromUtf8((String)key);
        ImmutableList mutations = ImmutableList.of((Object)Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setValue(ByteString.copyFromUtf8((String)value))).build());
        return KV.of((Object)rowKey, (Object)mutations);
    }

    private static KV<ByteString, Iterable<Mutation>> makeBadWrite(String key) {
        ImmutableList mutations = ImmutableList.of((Object)Mutation.newBuilder().build());
        return KV.of((Object)ByteString.copyFromUtf8((String)key), (Object)mutations);
    }

    @Test
    public void testUsePipelineOptionsCredentialsIfNotSpecifiedInBigtableOptions() throws Exception {
        BigtableOptions options = BIGTABLE_OPTIONS.toBuilder().setCredentialOptions(CredentialOptions.defaultCredentials()).build();
        GcpOptions pipelineOptions = (GcpOptions)PipelineOptionsFactory.as(GcpOptions.class);
        pipelineOptions.setGcpCredential((Credentials)new TestCredential());
        BigtableService readService = BigtableIO.read().withBigtableOptions(options).withTableId("TEST-TABLE").getBigtableConfig().getBigtableService((PipelineOptions)pipelineOptions);
        BigtableService writeService = BigtableIO.write().withBigtableOptions(options).withTableId("TEST-TABLE").getBigtableConfig().getBigtableService((PipelineOptions)pipelineOptions);
        Assert.assertEquals((Object)CredentialOptions.CredentialType.SuppliedCredentials, (Object)readService.getBigtableOptions().getCredentialOptions().getCredentialType());
        Assert.assertEquals((Object)CredentialOptions.CredentialType.SuppliedCredentials, (Object)writeService.getBigtableOptions().getCredentialOptions().getCredentialType());
    }

    @Test
    public void testDontUsePipelineOptionsCredentialsIfSpecifiedInBigtableOptions() throws Exception {
        BigtableOptions options = BIGTABLE_OPTIONS.toBuilder().setCredentialOptions(CredentialOptions.nullCredential()).build();
        GcpOptions pipelineOptions = (GcpOptions)PipelineOptionsFactory.as(GcpOptions.class);
        pipelineOptions.setGcpCredential((Credentials)new TestCredential());
        BigtableService readService = BigtableIO.read().withBigtableOptions(options).withTableId("TEST-TABLE").getBigtableConfig().getBigtableService((PipelineOptions)pipelineOptions);
        BigtableService writeService = BigtableIO.write().withBigtableOptions(options).withTableId("TEST-TABLE").getBigtableConfig().getBigtableService((PipelineOptions)pipelineOptions);
        Assert.assertEquals((Object)CredentialOptions.CredentialType.None, (Object)readService.getBigtableOptions().getCredentialOptions().getCredentialType());
        Assert.assertEquals((Object)CredentialOptions.CredentialType.None, (Object)writeService.getBigtableOptions().getCredentialOptions().getCredentialType());
    }

    @Test
    public void testReadingFailsTableDoesNotExist() throws Exception {
        String table = "TEST-TABLE";
        BigtableIO.Read read = BigtableIO.read().withBigtableOptions(BIGTABLE_OPTIONS).withTableId("TEST-TABLE").withBigtableService((BigtableService)service);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(String.format("Table %s does not exist", "TEST-TABLE"));
        this.p.apply((PTransform)read);
        this.p.run();
    }

    @Test
    public void testReadingEmptyTable() throws Exception {
        String table = "TEST-EMPTY-TABLE";
        service.createTable("TEST-EMPTY-TABLE");
        service.setupSampleRowKeys("TEST-EMPTY-TABLE", 1, 1L);
        this.runReadTest(defaultRead.withTableId("TEST-EMPTY-TABLE"), new ArrayList<Row>());
        this.logged.verifyInfo("Closing reader after reading 0 records.");
    }

    @Test
    public void testReading() throws Exception {
        String table = "TEST-MANY-ROWS-TABLE";
        int numRows = 1001;
        List<Row> testRows = BigtableIOTest.makeTableData("TEST-MANY-ROWS-TABLE", 1001);
        service.setupSampleRowKeys("TEST-MANY-ROWS-TABLE", 3, 1000L);
        this.runReadTest(defaultRead.withTableId("TEST-MANY-ROWS-TABLE"), testRows);
        this.logged.verifyInfo(String.format("Closing reader after reading %d records.", 333));
    }

    private static List<Row> filterToRange(List<Row> rows, ByteKeyRange range) {
        return BigtableIOTest.filterToRanges(rows, (List<ByteKeyRange>)ImmutableList.of((Object)range));
    }

    private static List<Row> filterToRanges(List<Row> rows, List<ByteKeyRange> ranges) {
        return Lists.newArrayList((Iterable)rows.stream().filter(input -> {
            Verify.verifyNotNull((Object)input, (String)"input", (Object[])new Object[0]);
            for (ByteKeyRange range : ranges) {
                if (!range.containsKey(BigtableIOTest.makeByteKey(input.getKey())).booleanValue()) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList()));
    }

    private void runReadTest(BigtableIO.Read read, List<Row> expected) {
        PCollection rows = (PCollection)this.p.apply(read.getTableId() + "_" + read.getKeyRanges(), (PTransform)read);
        PAssert.that((PCollection)rows).containsInAnyOrder(expected);
        this.p.run();
    }

    @Test
    public void testReadingWithKeyRange() throws Exception {
        String table = "TEST-KEY-RANGE-TABLE";
        int numRows = 1001;
        List<Row> testRows = BigtableIOTest.makeTableData("TEST-KEY-RANGE-TABLE", 1001);
        ByteKey startKey = ByteKey.copyFrom((byte[])"key000000100".getBytes(StandardCharsets.UTF_8));
        ByteKey endKey = ByteKey.copyFrom((byte[])"key000000300".getBytes(StandardCharsets.UTF_8));
        service.setupSampleRowKeys("TEST-KEY-RANGE-TABLE", 100, "key000000100".length());
        ByteKeyRange prefixRange = ByteKeyRange.ALL_KEYS.withEndKey(startKey);
        List<Row> prefixRows = BigtableIOTest.filterToRange(testRows, prefixRange);
        this.runReadTest(defaultRead.withTableId("TEST-KEY-RANGE-TABLE").withKeyRange(prefixRange), prefixRows);
        ByteKeyRange suffixRange = ByteKeyRange.ALL_KEYS.withStartKey(startKey);
        List<Row> suffixRows = BigtableIOTest.filterToRange(testRows, suffixRange);
        this.runReadTest(defaultRead.withTableId("TEST-KEY-RANGE-TABLE").withKeyRange(suffixRange), suffixRows);
        ByteKeyRange middleRange = ByteKeyRange.of((ByteKey)startKey, (ByteKey)endKey);
        List<Row> middleRows = BigtableIOTest.filterToRange(testRows, middleRange);
        this.runReadTest(defaultRead.withTableId("TEST-KEY-RANGE-TABLE").withKeyRange(middleRange), middleRows);
        Assert.assertThat(prefixRows, (Matcher)Matchers.allOf((Matcher)Matchers.hasSize((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(1001))), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))));
        Assert.assertThat(suffixRows, (Matcher)Matchers.allOf((Matcher)Matchers.hasSize((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(1001))), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))));
        Assert.assertThat(middleRows, (Matcher)Matchers.allOf((Matcher)Matchers.hasSize((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(1001))), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))));
        ArrayList union = Lists.newArrayList(prefixRows);
        union.addAll(suffixRows);
        Assert.assertThat((String)"prefix + suffix = total", (Object)union, (Matcher)Matchers.containsInAnyOrder((Object[])testRows.toArray(new Row[0])));
        Assert.assertThat(suffixRows, (Matcher)Matchers.hasItems((Object[])middleRows.toArray(new Row[0])));
    }

    @Test
    public void testReadingWithKeyRanges() throws Exception {
        String table = "TEST-KEY-RANGE-TABLE";
        int numRows = 11;
        List<Row> testRows = BigtableIOTest.makeTableData("TEST-KEY-RANGE-TABLE", 11);
        ByteKey startKey1 = ByteKey.copyFrom((byte[])"key000000001".getBytes(StandardCharsets.UTF_8));
        ByteKey endKey1 = ByteKey.copyFrom((byte[])"key000000003".getBytes(StandardCharsets.UTF_8));
        ByteKey startKey2 = ByteKey.copyFrom((byte[])"key000000004".getBytes(StandardCharsets.UTF_8));
        ByteKey endKey2 = ByteKey.copyFrom((byte[])"key000000007".getBytes(StandardCharsets.UTF_8));
        ByteKey startKey3 = ByteKey.copyFrom((byte[])"key000000008".getBytes(StandardCharsets.UTF_8));
        ByteKey endKey3 = ByteKey.copyFrom((byte[])"key000000009".getBytes(StandardCharsets.UTF_8));
        service.setupSampleRowKeys("TEST-KEY-RANGE-TABLE", 1, "key000000001".length());
        ByteKeyRange range1 = ByteKeyRange.of((ByteKey)startKey1, (ByteKey)endKey1);
        ByteKeyRange range2 = ByteKeyRange.of((ByteKey)startKey2, (ByteKey)endKey2);
        ByteKeyRange range3 = ByteKeyRange.of((ByteKey)startKey3, (ByteKey)endKey3);
        ImmutableList ranges = ImmutableList.of((Object)range1, (Object)range2, (Object)range3);
        List<Row> rangeRows = BigtableIOTest.filterToRanges(testRows, (List<ByteKeyRange>)ranges);
        this.runReadTest(defaultRead.withTableId("TEST-KEY-RANGE-TABLE").withKeyRanges((List)ranges), rangeRows);
        Assert.assertThat(rangeRows, (Matcher)Matchers.allOf((Matcher)Matchers.hasSize((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(11))), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))));
    }

    @Test
    public void testReadingWithFilter() throws Exception {
        String table = "TEST-FILTER-TABLE";
        int numRows = 1001;
        List<Row> testRows = BigtableIOTest.makeTableData("TEST-FILTER-TABLE", 1001);
        String regex = ".*17.*";
        KeyMatchesRegex keyPredicate = new KeyMatchesRegex(regex);
        Iterable filteredRows = testRows.stream().filter(input -> {
            Verify.verifyNotNull((Object)input, (String)"input", (Object[])new Object[0]);
            return keyPredicate.apply(input.getKey());
        }).collect(Collectors.toList());
        RowFilter filter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)regex)).build();
        service.setupSampleRowKeys("TEST-FILTER-TABLE", 5, 10L);
        this.runReadTest(defaultRead.withTableId("TEST-FILTER-TABLE").withRowFilter(filter), Lists.newArrayList((Iterable)filteredRows));
    }

    @Test
    public void testReadingSplitAtFractionExhaustive() throws Exception {
        String table = "TEST-FEW-ROWS-SPLIT-EXHAUSTIVE-TABLE";
        int numRows = 10;
        boolean numSamples = true;
        long bytesPerRow = 1L;
        BigtableIOTest.makeTableData("TEST-FEW-ROWS-SPLIT-EXHAUSTIVE-TABLE", 10);
        service.setupSampleRowKeys("TEST-FEW-ROWS-SPLIT-EXHAUSTIVE-TABLE", 1, 1L);
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-FEW-ROWS-SPLIT-EXHAUSTIVE-TABLE")), null, Arrays.asList(service.getTableRange("TEST-FEW-ROWS-SPLIT-EXHAUSTIVE-TABLE")), null);
        SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)source, null);
    }

    @Test
    public void testReadingSplitAtFraction() throws Exception {
        String table = "TEST-SPLIT-AT-FRACTION";
        int numRows = 10;
        boolean numSamples = true;
        long bytesPerRow = 1L;
        BigtableIOTest.makeTableData("TEST-SPLIT-AT-FRACTION", 10);
        service.setupSampleRowKeys("TEST-SPLIT-AT-FRACTION", 1, 1L);
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-SPLIT-AT-FRACTION")), null, Arrays.asList(service.getTableRange("TEST-SPLIT-AT-FRACTION")), null);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)0, (double)0.1, null);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)0, (double)1.0, null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)1, (double)0.333, null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)1, (double)0.666, null);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)3, (double)0.2, null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)3, (double)0.571, null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)3, (double)0.9, null);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)6, (double)0.5, null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)6, (double)0.7, null);
    }

    @Test
    public void testReadingWithSplits() throws Exception {
        String table = "TEST-MANY-ROWS-SPLITS-TABLE";
        int numRows = 1500;
        int numSamples = 10;
        long bytesPerRow = 100L;
        BigtableIOTest.makeTableData("TEST-MANY-ROWS-SPLITS-TABLE", 1500);
        service.setupSampleRowKeys("TEST-MANY-ROWS-SPLITS-TABLE", 10, 100L);
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-MANY-ROWS-SPLITS-TABLE")), null, Arrays.asList(ByteKeyRange.ALL_KEYS), null);
        List splits = source.split(15000L, null);
        Assert.assertThat((Object)splits, (Matcher)Matchers.hasSize((int)10));
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, null);
    }

    private void assertAllSourcesHaveSingleAdjacentRanges(List<BigtableIO.BigtableSource> sources) {
        if (sources.size() > 0) {
            Assert.assertThat((Object)sources.get(0).getRanges(), (Matcher)Matchers.hasSize((int)1));
            for (int i = 1; i < sources.size(); ++i) {
                Assert.assertThat((Object)sources.get(i).getRanges(), (Matcher)Matchers.hasSize((int)1));
                ByteKey lastEndKey = ((ByteKeyRange)sources.get(i - 1).getRanges().get(0)).getEndKey();
                ByteKey currentStartKey = ((ByteKeyRange)sources.get(i).getRanges().get(0)).getStartKey();
                Assert.assertEquals((Object)lastEndKey, (Object)currentStartKey);
            }
        }
    }

    private void assertAllSourcesHaveSingleRanges(List<BigtableIO.BigtableSource> sources) {
        for (BigtableIO.BigtableSource source : sources) {
            Assert.assertThat((Object)source.getRanges(), (Matcher)Matchers.hasSize((int)1));
        }
    }

    private ByteKey createByteKey(int key) {
        return ByteKey.copyFrom((byte[])String.format("key%09d", key).getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void testReduceSplitsWithSomeNonAdjacentRanges() throws Exception {
        String table = "TEST-MANY-ROWS-SPLITS-TABLE";
        int numRows = 10;
        int numSamples = 10;
        long bytesPerRow = 100L;
        int maxSplit = 3;
        BigtableIOTest.makeTableData("TEST-MANY-ROWS-SPLITS-TABLE", 10);
        service.setupSampleRowKeys("TEST-MANY-ROWS-SPLITS-TABLE", 10, 100L);
        List<ByteKeyRange> keyRanges = Arrays.asList(ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)this.createByteKey(1)), ByteKeyRange.of((ByteKey)this.createByteKey(1), (ByteKey)this.createByteKey(2)), ByteKeyRange.of((ByteKey)this.createByteKey(3), (ByteKey)this.createByteKey(4)), ByteKeyRange.of((ByteKey)this.createByteKey(4), (ByteKey)this.createByteKey(5)), ByteKeyRange.of((ByteKey)this.createByteKey(6), (ByteKey)this.createByteKey(7)), ByteKeyRange.of((ByteKey)this.createByteKey(8), (ByteKey)this.createByteKey(9)));
        List<ByteKeyRange> expectedKeyRangesAfterReducedSplits = Arrays.asList(ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)this.createByteKey(2)), ByteKeyRange.of((ByteKey)this.createByteKey(3), (ByteKey)this.createByteKey(5)), ByteKeyRange.of((ByteKey)this.createByteKey(6), (ByteKey)this.createByteKey(7)), ByteKeyRange.of((ByteKey)this.createByteKey(8), (ByteKey)this.createByteKey(9)));
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-MANY-ROWS-SPLITS-TABLE")), null, keyRanges, null);
        ArrayList<BigtableIO.BigtableSource> splits = new ArrayList<BigtableIO.BigtableSource>();
        for (ByteKeyRange range : keyRanges) {
            splits.add(source.withSingleRange(range));
        }
        List reducedSplits = source.reduceSplits(splits, null, 3L);
        ArrayList actualRangesAfterSplit = new ArrayList();
        for (BigtableIO.BigtableSource splitSource : reducedSplits) {
            actualRangesAfterSplit.addAll(splitSource.getRanges());
        }
        this.assertAllSourcesHaveSingleRanges(reducedSplits);
        Assert.assertThat(actualRangesAfterSplit, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedKeyRangesAfterReducedSplits.toArray()));
    }

    @Test
    public void testReduceSplitsWithAllNonAdjacentRange() throws Exception {
        String table = "TEST-MANY-ROWS-SPLITS-TABLE";
        int numRows = 10;
        int numSamples = 10;
        long bytesPerRow = 100L;
        int maxSplit = 3;
        BigtableIOTest.makeTableData("TEST-MANY-ROWS-SPLITS-TABLE", 10);
        service.setupSampleRowKeys("TEST-MANY-ROWS-SPLITS-TABLE", 10, 100L);
        List<ByteKeyRange> keyRanges = Arrays.asList(ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)this.createByteKey(1)), ByteKeyRange.of((ByteKey)this.createByteKey(2), (ByteKey)this.createByteKey(3)), ByteKeyRange.of((ByteKey)this.createByteKey(4), (ByteKey)this.createByteKey(5)), ByteKeyRange.of((ByteKey)this.createByteKey(6), (ByteKey)this.createByteKey(7)), ByteKeyRange.of((ByteKey)this.createByteKey(8), (ByteKey)this.createByteKey(9)));
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-MANY-ROWS-SPLITS-TABLE")), null, keyRanges, null);
        ArrayList<BigtableIO.BigtableSource> splits = new ArrayList<BigtableIO.BigtableSource>();
        for (ByteKeyRange range : keyRanges) {
            splits.add(source.withSingleRange(range));
        }
        List reducedSplits = source.reduceSplits(splits, null, 3L);
        ArrayList actualRangesAfterSplit = new ArrayList();
        for (BigtableIO.BigtableSource splitSource : reducedSplits) {
            actualRangesAfterSplit.addAll(splitSource.getRanges());
        }
        this.assertAllSourcesHaveSingleRanges(reducedSplits);
        Assert.assertThat(actualRangesAfterSplit, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])keyRanges.toArray()));
    }

    @Test
    public void tesReduceSplitsWithAdjacentRanges() throws Exception {
        String table = "TEST-MANY-ROWS-SPLITS-TABLE";
        int numRows = 10;
        int numSamples = 10;
        long bytesPerRow = 100L;
        int maxSplit = 3;
        BigtableIOTest.makeTableData("TEST-MANY-ROWS-SPLITS-TABLE", 10);
        service.setupSampleRowKeys("TEST-MANY-ROWS-SPLITS-TABLE", 10, 100L);
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-MANY-ROWS-SPLITS-TABLE")), null, Arrays.asList(ByteKeyRange.ALL_KEYS), null);
        ArrayList<BigtableIO.BigtableSource> splits = new ArrayList<BigtableIO.BigtableSource>();
        List<ByteKeyRange> keyRanges = Arrays.asList(ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)this.createByteKey(1)), ByteKeyRange.of((ByteKey)this.createByteKey(1), (ByteKey)this.createByteKey(2)), ByteKeyRange.of((ByteKey)this.createByteKey(2), (ByteKey)this.createByteKey(3)), ByteKeyRange.of((ByteKey)this.createByteKey(3), (ByteKey)this.createByteKey(4)), ByteKeyRange.of((ByteKey)this.createByteKey(4), (ByteKey)this.createByteKey(5)), ByteKeyRange.of((ByteKey)this.createByteKey(5), (ByteKey)this.createByteKey(6)), ByteKeyRange.of((ByteKey)this.createByteKey(6), (ByteKey)this.createByteKey(7)), ByteKeyRange.of((ByteKey)this.createByteKey(7), (ByteKey)this.createByteKey(8)), ByteKeyRange.of((ByteKey)this.createByteKey(8), (ByteKey)this.createByteKey(9)), ByteKeyRange.of((ByteKey)this.createByteKey(9), (ByteKey)ByteKey.EMPTY));
        for (ByteKeyRange range : keyRanges) {
            splits.add(source.withSingleRange(range));
        }
        List<ByteKeyRange> expectedKeyRangesAfterReducedSplits = Arrays.asList(ByteKeyRange.of((ByteKey)ByteKey.EMPTY, (ByteKey)this.createByteKey(4)), ByteKeyRange.of((ByteKey)this.createByteKey(4), (ByteKey)this.createByteKey(8)), ByteKeyRange.of((ByteKey)this.createByteKey(8), (ByteKey)ByteKey.EMPTY));
        List reducedSplits = source.reduceSplits(splits, null, 3L);
        ArrayList actualRangesAfterSplit = new ArrayList();
        for (BigtableIO.BigtableSource splitSource : reducedSplits) {
            actualRangesAfterSplit.addAll(splitSource.getRanges());
        }
        Assert.assertThat(actualRangesAfterSplit, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedKeyRangesAfterReducedSplits.toArray()));
        this.assertAllSourcesHaveSingleAdjacentRanges(reducedSplits);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)reducedSplits, null);
    }

    @Test
    public void testReadingWithSplitsWithSeveralKeyRanges() throws Exception {
        String table = "TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES";
        int numRows = 1500;
        int numSamples = 10;
        int numSplits = 12;
        long bytesPerRow = 100L;
        BigtableIOTest.makeTableData("TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES", 1500);
        service.setupSampleRowKeys("TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES", 10, 100L);
        ByteKey splitKey1 = ByteKey.copyFrom((byte[])"key000000500".getBytes(StandardCharsets.UTF_8));
        ByteKey splitKey2 = ByteKey.copyFrom((byte[])"key000001000".getBytes(StandardCharsets.UTF_8));
        ByteKeyRange tableRange = service.getTableRange("TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES");
        List<ByteKeyRange> keyRanges = Arrays.asList(tableRange.withEndKey(splitKey1), tableRange.withStartKey(splitKey1).withEndKey(splitKey2), tableRange.withStartKey(splitKey2));
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES")), null, keyRanges, null);
        BigtableIO.BigtableSource referenceSource = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES")), null, (List)ImmutableList.of((Object)service.getTableRange("TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES")), null);
        List splits = source.split(15000L, null);
        Assert.assertThat((Object)splits, (Matcher)Matchers.hasSize((int)12));
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)referenceSource, (List)splits, null);
    }

    @Test
    public void testReadingWithSubSplits() throws Exception {
        String table = "TEST-MANY-ROWS-SPLITS-TABLE";
        int numRows = 1000;
        int numSamples = 10;
        int numSplits = 20;
        long bytesPerRow = 100L;
        BigtableIOTest.makeTableData("TEST-MANY-ROWS-SPLITS-TABLE", 1000);
        service.setupSampleRowKeys("TEST-MANY-ROWS-SPLITS-TABLE", 10, 100L);
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-MANY-ROWS-SPLITS-TABLE")), null, Arrays.asList(ByteKeyRange.ALL_KEYS), null);
        List splits = source.split(5000L, null);
        Assert.assertThat((Object)splits, (Matcher)Matchers.hasSize((int)20));
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, null);
    }

    @Test
    public void testReadingWithSubSplitsWithSeveralKeyRanges() throws Exception {
        String table = "TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES";
        int numRows = 1000;
        int numSamples = 10;
        int numSplits = 20;
        int expectedNumSplits = 24;
        long bytesPerRow = 100L;
        BigtableIOTest.makeTableData("TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES", 1000);
        service.setupSampleRowKeys("TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES", 10, 100L);
        ByteKey splitKey1 = ByteKey.copyFrom((byte[])"key000000330".getBytes(StandardCharsets.UTF_8));
        ByteKey splitKey2 = ByteKey.copyFrom((byte[])"key000000730".getBytes(StandardCharsets.UTF_8));
        ByteKeyRange tableRange = service.getTableRange("TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES");
        List<ByteKeyRange> keyRanges = Arrays.asList(tableRange.withEndKey(splitKey1), tableRange.withStartKey(splitKey1).withEndKey(splitKey2), tableRange.withStartKey(splitKey2));
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES")), null, keyRanges, null);
        BigtableIO.BigtableSource referenceSource = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES")), null, (List)ImmutableList.of((Object)service.getTableRange("TEST-MANY-ROWS-SPLITS-TABLE-MULTIPLE-RANGES")), null);
        List splits = source.split(5000L, null);
        Assert.assertThat((Object)splits, (Matcher)Matchers.hasSize((int)24));
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)referenceSource, (List)splits, null);
    }

    @Test
    public void testReadingWithFilterAndSubSplits() throws Exception {
        String table = "TEST-FILTER-SUB-SPLITS";
        int numRows = 1700;
        int numSamples = 10;
        int numSplits = 20;
        long bytesPerRow = 100L;
        BigtableIOTest.makeTableData("TEST-FILTER-SUB-SPLITS", 1700);
        service.setupSampleRowKeys("TEST-FILTER-SUB-SPLITS", 10, 100L);
        RowFilter filter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*17.*")).build();
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-FILTER-SUB-SPLITS")), filter, Arrays.asList(ByteKeyRange.ALL_KEYS), null);
        List splits = source.split(8500L, null);
        Assert.assertThat((Object)splits, (Matcher)Matchers.hasSize((int)20));
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, null);
    }

    @Test
    public void testReadingDisplayData() {
        RowFilter rowFilter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)"foo.*")).build();
        ByteKeyRange keyRange = ByteKeyRange.ALL_KEYS.withEndKey(ByteKey.of((int[])new int[]{171, 205}));
        BigtableIO.Read read = BigtableIO.read().withBigtableOptions(BIGTABLE_OPTIONS).withTableId("fooTable").withRowFilter(rowFilter).withKeyRange(keyRange);
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((Matcher)Matchers.allOf((Matcher)DisplayDataMatchers.hasKey((String)"tableId"), (Matcher)DisplayDataMatchers.hasLabel((String)"Bigtable Table Id"), (Matcher)DisplayDataMatchers.hasValue((Object)"fooTable"))));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"rowFilter", (String)rowFilter.toString()));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"keyRange 0", (String)keyRange.toString()));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"bigtableOptions"));
    }

    @Test
    public void testReadingPrimitiveDisplayData() throws IOException, InterruptedException {
        String table = "fooTable";
        service.createTable("fooTable");
        RowFilter rowFilter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)"foo.*")).build();
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        BigtableIO.Read read = BigtableIO.read().withBigtableOptions(BIGTABLE_OPTIONS).withTableId("fooTable").withRowFilter(rowFilter).withBigtableService((BigtableService)service);
        Set displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform)read);
        Assert.assertThat((String)"BigtableIO.Read should include the table id in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"tableId")));
        Assert.assertThat((String)"BigtableIO.Read should include the row filter, if it exists, in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"rowFilter")));
    }

    @Test
    public void testReadingDisplayDataFromRuntimeParameters() {
        ReadOptions options = (ReadOptions)PipelineOptionsFactory.fromArgs((String[])new String[0]).withValidation().as(ReadOptions.class);
        BigtableIO.Read read = BigtableIO.read().withBigtableOptions(BIGTABLE_OPTIONS).withProjectId(options.getBigtableProject()).withInstanceId(options.getBigtableInstanceId()).withTableId(options.getBigtableTableId());
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((Matcher)Matchers.allOf((Matcher)DisplayDataMatchers.hasKey((String)"projectId"), (Matcher)DisplayDataMatchers.hasLabel((String)"Bigtable Project Id"), (Matcher)DisplayDataMatchers.hasValue((Object)"RuntimeValueProvider{propertyName=bigtableProject, default=null}"))));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((Matcher)Matchers.allOf((Matcher)DisplayDataMatchers.hasKey((String)"instanceId"), (Matcher)DisplayDataMatchers.hasLabel((String)"Bigtable Instance Id"), (Matcher)DisplayDataMatchers.hasValue((Object)"RuntimeValueProvider{propertyName=bigtableInstanceId, default=null}"))));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((Matcher)Matchers.allOf((Matcher)DisplayDataMatchers.hasKey((String)"tableId"), (Matcher)DisplayDataMatchers.hasLabel((String)"Bigtable Table Id"), (Matcher)DisplayDataMatchers.hasValue((Object)"RuntimeValueProvider{propertyName=bigtableTableId, default=null}"))));
    }

    @Test
    public void testReadWithoutValidate() {
        String table = "fooTable";
        BigtableIO.Read read = BigtableIO.read().withBigtableOptions(BIGTABLE_OPTIONS).withTableId("fooTable").withBigtableService((BigtableService)service).withoutValidation();
        read.validate(TestPipeline.testingPipelineOptions());
    }

    @Test
    public void testWriteWithoutValidate() {
        String table = "fooTable";
        BigtableIO.Write write = BigtableIO.write().withBigtableOptions(BIGTABLE_OPTIONS).withTableId("fooTable").withBigtableService((BigtableService)service).withoutValidation();
        write.validate(TestPipeline.testingPipelineOptions());
    }

    @Test
    public void testWriting() throws Exception {
        String table = "table";
        String key = "key";
        String value = "value";
        service.createTable("table");
        ((PCollection)this.p.apply("single row", (PTransform)Create.of(BigtableIOTest.makeWrite("key", "value"), (Object[])new KV[0]).withCoder(this.bigtableCoder))).apply("write", (PTransform)defaultWrite.withTableId("table"));
        this.p.run();
        this.logged.verifyDebug("Wrote 1 records");
        Assert.assertEquals((long)1L, (long)service.tables.size());
        Assert.assertNotNull(service.getTable("table"));
        SortedMap<ByteString, ByteString> rows = service.getTable("table");
        Assert.assertEquals((long)1L, (long)rows.size());
        Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"value"), rows.get(ByteString.copyFromUtf8((String)"key")));
    }

    @Test
    public void testWritingEmitsResultsWhenDoneInGlobalWindow() throws Exception {
        String table = "table";
        String key = "key";
        String value = "value";
        service.createTable("table");
        PCollection results = (PCollection)((PCollection)this.p.apply("single row", (PTransform)Create.of(BigtableIOTest.makeWrite("key", "value"), (Object[])new KV[0]).withCoder(this.bigtableCoder))).apply("write", (PTransform)defaultWrite.withTableId("table").withWriteResults());
        PAssert.that((PCollection)results).inWindow((BoundedWindow)GlobalWindow.INSTANCE).containsInAnyOrder((Object[])new BigtableWriteResult[]{BigtableWriteResult.create((long)1L)});
        this.p.run();
    }

    @Test
    public void testWritingAndWaitingOnResults() throws Exception {
        String table = "table";
        String key = "key";
        String value = "value";
        service.createTable("table");
        Instant elementTimestamp = Instant.parse((String)"2019-06-10T00:00:00");
        Duration windowDuration = Duration.standardMinutes((long)1L);
        TestStream writeInputs = TestStream.create(this.bigtableCoder).advanceWatermarkTo(elementTimestamp).addElements(BigtableIOTest.makeWrite("key", "value"), (Object[])new KV[0]).advanceWatermarkToInfinity();
        TestStream testInputs = TestStream.create((Coder)StringUtf8Coder.of()).advanceWatermarkTo(elementTimestamp).addElements((Object)"done", (Object[])new String[0]).advanceWatermarkToInfinity();
        PCollection writes = (PCollection)((PCollection)((PCollection)this.p.apply("rows", (PTransform)writeInputs)).apply("window rows", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)windowDuration)).withAllowedLateness(Duration.ZERO))).apply("write", (PTransform)defaultWrite.withTableId("table").withWriteResults());
        PCollection inputs = (PCollection)((PCollection)((PCollection)this.p.apply("inputs", (PTransform)testInputs)).apply("window inputs", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)windowDuration)))).apply("wait", (PTransform)Wait.on((PCollection[])new PCollection[]{writes}));
        IntervalWindow expectedWindow = new IntervalWindow(elementTimestamp, (ReadableDuration)windowDuration);
        PAssert.that((PCollection)inputs).inWindow((BoundedWindow)expectedWindow).containsInAnyOrder((Object[])new String[]{"done"});
        this.p.run();
    }

    @Test
    public void testWritingEmitsResultsWhenDoneInFixedWindow() throws Exception {
        String table = "table";
        String key = "key";
        String value = "value";
        service.createTable("table");
        Instant elementTimestamp = Instant.parse((String)"2019-06-10T00:00:00");
        Duration windowDuration = Duration.standardMinutes((long)1L);
        TestStream input = TestStream.create((Coder)VarIntCoder.of()).advanceWatermarkTo(elementTimestamp).addElements((Object)1, (Object[])new Integer[0]).advanceWatermarkTo(elementTimestamp.plus((ReadableDuration)windowDuration)).addElements((Object)2, (Object[])new Integer[0]).advanceWatermarkToInfinity();
        IntervalWindow expectedFirstWindow = new IntervalWindow(elementTimestamp, (ReadableDuration)windowDuration);
        IntervalWindow expectedSecondWindow = new IntervalWindow(elementTimestamp.plus((ReadableDuration)windowDuration), (ReadableDuration)windowDuration);
        PCollection results = (PCollection)((PCollection)((PCollection)((PCollection)this.p.apply("rows", (PTransform)input)).apply("window", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)windowDuration)))).apply("expand", (PTransform)ParDo.of((DoFn)new WriteGeneratorDoFn()))).apply("write", (PTransform)defaultWrite.withTableId("table").withWriteResults());
        PAssert.that((PCollection)results).inWindow((BoundedWindow)expectedFirstWindow).containsInAnyOrder((Object[])new BigtableWriteResult[]{BigtableWriteResult.create((long)1L)});
        PAssert.that((PCollection)results).inWindow((BoundedWindow)expectedSecondWindow).containsInAnyOrder((Object[])new BigtableWriteResult[]{BigtableWriteResult.create((long)2L)});
        this.p.run();
    }

    @Test
    public void testWritingFailsTableDoesNotExist() throws Exception {
        String table = "TEST-TABLE";
        PCollection emptyInput = (PCollection)this.p.apply((PTransform)Create.empty((Coder)KvCoder.of((Coder)ByteStringCoder.of(), (Coder)IterableCoder.of((Coder)ProtoCoder.of(Mutation.class)))));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(String.format("Table %s does not exist", "TEST-TABLE"));
        emptyInput.apply("write", (PTransform)defaultWrite.withTableId("TEST-TABLE"));
        this.p.run();
    }

    @Test
    public void testTableCheckIgnoredWhenCanNotAccessConfig() throws Exception {
        PCollection emptyInput = (PCollection)this.p.apply((PTransform)Create.empty((Coder)KvCoder.of((Coder)ByteStringCoder.of(), (Coder)IterableCoder.of((Coder)ProtoCoder.of(Mutation.class)))));
        emptyInput.apply("write", (PTransform)defaultWrite.withTableId(NOT_ACCESSIBLE_VALUE));
        this.p.run();
    }

    @Test
    public void testWritingFailsBadElement() throws Exception {
        String table = "TEST-TABLE";
        String key = "KEY";
        service.createTable("TEST-TABLE");
        ((PCollection)this.p.apply((PTransform)Create.of(BigtableIOTest.makeBadWrite("KEY"), (Object[])new KV[0]).withCoder(this.bigtableCoder))).apply((PTransform)defaultWrite.withTableId("TEST-TABLE"));
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectCause(Matchers.instanceOf(IOException.class));
        this.thrown.expectMessage("At least 1 errors occurred writing to Bigtable. First 1 errors:");
        this.thrown.expectMessage("Error mutating row KEY with mutations []: cell value missing");
        this.p.run();
    }

    @Test
    public void testWritingDisplayData() {
        BigtableIO.Write write = BigtableIO.write().withTableId("fooTable").withBigtableOptions(BIGTABLE_OPTIONS);
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"tableId", (String)"fooTable"));
    }

    @Test
    public void testGetSplitPointsConsumed() throws Exception {
        String table = "TEST-TABLE";
        int numRows = 100;
        int splitPointsConsumed = 0;
        BigtableIOTest.makeTableData("TEST-TABLE", 100);
        BigtableIO.BigtableSource source = new BigtableIO.BigtableSource(config.withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"TEST-TABLE")), null, Arrays.asList(ByteKeyRange.ALL_KEYS), null);
        BoundedSource.BoundedReader reader = source.createReader(TestPipeline.testingPipelineOptions());
        reader.start();
        Assert.assertEquals((String)"splitPointsConsumed starting", (long)splitPointsConsumed, (long)reader.getSplitPointsConsumed());
        while (reader.advance()) {
            Assert.assertEquals((String)"splitPointsConsumed advancing", (long)(++splitPointsConsumed), (long)reader.getSplitPointsConsumed());
        }
        Assert.assertEquals((String)"splitPointsConsumed done", (long)100L, (long)reader.getSplitPointsConsumed());
        reader.close();
    }

    @Test
    public void testReadWithBigTableOptionsSetsRetryOptions() {
        int initialBackoffMillis = -1;
        BigtableOptions.Builder optionsBuilder = BIGTABLE_OPTIONS.toBuilder();
        RetryOptions.Builder retryOptionsBuilder = new RetryOptions.Builder();
        retryOptionsBuilder.setInitialBackoffMillis(-1);
        optionsBuilder.setRetryOptions(retryOptionsBuilder.build());
        BigtableIO.Read read = BigtableIO.read().withBigtableOptions(optionsBuilder.build());
        BigtableOptions options = read.getBigtableOptions();
        Assert.assertEquals((long)-1L, (long)options.getRetryOptions().getInitialBackoffMillis());
        Assert.assertThat((Object)options.getRetryOptions(), (Matcher)Matchers.equalTo((Object)retryOptionsBuilder.build()));
    }

    @Test
    public void testWriteWithBigTableOptionsSetsBulkOptionsAndRetryOptions() {
        boolean maxInflightRpcs = true;
        int initialBackoffMillis = -1;
        BigtableOptions.Builder optionsBuilder = BIGTABLE_OPTIONS.toBuilder();
        BulkOptions.Builder bulkOptionsBuilder = new BulkOptions.Builder();
        bulkOptionsBuilder.setMaxInflightRpcs(1);
        RetryOptions.Builder retryOptionsBuilder = new RetryOptions.Builder();
        retryOptionsBuilder.setInitialBackoffMillis(-1);
        optionsBuilder.setBulkOptions(bulkOptionsBuilder.build()).setRetryOptions(retryOptionsBuilder.build());
        BigtableIO.Write write = BigtableIO.write().withBigtableOptions(optionsBuilder.build());
        BigtableOptions options = write.getBigtableOptions();
        Assert.assertTrue((boolean)options.getBulkOptions().useBulkApi());
        Assert.assertEquals((long)1L, (long)options.getBulkOptions().getMaxInflightRpcs());
        Assert.assertEquals((long)-1L, (long)options.getRetryOptions().getInitialBackoffMillis());
        Assert.assertThat((Object)options.getBulkOptions(), (Matcher)Matchers.equalTo((Object)bulkOptionsBuilder.setUseBulkApi(true).build()));
        Assert.assertThat((Object)options.getRetryOptions(), (Matcher)Matchers.equalTo((Object)retryOptionsBuilder.build()));
    }

    private static Row makeRow(ByteString key, ByteString value) {
        Column.Builder newColumn = TEST_COLUMN.toBuilder().addCells(Cell.newBuilder().setValue(value));
        return Row.newBuilder().setKey(key).addFamilies(TEST_FAMILY.toBuilder().addColumns(newColumn)).build();
    }

    private static List<Row> makeTableData(String tableId, int numRows) {
        service.createTable(tableId);
        SortedMap<ByteString, ByteString> testData = service.getTable(tableId);
        ArrayList<Row> testRows = new ArrayList<Row>(numRows);
        for (int i = 0; i < numRows; ++i) {
            ByteString key = ByteString.copyFromUtf8((String)String.format("key%09d", i));
            ByteString value = ByteString.copyFromUtf8((String)String.format("value%09d", i));
            testData.put(key, value);
            testRows.add(BigtableIOTest.makeRow(key, value));
        }
        return testRows;
    }

    static {
        BIGTABLE_OPTIONS = new BigtableOptions.Builder().setProjectId("options_project").setInstanceId("options_instance").build();
        defaultRead = BigtableIO.read().withInstanceId("instance").withProjectId("project");
        defaultWrite = BigtableIO.write().withInstanceId("instance").withProjectId("project");
        BIGTABLE_WRITE_TYPE = new TypeDescriptor<KV<ByteString, Iterable<Mutation>>>(){};
        PORT_CONFIGURATOR = (SerializableFunction & Serializable)input -> input.setPort(1234);
        COLUMN_NAME = ByteString.copyFromUtf8((String)"column");
        TEST_COLUMN = Column.newBuilder().setQualifier(COLUMN_NAME).build();
        TEST_FAMILY = Family.newBuilder().setName(COLUMN_FAMILY_NAME).build();
    }

    private static final class ByteStringComparator
    implements Comparator<ByteString>,
    Serializable {
        private ByteStringComparator() {
        }

        @Override
        public int compare(ByteString o1, ByteString o2) {
            return BigtableIOTest.makeByteKey(o1).compareTo(BigtableIOTest.makeByteKey(o2));
        }
    }

    private static class FakeBigtableWriter
    implements BigtableService.Writer {
        private final String tableId;

        public FakeBigtableWriter(String tableId) {
            this.tableId = tableId;
        }

        public CompletionStage<MutateRowResponse> writeRecord(KV<ByteString, Iterable<Mutation>> record) {
            service.verifyTableExists(this.tableId);
            SortedMap<ByteString, ByteString> table = service.getTable(this.tableId);
            ByteString key = (ByteString)record.getKey();
            for (Mutation m : (Iterable)record.getValue()) {
                Mutation.SetCell cell = m.getSetCell();
                if (cell.getValue().isEmpty()) {
                    CompletableFuture<MutateRowResponse> result = new CompletableFuture<MutateRowResponse>();
                    result.completeExceptionally(new IOException("cell value missing"));
                    return result;
                }
                table.put(key, cell.getValue());
            }
            return CompletableFuture.completedFuture(MutateRowResponse.getDefaultInstance());
        }

        public void flush() {
        }

        public void close() {
        }
    }

    private static class FakeBigtableReader
    implements BigtableService.Reader {
        private final BigtableIO.BigtableSource source;
        private Iterator<Map.Entry<ByteString, ByteString>> rows;
        private Row currentRow;
        private Predicate<ByteString> filter;

        public FakeBigtableReader(BigtableIO.BigtableSource source) {
            this.source = source;
            if (source.getRowFilter() == null) {
                this.filter = Predicates.alwaysTrue();
            } else {
                ByteString keyRegex = source.getRowFilter().getRowKeyRegexFilter();
                Preconditions.checkArgument((!keyRegex.isEmpty() ? 1 : 0) != 0, (Object)"Only RowKeyRegexFilter is supported");
                this.filter = new KeyMatchesRegex(keyRegex.toStringUtf8());
            }
            service.verifyTableExists((String)source.getTableId().get());
        }

        public boolean start() {
            this.rows = ((SortedMap)service.tables.get(this.source.getTableId().get())).entrySet().iterator();
            return this.advance();
        }

        public boolean advance() {
            Map.Entry<ByteString, ByteString> entry = null;
            while (!(!this.rows.hasNext() || this.filter.apply((Object)(entry = this.rows.next()).getKey()) && this.rangesContainsKey(this.source.getRanges(), BigtableIOTest.makeByteKey(entry.getKey())))) {
                entry = null;
            }
            if (entry == null) {
                this.currentRow = null;
                return false;
            }
            this.currentRow = BigtableIOTest.makeRow(entry.getKey(), entry.getValue());
            return true;
        }

        private boolean rangesContainsKey(List<ByteKeyRange> ranges, ByteKey key) {
            for (ByteKeyRange range : ranges) {
                if (!range.containsKey(key).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public Row getCurrentRow() {
            if (this.currentRow == null) {
                throw new NoSuchElementException();
            }
            return this.currentRow;
        }

        public void close() {
            this.rows = null;
            this.currentRow = null;
        }
    }

    private static class FakeBigtableService
    implements BigtableService {
        private final Map<String, SortedMap<ByteString, ByteString>> tables = new HashMap<String, SortedMap<ByteString, ByteString>>();
        private final Map<String, List<SampleRowKeysResponse>> sampleRowKeys = new HashMap<String, List<SampleRowKeysResponse>>();

        private FakeBigtableService() {
        }

        public BigtableOptions getBigtableOptions() {
            return null;
        }

        @Nullable
        public SortedMap<ByteString, ByteString> getTable(String tableId) {
            return this.tables.get(tableId);
        }

        public ByteKeyRange getTableRange(String tableId) {
            this.verifyTableExists(tableId);
            SortedMap<ByteString, ByteString> data = this.tables.get(tableId);
            return ByteKeyRange.of((ByteKey)BigtableIOTest.makeByteKey(data.firstKey()), (ByteKey)BigtableIOTest.makeByteKey(data.lastKey()));
        }

        public void createTable(String tableId) {
            this.tables.put(tableId, new TreeMap(new ByteStringComparator()));
        }

        public boolean tableExists(String tableId) {
            return this.tables.containsKey(tableId);
        }

        public void verifyTableExists(String tableId) {
            Preconditions.checkArgument((boolean)this.tableExists(tableId), (String)"Table %s does not exist", (Object)tableId);
        }

        public FakeBigtableReader createReader(BigtableIO.BigtableSource source) {
            return new FakeBigtableReader(source);
        }

        public FakeBigtableWriter openForWriting(String tableId) {
            return new FakeBigtableWriter(tableId);
        }

        public List<SampleRowKeysResponse> getSampleRowKeys(BigtableIO.BigtableSource source) {
            List<SampleRowKeysResponse> samples = this.sampleRowKeys.get(source.getTableId().get());
            Preconditions.checkNotNull(samples, (String)"No samples found for table %s", (Object)source.getTableId().get());
            return samples;
        }

        void setupSampleRowKeys(String tableId, int numSamples, long bytesPerRow) {
            this.verifyTableExists(tableId);
            Preconditions.checkArgument((numSamples > 0 ? 1 : 0) != 0, (String)"Number of samples must be positive: %s", (int)numSamples);
            Preconditions.checkArgument((bytesPerRow > 0L ? 1 : 0) != 0, (String)"Bytes/Row must be positive: %s", (long)bytesPerRow);
            ImmutableList.Builder ret = ImmutableList.builder();
            SortedMap<ByteString, ByteString> rows = this.getTable(tableId);
            int currentSample = 1;
            int rowsSoFar = 0;
            for (Map.Entry<ByteString, ByteString> entry : rows.entrySet()) {
                if ((double)rowsSoFar / (double)rows.size() >= (double)currentSample / (double)numSamples) {
                    ret.add((Object)SampleRowKeysResponse.newBuilder().setRowKey(entry.getKey()).setOffsetBytes((long)rowsSoFar * bytesPerRow).build());
                    ++currentSample;
                }
                ++rowsSoFar;
            }
            ret.add((Object)SampleRowKeysResponse.newBuilder().setOffsetBytes((long)rows.size() * bytesPerRow).build());
            this.sampleRowKeys.put(tableId, (List<SampleRowKeysResponse>)ret.build());
        }
    }

    private static class WriteGeneratorDoFn
    extends DoFn<Integer, KV<ByteString, Iterable<Mutation>>> {
        private WriteGeneratorDoFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext ctx) {
            for (int i = 0; i < (Integer)ctx.element(); ++i) {
                ctx.output((Object)BigtableIOTest.makeWrite("key", "value"));
            }
        }
    }

    private static class KeyMatchesRegex
    implements Predicate<ByteString> {
        private final String regex;

        public KeyMatchesRegex(String regex) {
            this.regex = regex;
        }

        public boolean apply(@Nullable ByteString input) {
            Verify.verifyNotNull((Object)input, (String)"input", (Object[])new Object[0]);
            return input.toStringUtf8().matches(this.regex);
        }
    }

    public static interface ReadOptions
    extends GcpOptions {
        @Description(value="The project that contains the table to export.")
        public ValueProvider<String> getBigtableProject();

        public void setBigtableProject(ValueProvider<String> var1);

        @Description(value="The Bigtable instance id that contains the table to export.")
        public ValueProvider<String> getBigtableInstanceId();

        public void setBigtableInstanceId(ValueProvider<String> var1);

        @Description(value="The Bigtable table id to export.")
        public ValueProvider<String> getBigtableTableId();

        public void setBigtableTableId(ValueProvider<String> var1);
    }
}

