/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TableRowJsonCoderTest {
    private static final Coder<TableRow> TEST_CODER = TableRowJsonCoder.of();
    private static final List<TableRow> TEST_VALUES = Arrays.asList(new TableRowBuilder().build(), new TableRowBuilder().set("a", "1").build(), new TableRowBuilder().set("b", 3.14).build(), new TableRowBuilder().set("a", "1").set("b", true).set("c", "hi").build());
    private static final List<String> TEST_ENCODINGS = Arrays.asList("e30", "eyJhIjoiMSJ9", "eyJiIjozLjE0fQ", "eyJhIjoiMSIsImIiOnRydWUsImMiOiJoaSJ9");

    @Test
    public void testDecodeEncodeEqual() throws Exception {
        for (TableRow value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(TableRow.class)));
    }

    private static class TableRowBuilder {
        private TableRow row = new TableRow();

        public TableRowBuilder set(String fieldName, Object value) {
            this.row.set(fieldName, value);
            return this;
        }

        public TableRow build() {
            return this.row;
        }
    }
}

