/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableRow;
import java.util.ArrayList;
import java.util.List;

class TableContainer {
    Table table;
    List<TableRow> rows;
    List<String> ids;
    Long sizeBytes;

    TableContainer(Table table) {
        this.table = table;
        this.rows = new ArrayList<TableRow>();
        this.ids = new ArrayList<String>();
        this.sizeBytes = 0L;
    }

    long addRow(TableRow row, String id) {
        this.rows.add(row);
        this.ids.add(id);
        long rowSize = row.toString().length();
        Long tableSize = this.table.getNumBytes();
        if (tableSize == null) {
            this.table.setNumBytes(Long.valueOf(rowSize));
        } else {
            this.table.setNumBytes(Long.valueOf(tableSize + rowSize));
        }
        return rowSize;
    }

    Table getTable() {
        return this.table;
    }

    List<TableRow> getRows() {
        return this.rows;
    }
}

