/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InsertRetryPolicyTest {
    @Test
    public void testNeverRetry() {
        Assert.assertFalse((boolean)InsertRetryPolicy.neverRetry().shouldRetry(new InsertRetryPolicy.Context(new TableDataInsertAllResponse.InsertErrors())));
    }

    @Test
    public void testAlwaysRetry() {
        Assert.assertTrue((boolean)InsertRetryPolicy.alwaysRetry().shouldRetry(new InsertRetryPolicy.Context(new TableDataInsertAllResponse.InsertErrors())));
    }

    @Test
    public void testDontRetryPersistentErrors() {
        InsertRetryPolicy policy = InsertRetryPolicy.retryTransientErrors();
        Assert.assertTrue((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "unavailable"))));
        Assert.assertFalse((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "invalid"))));
        Assert.assertFalse((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "invalidQuery"))));
        Assert.assertFalse((boolean)policy.shouldRetry(new InsertRetryPolicy.Context(this.generateErrorAmongMany(5, "timeout", "notImplemented"))));
    }

    private TableDataInsertAllResponse.InsertErrors generateErrorAmongMany(int numErrors, String baseReason, String exceptionalReason) {
        ArrayList errorProtos = Lists.newArrayListWithExpectedSize((int)numErrors);
        int exceptionalPosition = ThreadLocalRandom.current().nextInt(numErrors);
        for (int i = 0; i < numErrors; ++i) {
            ErrorProto error = new ErrorProto();
            error.setReason(i == exceptionalPosition ? exceptionalReason : baseReason);
            errorProtos.add(error);
        }
        TableDataInsertAllResponse.InsertErrors errors = new TableDataInsertAllResponse.InsertErrors();
        errors.setErrors((List)errorProtos);
        return errors;
    }
}

