/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonErrorContainer;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.util.MockSleeper;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.RetryBoundedBackOff;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.extensions.gcp.util.FastNanoClockAndSleeper;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigQueryServicesImplTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(BigQueryServicesImpl.class);
    @Mock
    private LowLevelHttpResponse response;
    private MockLowLevelHttpRequest request;
    private Bigquery bigquery;
    private static final FluentBackoff TEST_BACKOFF = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)1L)).withExponent(1.0).withMaxRetries(3);

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.request = new MockLowLevelHttpRequest(){

            public LowLevelHttpResponse execute() throws IOException {
                return BigQueryServicesImplTest.this.response;
            }
        };
        MockHttpTransport transport = new MockHttpTransport.Builder().setLowLevelHttpRequest(this.request).build();
        this.bigquery = new Bigquery.Builder((HttpTransport)transport, Transport.getJsonFactory(), (HttpRequestInitializer)new RetryHttpRequestInitializer()).build();
    }

    @Test
    public void testStartLoadJobSucceeds() throws IOException, InterruptedException {
        Job testJob = new Job();
        JobReference jobRef = new JobReference();
        jobRef.setJobId("jobId");
        jobRef.setProjectId("projectId");
        testJob.setJobReference(jobRef);
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        FastNanoClockAndSleeper sleeper = new FastNanoClockAndSleeper();
        BigQueryServicesImpl.JobServiceImpl.startJob((Job)testJob, (ApiErrorExtractor)new ApiErrorExtractor(), (Bigquery)this.bigquery, (Sleeper)sleeper, (BackOff)BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.backoff()));
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
        this.expectedLogs.verifyInfo(String.format("Started BigQuery job: %s", jobRef));
    }

    @Test
    public void testStartLoadJobSucceedsAlreadyExists() throws IOException, InterruptedException {
        Job testJob = new Job();
        JobReference jobRef = new JobReference();
        jobRef.setJobId("jobId");
        jobRef.setProjectId("projectId");
        testJob.setJobReference(jobRef);
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)409);
        FastNanoClockAndSleeper sleeper = new FastNanoClockAndSleeper();
        BigQueryServicesImpl.JobServiceImpl.startJob((Job)testJob, (ApiErrorExtractor)new ApiErrorExtractor(), (Bigquery)this.bigquery, (Sleeper)sleeper, (BackOff)BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.backoff()));
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
        this.expectedLogs.verifyNotLogged("Started BigQuery job");
    }

    @Test
    public void testStartLoadJobRetry() throws IOException, InterruptedException {
        Job testJob = new Job();
        JobReference jobRef = new JobReference();
        jobRef.setJobId("jobId");
        jobRef.setProjectId("projectId");
        testJob.setJobReference(jobRef);
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)403).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403))).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        FastNanoClockAndSleeper sleeper = new FastNanoClockAndSleeper();
        BigQueryServicesImpl.JobServiceImpl.startJob((Job)testJob, (ApiErrorExtractor)new ApiErrorExtractor(), (Bigquery)this.bigquery, (Sleeper)sleeper, (BackOff)BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.backoff()));
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContentType();
    }

    @Test
    public void testPollJobSucceeds() throws IOException, InterruptedException {
        Job testJob = new Job();
        testJob.setStatus(new JobStatus().setState("DONE"));
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.pollJob(jobRef, Sleeper.DEFAULT, BackOff.ZERO_BACKOFF);
        Assert.assertEquals((Object)testJob, (Object)job);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
    }

    @Test
    public void testPollJobFailed() throws IOException, InterruptedException {
        Job testJob = new Job();
        testJob.setStatus(new JobStatus().setState("DONE").setErrorResult(new ErrorProto()));
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.pollJob(jobRef, Sleeper.DEFAULT, BackOff.ZERO_BACKOFF);
        Assert.assertEquals((Object)testJob, (Object)job);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
    }

    @Test
    public void testPollJobUnknown() throws IOException, InterruptedException {
        Job testJob = new Job();
        testJob.setStatus(new JobStatus());
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.pollJob(jobRef, Sleeper.DEFAULT, BackOff.STOP_BACKOFF);
        Assert.assertEquals(null, (Object)job);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
    }

    @Test
    public void testGetJobSucceeds() throws Exception {
        Job testJob = new Job();
        testJob.setStatus(new JobStatus());
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.getJob(jobRef, Sleeper.DEFAULT, BackOff.ZERO_BACKOFF);
        Assert.assertEquals((Object)testJob, (Object)job);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
    }

    @Test
    public void testGetJobNotFound() throws Exception {
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)404);
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.getJob(jobRef, Sleeper.DEFAULT, BackOff.ZERO_BACKOFF);
        Assert.assertEquals(null, (Object)job);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
    }

    @Test
    public void testGetJobThrows() throws Exception {
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)401);
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(String.format("Unable to find BigQuery job: %s", jobRef));
        jobService.getJob(jobRef, Sleeper.DEFAULT, BackOff.STOP_BACKOFF);
    }

    @Test
    public void testGetTableSucceeds() throws Exception {
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        Table testTable = new Table();
        testTable.setTableReference(tableRef);
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)403).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403))).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        Table table = datasetService.getTable(tableRef, null, BackOff.ZERO_BACKOFF, Sleeper.DEFAULT);
        Assert.assertEquals((Object)testTable, (Object)table);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContentType();
    }

    @Test
    public void testGetTableNotFound() throws IOException, InterruptedException {
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)404);
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        Table table = datasetService.getTable(tableRef, null, BackOff.ZERO_BACKOFF, Sleeper.DEFAULT);
        Assert.assertNull((Object)table);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
    }

    @Test
    public void testGetTableThrows() throws Exception {
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)401);
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(String.format("Unable to get table: %s", tableRef.getTableId()));
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        datasetService.getTable(tableRef, null, BackOff.STOP_BACKOFF, Sleeper.DEFAULT);
    }

    @Test
    public void testIsTableEmptySucceeds() throws Exception {
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        TableDataList testDataList = new TableDataList().setRows((List)ImmutableList.of((Object)new TableRow()));
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)403).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403))).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testDataList));
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        Assert.assertFalse((boolean)datasetService.isTableEmpty(tableRef, BackOff.ZERO_BACKOFF, Sleeper.DEFAULT));
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContentType();
    }

    @Test
    public void testIsTableEmptyNoRetryForNotFound() throws IOException, InterruptedException {
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)404);
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(String.format("Unable to list table data: %s", tableRef.getTableId()));
        try {
            datasetService.isTableEmpty(tableRef, BackOff.ZERO_BACKOFF, Sleeper.DEFAULT);
        }
        finally {
            ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
        }
    }

    @Test
    public void testIsTableEmptyThrows() throws Exception {
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)401);
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(String.format("Unable to list table data: %s", tableRef.getTableId()));
        datasetService.isTableEmpty(tableRef, BackOff.STOP_BACKOFF, Sleeper.DEFAULT);
    }

    @Test
    public void testExecuteWithRetries() throws IOException, InterruptedException {
        Table testTable = new Table();
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        Table table = (Table)BigQueryServicesImpl.executeWithRetries((AbstractGoogleClientRequest)this.bigquery.tables().get("projectId", "datasetId", "tableId"), (String)"Failed to get table.", (Sleeper)Sleeper.DEFAULT, (BackOff)BackOff.STOP_BACKOFF, (SerializableFunction)BigQueryServicesImpl.ALWAYS_RETRY);
        Assert.assertEquals((Object)testTable, (Object)table);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
    }

    private <T> ValueInSingleWindow<T> wrapValue(T value) {
        return ValueInSingleWindow.of(value, (Instant)GlobalWindow.TIMESTAMP_MAX_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING);
    }

    @Test
    public void testInsertRateLimitRetry() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ArrayList<ValueInSingleWindow<TableRow>> rows = new ArrayList<ValueInSingleWindow<TableRow>>();
        rows.add(this.wrapValue(new TableRow()));
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)403).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403))).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)new TableDataInsertAllResponse()));
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        dataService.insertAll(ref, rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContentType();
        this.expectedLogs.verifyInfo("BigQuery insertAll error, retrying:");
    }

    @Test
    public void testInsertQuotaExceededRetry() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ArrayList<ValueInSingleWindow<TableRow>> rows = new ArrayList<ValueInSingleWindow<TableRow>>();
        rows.add(this.wrapValue(new TableRow()));
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)403).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("quotaExceeded", 403))).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)new TableDataInsertAllResponse()));
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        dataService.insertAll(ref, rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContentType();
        this.expectedLogs.verifyInfo("BigQuery insertAll error, retrying:");
    }

    @Test
    public void testInsertRetrySelectRows() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("row", (Object)"a")), this.wrapValue(new TableRow().set("row", (Object)"b")));
        ImmutableList insertIds = ImmutableList.of((Object)"a", (Object)"b");
        TableDataInsertAllResponse bFailed = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L)).setErrors((List)ImmutableList.of((Object)new ErrorProto()))));
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)bFailed)).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        dataService.insertAll(ref, (List)rows, (List)insertIds, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContentType();
    }

    @Test
    public void testInsertFailsGracefully() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow()), this.wrapValue(new TableRow()));
        TableDataInsertAllResponse row1Failed = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L))));
        TableDataInsertAllResponse row0Failed = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L))));
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)row1Failed)).thenAnswer(invocation -> BigQueryServicesImplTest.toStream((GenericJson)row0Failed));
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        try {
            dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IOException.class));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Insert failed:"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"[{\"index\":0}]"));
        }
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)4))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)4))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)4))).getContentType();
        this.expectedLogs.verifyInfo("Retrying 1 failed inserts to BigQuery");
    }

    @Test
    public void testInsertOtherRetry() throws Throwable {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ArrayList<ValueInSingleWindow<TableRow>> rows = new ArrayList<ValueInSingleWindow<TableRow>>();
        rows.add(this.wrapValue(new TableRow()));
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)403).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("actually forbidden", 403))).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)new TableDataInsertAllResponse()));
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        dataService.insertAll(ref, rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContentType();
        this.expectedLogs.verifyInfo("BigQuery insertAll error, retrying:");
    }

    @Test
    public void testInsertRetryPolicy() throws InterruptedException, IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow()), this.wrapValue(new TableRow()));
        TableDataInsertAllResponse firstFailure = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout"))), (Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("invalid")))));
        TableDataInsertAllResponse secondFialure = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout")))));
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)firstFailure)).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)secondFialure)).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        ArrayList failedInserts = Lists.newArrayList();
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.retryTransientErrors(), (List)failedInserts, ErrorContainer.TABLE_ROW_ERROR_CONTAINER, false, false);
        Assert.assertEquals((long)1L, (long)failedInserts.size());
        this.expectedLogs.verifyInfo("Retrying 1 failed inserts to BigQuery");
    }

    @Test
    public void testSkipInvalidRowsIgnoreUnknownValuesStreaming() throws InterruptedException, IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow()), this.wrapValue(new TableRow()));
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded)).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.neverRetry(), (List)Lists.newArrayList(), ErrorContainer.TABLE_ROW_ERROR_CONTAINER, false, false);
        TableDataInsertAllRequest parsedRequest = BigQueryServicesImplTest.fromString(this.request.getContentAsString(), TableDataInsertAllRequest.class);
        Assert.assertFalse((boolean)parsedRequest.getSkipInvalidRows());
        Assert.assertFalse((boolean)parsedRequest.getIgnoreUnknownValues());
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.neverRetry(), (List)Lists.newArrayList(), ErrorContainer.TABLE_ROW_ERROR_CONTAINER, true, true);
        parsedRequest = BigQueryServicesImplTest.fromString(this.request.getContentAsString(), TableDataInsertAllRequest.class);
        Assert.assertTrue((boolean)parsedRequest.getSkipInvalidRows());
        Assert.assertTrue((boolean)parsedRequest.getIgnoreUnknownValues());
    }

    private static <T extends GenericJson> T fromString(String content, Class<T> clazz) throws IOException {
        return (T)((GenericJson)JacksonFactory.getDefaultInstance().fromString(content, clazz));
    }

    private static InputStream toStream(GenericJson content) throws IOException {
        return new ByteArrayInputStream(JacksonFactory.getDefaultInstance().toByteArray((Object)content));
    }

    private static GoogleJsonErrorContainer errorWithReasonAndStatus(String reason, int status) {
        GoogleJsonError.ErrorInfo info = new GoogleJsonError.ErrorInfo();
        info.setReason(reason);
        info.setDomain("global");
        GoogleJsonError error = new GoogleJsonError();
        error.setErrors((List)ImmutableList.of((Object)info));
        error.setCode(status);
        error.setMessage(reason);
        GoogleJsonErrorContainer container = new GoogleJsonErrorContainer();
        container.setError(error);
        return container;
    }

    @Test
    public void testCreateTableSucceeds() throws IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        Table testTable = new Table().setTableReference(ref);
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        BigQueryServicesImpl.DatasetServiceImpl services = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        Table ret = services.tryCreateTable(testTable, (BackOff)new RetryBoundedBackOff(0, BackOff.ZERO_BACKOFF), Sleeper.DEFAULT);
        Assert.assertEquals((Object)testTable, (Object)ret);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
    }

    @Test
    public void testCreateTableDoesNotRetry() throws IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        Table testTable = new Table().setTableReference(ref);
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)403).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("actually forbidden", 403))).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        this.thrown.expect(GoogleJsonResponseException.class);
        this.thrown.expectMessage("actually forbidden");
        BigQueryServicesImpl.DatasetServiceImpl services = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        try {
            services.tryCreateTable(testTable, (BackOff)new RetryBoundedBackOff(3, BackOff.ZERO_BACKOFF), Sleeper.DEFAULT);
            Assert.fail();
        }
        catch (IOException e) {
            ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
            throw e;
        }
    }

    @Test
    public void testCreateTableSucceedsAlreadyExists() throws IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        TableSchema schema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("column1").setType("String"), (Object)new TableFieldSchema().setName("column2").setType("Integer")));
        Table testTable = new Table().setTableReference(ref).setSchema(schema);
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)409);
        BigQueryServicesImpl.DatasetServiceImpl services = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        Table ret = services.tryCreateTable(testTable, (BackOff)new RetryBoundedBackOff(0, BackOff.ZERO_BACKOFF), Sleeper.DEFAULT);
        Assert.assertNull((Object)ret);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getContentType();
    }

    @Test
    public void testCreateTableRetry() throws IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        Table testTable = new Table().setTableReference(ref);
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)403).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403))).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        BigQueryServicesImpl.DatasetServiceImpl services = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        Table ret = services.tryCreateTable(testTable, (BackOff)new RetryBoundedBackOff(3, BackOff.ZERO_BACKOFF), Sleeper.DEFAULT);
        Assert.assertEquals((Object)testTable, (Object)ret);
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContent();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getContentType();
        Verify.verifyNotNull((Object)ret.getTableReference());
        this.expectedLogs.verifyInfo("Quota limit reached when creating table project:dataset.table, retrying up to 5.0 minutes");
    }

    @Test
    public void testSimpleErrorRetrieval() throws InterruptedException, IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("a", (Object)1)), this.wrapValue(new TableRow().set("b", (Object)2)));
        TableDataInsertAllResponse failures = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout"))), (Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("invalid")))));
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)failures));
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        ArrayList failedInserts = Lists.newArrayList();
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.neverRetry(), (List)failedInserts, ErrorContainer.TABLE_ROW_ERROR_CONTAINER, false, false);
        Assert.assertThat((Object)failedInserts, (Matcher)Matchers.is((Object)rows));
    }

    @Test
    public void testExtendedErrorRetrieval() throws InterruptedException, IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("a", (Object)1)), this.wrapValue(new TableRow().set("b", (Object)2)));
        TableDataInsertAllResponse failures = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout"))), (Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("invalid")))));
        ImmutableList expected = ImmutableList.of(this.wrapValue(new BigQueryInsertError((TableRow)((ValueInSingleWindow)rows.get(0)).getValue(), (TableDataInsertAllResponse.InsertErrors)failures.getInsertErrors().get(0), ref)), this.wrapValue(new BigQueryInsertError((TableRow)((ValueInSingleWindow)rows.get(1)).getValue(), (TableDataInsertAllResponse.InsertErrors)failures.getInsertErrors().get(1), ref)));
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
        Mockito.when((Object)this.response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)failures));
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, PipelineOptionsFactory.create());
        ArrayList failedInserts = Lists.newArrayList();
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), (Sleeper)new MockSleeper(), InsertRetryPolicy.neverRetry(), (List)failedInserts, ErrorContainer.BIG_QUERY_INSERT_ERROR_ERROR_CONTAINER, false, false);
        Assert.assertThat((Object)failedInserts, (Matcher)Matchers.is((Object)expected));
    }
}

