/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import java.security.SecureRandom;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.testing.UsesKms;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
@Category(value={UsesKms.class})
public class BigQueryKmsKeyIT {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryKmsKeyIT.class);
    private static final BigqueryClient BQ_CLIENT = new BigqueryClient("BigQueryKmsKeyIT");
    private static final String BIG_QUERY_DATASET_ID = "bq_query_to_table_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
    private static final TableSchema OUTPUT_SCHEMA = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("fruit").setType("STRING")));
    private static TestPipelineOptions options;
    private static String project;
    private static String kmsKey;

    @BeforeClass
    public static void setupTestEnvironment() throws Exception {
        options = (TestPipelineOptions)TestPipeline.testingPipelineOptions().as(TestPipelineOptions.class);
        project = ((GcpOptions)options.as(GcpOptions.class)).getProject();
        BQ_CLIENT.createNewDataset(project, BIG_QUERY_DATASET_ID);
    }

    @AfterClass
    public static void cleanup() {
        LOG.info("Start to clean up tables and datasets.");
        BQ_CLIENT.deleteDataset(project, BIG_QUERY_DATASET_ID);
    }

    private void testQueryAndWrite(BigQueryIO.Write.Method method) throws Exception {
        String outputTableId = "testQueryAndWrite_" + method.name();
        String outputTableSpec = project + ":" + BIG_QUERY_DATASET_ID + "." + outputTableId;
        options.setTempLocation(options.getTempRoot() + "/bq_it_temp");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().fromQuery("SELECT * FROM (SELECT \"foo\" as fruit)").withKmsKey(kmsKey))).apply((PTransform)BigQueryIO.writeTableRows().to(outputTableSpec).withSchema(OUTPUT_SCHEMA).withMethod(method).withKmsKey(kmsKey));
        p.run().waitUntilFinish();
        Table table = BQ_CLIENT.getTableResource(project, BIG_QUERY_DATASET_ID, outputTableId);
        Assert.assertNotNull((String)String.format("table not found: %s", outputTableId), (Object)table);
        Assert.assertNotNull((String)"output table has no EncryptionConfiguration", (Object)table.getEncryptionConfiguration());
        Assert.assertEquals((Object)table.getEncryptionConfiguration().getKmsKeyName(), (Object)kmsKey);
    }

    @Test
    public void testWithFileLoads() throws Exception {
        this.testQueryAndWrite(BigQueryIO.Write.Method.FILE_LOADS);
    }

    @Test
    public void testWithStreamingInserts() throws Exception {
        this.testQueryAndWrite(BigQueryIO.Write.Method.STREAMING_INSERTS);
    }

    static {
        kmsKey = "projects/apache-beam-testing/locations/global/keyRings/beam-it/cryptoKeys/test";
    }
}

