/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatistics2;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1beta1.AvroProto;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnknownFieldSet;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.protobuf.ByteStringCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageQuerySource;
import org.apache.beam.sdk.io.gcp.bigquery.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.bigquery.FakeJobService;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BigQueryIOStorageQueryTest {
    private transient BigQueryOptions options;
    private transient TemporaryFolder testFolder = new TemporaryFolder();
    private transient TestPipeline p;
    @Rule
    public final transient TestRule folderThenPipeline = new TestRule(){

        public Statement apply(final Statement base, final Description description) {
            Statement withPipeline = new Statement(){

                public void evaluate() throws Throwable {
                    BigQueryIOStorageQueryTest.this.options = (BigQueryOptions)TestPipeline.testingPipelineOptions().as(BigQueryOptions.class);
                    BigQueryIOStorageQueryTest.this.options.setProject("project-id");
                    BigQueryIOStorageQueryTest.this.options.setTempLocation(BigQueryIOStorageQueryTest.this.testFolder.getRoot().getAbsolutePath());
                    BigQueryIOStorageQueryTest.this.p = TestPipeline.fromOptions((PipelineOptions)BigQueryIOStorageQueryTest.this.options);
                    BigQueryIOStorageQueryTest.this.p.apply(base, description).evaluate();
                }
            };
            return BigQueryIOStorageQueryTest.this.testFolder.apply(withPipeline, description);
        }
    };
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private FakeDatasetService fakeDatasetService = new FakeDatasetService();
    private FakeJobService fakeJobService = new FakeJobService();
    private FakeBigQueryServices fakeBigQueryServices = new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withJobService(this.fakeJobService);
    private static final String DEFAULT_QUERY = "SELECT * FROM `dataset.table` LIMIT 1";
    private static final String AVRO_SCHEMA_STRING = "{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"RowRecord\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"number\", \"type\": \"long\"}\n ]\n}";
    private static final Schema AVRO_SCHEMA = new Schema.Parser().parse("{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"RowRecord\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"number\", \"type\": \"long\"}\n ]\n}");
    private static final TableSchema TABLE_SCHEMA = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("number").setType("INTEGER").setMode("REQUIRED")));
    private static final EncoderFactory ENCODER_FACTORY = EncoderFactory.get();

    @Before
    public void setUp() throws Exception {
        FakeDatasetService.setUp();
    }

    @Test
    public void testDefaultQueryBasedSource() throws Exception {
        BigQueryIO.TypedRead<TableRow> typedRead = this.getDefaultTypedRead();
        this.checkTypedReadQueryObject(typedRead, DEFAULT_QUERY);
        Assert.assertTrue((boolean)typedRead.getValidate());
        Assert.assertTrue((boolean)typedRead.getFlattenResults());
        Assert.assertTrue((boolean)typedRead.getUseLegacySql());
        Assert.assertNull((Object)typedRead.getQueryPriority());
        Assert.assertNull((Object)typedRead.getQueryLocation());
        Assert.assertNull((Object)typedRead.getKmsKey());
        Assert.assertFalse((boolean)typedRead.getWithTemplateCompatibility());
    }

    @Test
    public void testQueryBasedSourceWithCustomQuery() throws Exception {
        BigQueryIO.TypedRead typedRead = BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).fromQuery("SELECT * FROM `google.com:project.dataset.table`").withCoder((Coder)TableRowJsonCoder.of());
        this.checkTypedReadQueryObject(typedRead, "SELECT * FROM `google.com:project.dataset.table`");
    }

    @Test
    public void testQueryBasedSourceWithoutValidation() throws Exception {
        BigQueryIO.TypedRead typedRead = this.getDefaultTypedRead().withoutValidation();
        this.checkTypedReadQueryObject(typedRead, DEFAULT_QUERY);
        Assert.assertFalse((boolean)typedRead.getValidate());
    }

    @Test
    public void testQueryBasedSourceWithoutResultFlattening() throws Exception {
        BigQueryIO.TypedRead typedRead = this.getDefaultTypedRead().withoutResultFlattening();
        this.checkTypedReadQueryObject(typedRead, DEFAULT_QUERY);
        Assert.assertFalse((boolean)typedRead.getFlattenResults());
    }

    @Test
    public void testQueryBasedSourceWithStandardSql() throws Exception {
        BigQueryIO.TypedRead typedRead = this.getDefaultTypedRead().usingStandardSql();
        this.checkTypedReadQueryObject(typedRead, DEFAULT_QUERY);
        Assert.assertFalse((boolean)typedRead.getUseLegacySql());
    }

    @Test
    public void testQueryBasedSourceWithPriority() throws Exception {
        BigQueryIO.TypedRead typedRead = this.getDefaultTypedRead().withQueryPriority(BigQueryIO.TypedRead.QueryPriority.INTERACTIVE);
        this.checkTypedReadQueryObject(typedRead, DEFAULT_QUERY);
        Assert.assertEquals((Object)BigQueryIO.TypedRead.QueryPriority.INTERACTIVE, (Object)typedRead.getQueryPriority());
    }

    @Test
    public void testQueryBasedSourceWithQueryLocation() throws Exception {
        BigQueryIO.TypedRead typedRead = this.getDefaultTypedRead().withQueryLocation("US");
        this.checkTypedReadQueryObject(typedRead, DEFAULT_QUERY);
        Assert.assertEquals((Object)"US", (Object)typedRead.getQueryLocation());
    }

    @Test
    public void testQueryBasedSourceWithKmsKey() throws Exception {
        BigQueryIO.TypedRead typedRead = this.getDefaultTypedRead().withKmsKey("kms_key");
        this.checkTypedReadQueryObject(typedRead, DEFAULT_QUERY);
        Assert.assertEquals((Object)"kms_key", (Object)typedRead.getKmsKey());
    }

    @Test
    public void testQueryBasedSourceWithTemplateCompatibility() throws Exception {
        BigQueryIO.TypedRead typedRead = this.getDefaultTypedRead().withTemplateCompatibility();
        this.checkTypedReadQueryObject(typedRead, DEFAULT_QUERY);
        Assert.assertTrue((boolean)typedRead.getWithTemplateCompatibility());
    }

    private BigQueryIO.TypedRead<TableRow> getDefaultTypedRead() {
        return BigQueryIO.read((SerializableFunction)new BigQueryIO.TableRowParser()).fromQuery(DEFAULT_QUERY).withCoder((Coder)TableRowJsonCoder.of()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ);
    }

    private void checkTypedReadQueryObject(BigQueryIO.TypedRead typedRead, String query) {
        Assert.assertNull((Object)typedRead.getTable());
        Assert.assertEquals((Object)query, (Object)typedRead.getQuery().get());
    }

    @Test
    public void testBuildQueryBasedSourceWithReadOptions() throws Exception {
        ReadOptions.TableReadOptions readOptions = ReadOptions.TableReadOptions.newBuilder().setRowRestriction("a > 5").build();
        BigQueryIO.TypedRead typedRead = this.getDefaultTypedRead().withReadOptions(readOptions);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid BigQueryIO.Read: Specifies table read options, which only applies when reading from a table");
        this.p.apply((PTransform)typedRead);
        this.p.run();
    }

    @Test
    public void testDisplayData() throws Exception {
        BigQueryIO.TypedRead<TableRow> typedRead = this.getDefaultTypedRead();
        DisplayData displayData = DisplayData.from(typedRead);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"query", (String)DEFAULT_QUERY));
    }

    @Test
    public void testEvaluatedDisplayData() throws Exception {
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        BigQueryIO.TypedRead<TableRow> typedRead = this.getDefaultTypedRead();
        Set displayData = evaluator.displayDataForPrimitiveSourceTransforms(typedRead);
        MatcherAssert.assertThat((Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"query")));
    }

    @Test
    public void testName() {
        Assert.assertEquals((Object)"BigQueryIO.TypedRead", (Object)this.getDefaultTypedRead().getName());
    }

    @Test
    public void testCoderInference() {
        SerializableFunction<SchemaAndRecord, KV<ByteString, Storage.ReadSession>> parseFn = new SerializableFunction<SchemaAndRecord, KV<ByteString, Storage.ReadSession>>(){

            public KV<ByteString, Storage.ReadSession> apply(SchemaAndRecord input) {
                return null;
            }
        };
        Assert.assertEquals((Object)KvCoder.of((Coder)ByteStringCoder.of(), (Coder)ProtoCoder.of(Storage.ReadSession.class)), (Object)BigQueryIO.read((SerializableFunction)parseFn).inferCoder(CoderRegistry.createDefault()));
    }

    @Test
    public void testQuerySourceEstimatedSize() throws Exception {
        String fakeQuery = "fake query text";
        this.fakeJobService.expectDryRunQuery(this.options.getProject(), fakeQuery, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(125L))));
        BigQueryStorageQuerySource querySource = BigQueryStorageQuerySource.create((String)"stepUuid", (ValueProvider)ValueProvider.StaticValueProvider.of((Object)fakeQuery), (Boolean)true, (Boolean)true, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.INTERACTIVE, null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)this.fakeBigQueryServices);
        Assert.assertEquals((long)125L, (long)querySource.getEstimatedSizeBytes((PipelineOptions)this.options));
    }

    @Test
    public void testQuerySourceInitialSplit() throws Exception {
        this.doQuerySourceInitialSplit(1024L, 1024, 50);
    }

    @Test
    public void testQuerySourceInitialSplit_MinSplitCount() throws Exception {
        this.doQuerySourceInitialSplit(0x100000L, 10, 1);
    }

    @Test
    public void testQuerySourceInitialSplit_MaxSplitCount() throws Exception {
        this.doQuerySourceInitialSplit(10L, 10000, 200);
    }

    private void doQuerySourceInitialSplit(long bundleSize, int requestedStreamCount, int expectedStreamCount) throws Exception {
        TableReference sourceTableRef = BigQueryHelpers.parseTableSpec((String)"project:dataset.table");
        this.fakeDatasetService.createDataset(sourceTableRef.getProjectId(), sourceTableRef.getDatasetId(), "asia-northeast1", "Fake plastic tree^H^H^H^Htables", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(sourceTableRef).setLocation("asia-northeast1"));
        Table queryResultTable = new Table().setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).setNumBytes(Long.valueOf(0x100000L));
        String encodedQuery = FakeBigQueryServices.encodeQueryResult(queryResultTable);
        this.fakeJobService.expectDryRunQuery(this.options.getProject(), encodedQuery, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(0x100000L)).setReferencedTables((List)ImmutableList.of((Object)sourceTableRef))));
        String stepUuid = "testStepUuid";
        TableReference tempTableReference = BigQueryHelpers.createTempTableReference((String)this.options.getProject(), (String)BigQueryHelpers.createJobIdToken((String)this.options.getJobName(), (String)stepUuid));
        Storage.CreateReadSessionRequest expectedRequest = Storage.CreateReadSessionRequest.newBuilder().setParent("projects/" + this.options.getProject()).setTableReference(BigQueryHelpers.toTableRefProto((TableReference)tempTableReference)).setRequestedStreams(requestedStreamCount).setUnknownFields(UnknownFieldSet.newBuilder().addField(7, UnknownFieldSet.Field.newBuilder().addVarint(2L).build()).build()).build();
        Storage.ReadSession.Builder builder = Storage.ReadSession.newBuilder();
        for (int i = 0; i < expectedStreamCount; ++i) {
            builder.addStreams(Storage.Stream.newBuilder().setName("stream-" + i));
        }
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.createReadSession(expectedRequest)).thenReturn((Object)builder.build());
        BigQueryStorageQuerySource querySource = BigQueryStorageQuerySource.create((String)stepUuid, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)encodedQuery), (Boolean)true, (Boolean)true, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.BATCH, null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withJobService(this.fakeJobService).withStorageClient(fakeStorageClient));
        List sources = querySource.split(bundleSize, (PipelineOptions)this.options);
        Assert.assertEquals((long)expectedStreamCount, (long)sources.size());
    }

    @Test
    public void testQuerySourceInitialSplit_NoReferencedTables() throws Exception {
        Table queryResultTable = new Table().setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).setNumBytes(Long.valueOf(0x100000L));
        String encodedQuery = FakeBigQueryServices.encodeQueryResult(queryResultTable);
        this.fakeJobService.expectDryRunQuery(this.options.getProject(), encodedQuery, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(0x100000L)).setReferencedTables((List)ImmutableList.of())));
        String stepUuid = "testStepUuid";
        TableReference tempTableReference = BigQueryHelpers.createTempTableReference((String)this.options.getProject(), (String)BigQueryHelpers.createJobIdToken((String)this.options.getJobName(), (String)stepUuid));
        Storage.CreateReadSessionRequest expectedRequest = Storage.CreateReadSessionRequest.newBuilder().setParent("projects/" + this.options.getProject()).setTableReference(BigQueryHelpers.toTableRefProto((TableReference)tempTableReference)).setRequestedStreams(1024).setUnknownFields(UnknownFieldSet.newBuilder().addField(7, UnknownFieldSet.Field.newBuilder().addVarint(2L).build()).build()).build();
        Storage.ReadSession.Builder builder = Storage.ReadSession.newBuilder();
        for (int i = 0; i < 1024; ++i) {
            builder.addStreams(Storage.Stream.newBuilder().setName("stream-" + i));
        }
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.createReadSession(expectedRequest)).thenReturn((Object)builder.build());
        BigQueryStorageQuerySource querySource = BigQueryStorageQuerySource.create((String)stepUuid, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)encodedQuery), (Boolean)true, (Boolean)true, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.BATCH, null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withJobService(this.fakeJobService).withStorageClient(fakeStorageClient));
        List sources = querySource.split(1024L, (PipelineOptions)this.options);
        Assert.assertEquals((long)1024L, (long)sources.size());
    }

    private static GenericRecord createRecord(String name, long number, Schema schema) {
        GenericData.Record genericRecord = new GenericData.Record(schema);
        genericRecord.put("name", (Object)name);
        genericRecord.put("number", (Object)number);
        return genericRecord;
    }

    private static Storage.ReadRowsResponse createResponse(Schema schema, Collection<GenericRecord> genericRecords) throws Exception {
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryEncoder binaryEncoder = ENCODER_FACTORY.binaryEncoder((OutputStream)outputStream, null);
        for (GenericRecord genericRecord : genericRecords) {
            writer.write((Object)genericRecord, (Encoder)binaryEncoder);
        }
        binaryEncoder.flush();
        return Storage.ReadRowsResponse.newBuilder().setAvroRows(AvroProto.AvroRows.newBuilder().setSerializedBinaryRows(ByteString.copyFrom((byte[])outputStream.toByteArray())).setRowCount((long)genericRecords.size())).build();
    }

    @Test
    public void testQuerySourceInitialSplit_EmptyResult() throws Exception {
        TableReference sourceTableRef = BigQueryHelpers.parseTableSpec((String)"project:dataset.table");
        this.fakeDatasetService.createDataset(sourceTableRef.getProjectId(), sourceTableRef.getDatasetId(), "asia-northeast1", "Fake plastic tree^H^H^H^Htables", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(sourceTableRef).setLocation("asia-northeast1"));
        Table queryResultTable = new Table().setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).setNumBytes(Long.valueOf(0L));
        String encodedQuery = FakeBigQueryServices.encodeQueryResult(queryResultTable);
        this.fakeJobService.expectDryRunQuery(this.options.getProject(), encodedQuery, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(0x100000L)).setReferencedTables((List)ImmutableList.of((Object)sourceTableRef))));
        String stepUuid = "testStepUuid";
        TableReference tempTableReference = BigQueryHelpers.createTempTableReference((String)this.options.getProject(), (String)BigQueryHelpers.createJobIdToken((String)this.options.getJobName(), (String)stepUuid));
        Storage.CreateReadSessionRequest expectedRequest = Storage.CreateReadSessionRequest.newBuilder().setParent("projects/" + this.options.getProject()).setTableReference(BigQueryHelpers.toTableRefProto((TableReference)tempTableReference)).setRequestedStreams(10).setUnknownFields(UnknownFieldSet.newBuilder().addField(7, UnknownFieldSet.Field.newBuilder().addVarint(2L).build()).build()).build();
        Storage.ReadSession emptyReadSession = Storage.ReadSession.newBuilder().build();
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class);
        Mockito.when((Object)fakeStorageClient.createReadSession(expectedRequest)).thenReturn((Object)emptyReadSession);
        BigQueryStorageQuerySource querySource = BigQueryStorageQuerySource.create((String)stepUuid, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)encodedQuery), (Boolean)true, (Boolean)true, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.BATCH, null, null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withJobService(this.fakeJobService).withStorageClient(fakeStorageClient));
        List sources = querySource.split(1024L, (PipelineOptions)this.options);
        Assert.assertTrue((boolean)sources.isEmpty());
    }

    @Test
    public void testQuerySourceCreateReader() throws Exception {
        BigQueryStorageQuerySource querySource = BigQueryStorageQuerySource.create((String)"testStepUuid", (ValueProvider)ValueProvider.StaticValueProvider.of((Object)"SELECT * FROM `dataset.table`"), (Boolean)false, (Boolean)false, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.INTERACTIVE, (String)"asia-northeast1", null, (SerializableFunction)new BigQueryIO.TableRowParser(), (Coder)TableRowJsonCoder.of(), (BigQueryServices)this.fakeBigQueryServices);
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("BigQuery storage source must be split before reading");
        querySource.createReader((PipelineOptions)this.options);
    }

    @Test
    public void testReadFromBigQueryIO() throws Exception {
        this.doReadFromBigQueryIO(false);
    }

    @Test
    public void testReadFromBigQueryIOWithTemplateCompatibility() throws Exception {
        this.doReadFromBigQueryIO(true);
    }

    private void doReadFromBigQueryIO(boolean templateCompatibility) throws Exception {
        TableReference sourceTableRef = BigQueryHelpers.parseTableSpec((String)"project:dataset.table");
        this.fakeDatasetService.createDataset(sourceTableRef.getProjectId(), sourceTableRef.getDatasetId(), "asia-northeast1", "Fake plastic tree^H^H^H^Htables", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(sourceTableRef).setLocation("asia-northeast1"));
        Table queryResultTable = new Table().setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).setNumBytes(Long.valueOf(0L));
        String encodedQuery = FakeBigQueryServices.encodeQueryResult(queryResultTable);
        this.fakeJobService.expectDryRunQuery(this.options.getProject(), encodedQuery, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(0x100000L)).setReferencedTables((List)ImmutableList.of((Object)sourceTableRef))));
        Storage.ReadSession readSession = Storage.ReadSession.newBuilder().setName("readSessionName").setAvroSchema(AvroProto.AvroSchema.newBuilder().setSchema(AVRO_SCHEMA_STRING)).addStreams(Storage.Stream.newBuilder().setName("streamName")).build();
        Storage.ReadRowsRequest expectedReadRowsRequest = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().setStream(Storage.Stream.newBuilder().setName("streamName"))).build();
        ArrayList records = Lists.newArrayList((Object[])new GenericRecord[]{BigQueryIOStorageQueryTest.createRecord("A", 1L, AVRO_SCHEMA), BigQueryIOStorageQueryTest.createRecord("B", 2L, AVRO_SCHEMA), BigQueryIOStorageQueryTest.createRecord("C", 3L, AVRO_SCHEMA), BigQueryIOStorageQueryTest.createRecord("D", 4L, AVRO_SCHEMA)});
        ArrayList readRowsResponses = Lists.newArrayList((Object[])new Storage.ReadRowsResponse[]{BigQueryIOStorageQueryTest.createResponse(AVRO_SCHEMA, records.subList(0, 2)), BigQueryIOStorageQueryTest.createResponse(AVRO_SCHEMA, records.subList(2, 4))});
        BigQueryServices.StorageClient fakeStorageClient = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServices.StorageClient.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)fakeStorageClient.createReadSession((Storage.CreateReadSessionRequest)Matchers.any())).thenReturn((Object)readSession);
        Mockito.when((Object)fakeStorageClient.readRows(expectedReadRowsRequest)).thenReturn(new FakeBigQueryServices.FakeBigQueryServerStream(readRowsResponses));
        BigQueryIO.TypedRead typedRead = BigQueryIO.read((SerializableFunction)new ParseKeyValue()).fromQuery(encodedQuery).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withTestServices((BigQueryServices)new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withJobService(this.fakeJobService).withStorageClient(fakeStorageClient));
        if (templateCompatibility) {
            typedRead = typedRead.withTemplateCompatibility();
        }
        PCollection output = (PCollection)this.p.apply((PTransform)typedRead);
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)"A", (Object)1L), (Object)KV.of((Object)"B", (Object)2L), (Object)KV.of((Object)"C", (Object)3L), (Object)KV.of((Object)"D", (Object)4L)));
        this.p.run();
    }

    private static final class ParseKeyValue
    implements SerializableFunction<SchemaAndRecord, KV<String, Long>> {
        private ParseKeyValue() {
        }

        public KV<String, Long> apply(SchemaAndRecord input) {
            return KV.of((Object)input.getRecord().get("name").toString(), (Object)((Long)input.getRecord().get("number")));
        }
    }
}

