/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryIOStorageQueryIT {
    private static final Map<String, Long> EXPECTED_NUM_RECORDS = ImmutableMap.of((Object)"empty", (Object)0L, (Object)"1M", (Object)10592L, (Object)"1G", (Object)11110839L, (Object)"1T", (Object)11110839000L);
    private static final String DATASET_ID = "big_query_storage";
    private static final String TABLE_PREFIX = "storage_read_";
    private BigQueryIOStorageQueryOptions options;

    private void setUpTestEnvironment(String tableSize) {
        PipelineOptionsFactory.register(BigQueryIOStorageQueryOptions.class);
        this.options = (BigQueryIOStorageQueryOptions)TestPipeline.testingPipelineOptions().as(BigQueryIOStorageQueryOptions.class);
        this.options.setNumRecords(EXPECTED_NUM_RECORDS.get(tableSize));
        String project = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
        this.options.setInputTable(project + '.' + DATASET_ID + '.' + TABLE_PREFIX + tableSize);
    }

    private void runBigQueryIOStorageQueryPipeline() {
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        PCollection count = (PCollection)((PCollection)p.apply("Query", (PTransform)BigQueryIO.read((SerializableFunction)BigQueryIO.TableRowParser.INSTANCE).fromQuery("SELECT * FROM `" + this.options.getInputTable() + "`").usingStandardSql().withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ))).apply("Count", Count.globally());
        PAssert.thatSingleton((PCollection)count).isEqualTo((Object)this.options.getNumRecords());
        p.run().waitUntilFinish();
    }

    @Test
    public void testBigQueryStorageQuery1G() throws Exception {
        this.setUpTestEnvironment("1G");
        this.runBigQueryIOStorageQueryPipeline();
    }

    public static interface BigQueryIOStorageQueryOptions
    extends TestPipelineOptions,
    ExperimentalOptions {
        @Description(value="The table to be queried")
        @Validation.Required
        public String getInputTable();

        public void setInputTable(String var1);

        @Description(value="The expected number of records")
        @Validation.Required
        public long getNumRecords();

        public void setNumRecords(long var1);
    }
}

