/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryIOReadIT {
    private BigQueryIOReadOptions options;
    private String project;
    private static final String datasetId = "big_query_import_export";
    private static final String tablePrefix = "export_";
    private static final Map<String, Long> numOfRecords = ImmutableMap.of((Object)"empty", (Object)0L, (Object)"1M", (Object)10592L, (Object)"1G", (Object)11110839L, (Object)"1T", (Object)11110839000L);

    private void setupTestEnvironment(String recordSize, boolean enableCustomBigquery) {
        PipelineOptionsFactory.register(BigQueryIOReadOptions.class);
        this.options = (BigQueryIOReadOptions)TestPipeline.testingPipelineOptions().as(BigQueryIOReadOptions.class);
        this.options.setNumRecords(numOfRecords.get(recordSize));
        this.options.setTempLocation(this.options.getTempRoot() + "/temp-it/");
        this.project = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
        this.options.setInputTable(this.project + ":" + datasetId + "." + tablePrefix + recordSize);
        if (enableCustomBigquery) {
            this.options.setExperiments((List)ImmutableList.of((Object)"enable_custom_bigquery_sink", (Object)"enable_custom_bigquery_source"));
        }
    }

    private void runBigQueryIOReadPipeline() {
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        PCollection count = (PCollection)((PCollection)p.apply("Read", (PTransform)BigQueryIO.read().from(this.options.getInputTable()))).apply("Count", Count.globally());
        PAssert.thatSingleton((PCollection)count).isEqualTo((Object)this.options.getNumRecords());
        p.run().waitUntilFinish();
    }

    @Test
    public void testBigQueryReadEmpty() throws Exception {
        this.setupTestEnvironment("empty", false);
        this.runBigQueryIOReadPipeline();
    }

    @Test
    public void testBigQueryRead1M() throws Exception {
        this.setupTestEnvironment("1M", false);
        this.runBigQueryIOReadPipeline();
    }

    @Test
    public void testBigQueryRead1G() throws Exception {
        this.setupTestEnvironment("1G", false);
        this.runBigQueryIOReadPipeline();
    }

    @Test
    public void testBigQueryRead1T() throws Exception {
        this.setupTestEnvironment("1T", false);
        this.runBigQueryIOReadPipeline();
    }

    @Test
    public void testBigQueryReadEmptyCustom() throws Exception {
        this.setupTestEnvironment("empty", true);
        this.runBigQueryIOReadPipeline();
    }

    @Test
    public void testBigQueryRead1TCustom() throws Exception {
        this.setupTestEnvironment("1T", true);
        this.runBigQueryIOReadPipeline();
    }

    public static interface BigQueryIOReadOptions
    extends TestPipelineOptions,
    ExperimentalOptions {
        @Description(value="The table to be read")
        @Validation.Required
        public String getInputTable();

        public void setInputTable(String var1);

        @Description(value="The expected number of records")
        @Validation.Required
        public long getNumRecords();

        public void setNumRecords(long var1);
    }
}

