/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.BatchReadOnlyTransaction;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;

class CreateTransactionFn
extends DoFn<Object, Transaction> {
    private final SpannerIO.CreateTransaction config;
    private transient SpannerAccessor spannerAccessor;

    CreateTransactionFn(SpannerIO.CreateTransaction config) {
        this.config = config;
    }

    @DoFn.Setup
    public void setup() throws Exception {
        this.spannerAccessor = this.config.getSpannerConfig().connectToSpanner();
    }

    @DoFn.Teardown
    public void teardown() throws Exception {
        this.spannerAccessor.close();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        BatchReadOnlyTransaction tx = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(this.config.getTimestampBound());
        c.output((Object)Transaction.create(tx.getBatchTransactionId()));
    }
}

