/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.RowFilter;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.range.ByteKeyRange;

final class AutoValue_BigtableIO_Read
extends BigtableIO.Read {
    private final BigtableConfig bigtableConfig;
    private final RowFilter rowFilter;
    private final List<ByteKeyRange> keyRanges;

    private AutoValue_BigtableIO_Read(BigtableConfig bigtableConfig, @Nullable RowFilter rowFilter, @Nullable List<ByteKeyRange> keyRanges) {
        this.bigtableConfig = bigtableConfig;
        this.rowFilter = rowFilter;
        this.keyRanges = keyRanges;
    }

    @Override
    BigtableConfig getBigtableConfig() {
        return this.bigtableConfig;
    }

    @Override
    @Nullable
    RowFilter getRowFilter() {
        return this.rowFilter;
    }

    @Override
    @Nullable
    public List<ByteKeyRange> getKeyRanges() {
        return this.keyRanges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigtableIO.Read) {
            BigtableIO.Read that = (BigtableIO.Read)((Object)o);
            return this.bigtableConfig.equals(that.getBigtableConfig()) && (this.rowFilter == null ? that.getRowFilter() == null : this.rowFilter.equals((Object)that.getRowFilter())) && (this.keyRanges == null ? that.getKeyRanges() == null : this.keyRanges.equals(that.getKeyRanges()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.bigtableConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowFilter == null ? 0 : this.rowFilter.hashCode();
        h$ *= 1000003;
        return h$ ^= this.keyRanges == null ? 0 : this.keyRanges.hashCode();
    }

    @Override
    BigtableIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends BigtableIO.Read.Builder {
        private BigtableConfig bigtableConfig;
        private RowFilter rowFilter;
        private List<ByteKeyRange> keyRanges;

        Builder() {
        }

        private Builder(BigtableIO.Read source) {
            this.bigtableConfig = source.getBigtableConfig();
            this.rowFilter = source.getRowFilter();
            this.keyRanges = source.getKeyRanges();
        }

        @Override
        BigtableIO.Read.Builder setBigtableConfig(BigtableConfig bigtableConfig) {
            if (bigtableConfig == null) {
                throw new NullPointerException("Null bigtableConfig");
            }
            this.bigtableConfig = bigtableConfig;
            return this;
        }

        @Override
        BigtableIO.Read.Builder setRowFilter(RowFilter rowFilter) {
            this.rowFilter = rowFilter;
            return this;
        }

        @Override
        BigtableIO.Read.Builder setKeyRanges(List<ByteKeyRange> keyRanges) {
            this.keyRanges = keyRanges;
            return this;
        }

        @Override
        BigtableIO.Read build() {
            String missing = "";
            if (this.bigtableConfig == null) {
                missing = missing + " bigtableConfig";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigtableIO_Read(this.bigtableConfig, this.rowFilter, this.keyRanges);
        }
    }
}

