/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import java.io.Serializable;
import java.util.Set;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableSet;

public abstract class InsertRetryPolicy
implements Serializable {
    static final Set<String> PERSISTENT_ERRORS = ImmutableSet.of((Object)"invalid", (Object)"invalidQuery", (Object)"notImplemented");

    public abstract boolean shouldRetry(Context var1);

    public static InsertRetryPolicy neverRetry() {
        return new InsertRetryPolicy(){

            @Override
            public boolean shouldRetry(Context context) {
                return false;
            }
        };
    }

    public static InsertRetryPolicy alwaysRetry() {
        return new InsertRetryPolicy(){

            @Override
            public boolean shouldRetry(Context context) {
                return true;
            }
        };
    }

    public static InsertRetryPolicy retryTransientErrors() {
        return new InsertRetryPolicy(){

            @Override
            public boolean shouldRetry(Context context) {
                if (context.errors.getErrors() != null) {
                    for (ErrorProto error : context.errors.getErrors()) {
                        if (error.getReason() == null || !PERSISTENT_ERRORS.contains(error.getReason())) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static class Context {
        TableDataInsertAllResponse.InsertErrors errors;

        public Context(TableDataInsertAllResponse.InsertErrors errors) {
            this.errors = errors;
        }
    }
}

