/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.transforms.DoFn;

abstract class AbstractSpannerFn<InputT, OutputT>
extends DoFn<InputT, OutputT> {
    private transient Spanner spanner;
    private transient DatabaseClient databaseClient;

    AbstractSpannerFn() {
    }

    abstract SpannerConfig getSpannerConfig();

    @DoFn.Setup
    public void setup() throws Exception {
        SpannerConfig spannerConfig = this.getSpannerConfig();
        SpannerOptions options = spannerConfig.buildSpannerOptions();
        this.spanner = (Spanner)options.getService();
        this.databaseClient = this.spanner.getDatabaseClient(DatabaseId.of((String)options.getProjectId(), (String)((String)spannerConfig.getInstanceId().get()), (String)((String)spannerConfig.getDatabaseId().get())));
    }

    @DoFn.Teardown
    public void teardown() throws Exception {
        if (this.spanner == null) {
            return;
        }
        this.spanner.close();
        this.spanner = null;
    }

    protected DatabaseClient databaseClient() {
        return this.databaseClient;
    }
}

