/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.ShardedKey;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteTables<DestinationT>
extends DoFn<KV<ShardedKey<DestinationT>, List<String>>, KV<TableDestination, String>> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteTables.class);
    private final boolean singlePartition;
    private final BigQueryServices bqServices;
    private final PCollectionView<String> jobIdToken;
    private final PCollectionView<Map<DestinationT, String>> schemasView;
    private final BigQueryIO.Write.WriteDisposition writeDisposition;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;

    public WriteTables(boolean singlePartition, BigQueryServices bqServices, PCollectionView<String> jobIdToken, PCollectionView<Map<DestinationT, String>> schemasView, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, DynamicDestinations<?, DestinationT> dynamicDestinations) {
        this.singlePartition = singlePartition;
        this.bqServices = bqServices;
        this.jobIdToken = jobIdToken;
        this.schemasView = schemasView;
        this.writeDisposition = writeDisposition;
        this.createDisposition = createDisposition;
        this.dynamicDestinations = dynamicDestinations;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
        Object destination = ((ShardedKey)((KV)c.element()).getKey()).getKey();
        TableSchema tableSchema = BigQueryHelpers.fromJsonString((String)((Map)c.sideInput(this.schemasView)).get(destination), TableSchema.class);
        TableDestination tableDestination = this.dynamicDestinations.getTable(destination);
        TableReference tableReference = tableDestination.getTableReference();
        if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
            tableReference.setProjectId(((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)).getProject());
            tableDestination = new TableDestination(tableReference, tableDestination.getTableDescription());
        }
        Integer partition = ((ShardedKey)((KV)c.element()).getKey()).getShardNumber();
        ArrayList partitionFiles = Lists.newArrayList((Iterable)((Iterable)((KV)c.element()).getValue()));
        String jobIdPrefix = BigQueryHelpers.createJobId((String)c.sideInput(this.jobIdToken), tableDestination, partition);
        if (!this.singlePartition) {
            tableReference.setTableId(jobIdPrefix);
        }
        this.load(this.bqServices.getJobService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, tableReference, tableSchema, partitionFiles, this.writeDisposition, this.createDisposition, tableDestination.getTableDescription());
        c.output((Object)KV.of((Object)tableDestination, (Object)BigQueryHelpers.toJsonString(tableReference)));
        WriteTables.removeTemporaryFiles(partitionFiles);
    }

    private void load(BigQueryServices.JobService jobService, BigQueryServices.DatasetService datasetService, String jobIdPrefix, TableReference ref, @Nullable TableSchema schema, List<String> gcsUris, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, @Nullable String tableDescription) throws InterruptedException, IOException {
        JobConfigurationLoad loadConfig = new JobConfigurationLoad().setDestinationTable(ref).setSchema(schema).setSourceUris(gcsUris).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name()).setSourceFormat("NEWLINE_DELIMITED_JSON");
        String projectId = ref.getProjectId();
        Job lastFailedLoadJob = null;
        block5: for (int i = 0; i < 3; ++i) {
            String jobId = jobIdPrefix + "-" + i;
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId);
            jobService.startLoadJob(jobRef, loadConfig);
            Job loadJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
            BigQueryHelpers.Status jobStatus = BigQueryHelpers.parseStatus(loadJob);
            switch (jobStatus) {
                case SUCCEEDED: {
                    if (tableDescription != null) {
                        datasetService.patchTableDescription(ref, tableDescription);
                    }
                    return;
                }
                case UNKNOWN: {
                    throw new RuntimeException(String.format("UNKNOWN status of load job [%s]: %s.", jobId, BigQueryHelpers.jobToPrettyString(loadJob)));
                }
                case FAILED: {
                    lastFailedLoadJob = loadJob;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected status [%s] of load job: %s.", new Object[]{jobStatus, BigQueryHelpers.jobToPrettyString(loadJob)}));
                }
            }
        }
        throw new RuntimeException(String.format("Failed to create load job with id prefix %s, reached max retries: %d, last failed load job: %s.", jobIdPrefix, 3, BigQueryHelpers.jobToPrettyString(lastFailedLoadJob)));
    }

    static void removeTemporaryFiles(Collection<String> files) throws IOException {
        ImmutableList.Builder fileResources = ImmutableList.builder();
        for (String file : files) {
            fileResources.add((Object)FileSystems.matchNewResource((String)file, (boolean)false));
        }
        FileSystems.delete((Collection)fileResources.build(), (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
    }
}

