/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class CreateTables<DestinationT>
extends PTransform<PCollection<KV<DestinationT, TableRow>>, PCollection<KV<TableDestination, TableRow>>> {
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final BigQueryServices bqServices;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private static Set<String> createdTables = Collections.newSetFromMap(new ConcurrentHashMap());

    public CreateTables(BigQueryIO.Write.CreateDisposition createDisposition, DynamicDestinations<?, DestinationT> dynamicDestinations) {
        this(createDisposition, new BigQueryServicesImpl(), dynamicDestinations);
    }

    private CreateTables(BigQueryIO.Write.CreateDisposition createDisposition, BigQueryServices bqServices, DynamicDestinations<?, DestinationT> dynamicDestinations) {
        this.createDisposition = createDisposition;
        this.bqServices = bqServices;
        this.dynamicDestinations = dynamicDestinations;
    }

    CreateTables<DestinationT> withTestServices(BigQueryServices bqServices) {
        return new CreateTables<DestinationT>(this.createDisposition, bqServices, this.dynamicDestinations);
    }

    public PCollection<KV<TableDestination, TableRow>> expand(PCollection<KV<DestinationT, TableRow>> input) {
        ArrayList sideInputs = Lists.newArrayList();
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<DestinationT, TableRow>, KV<TableDestination, TableRow>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws InterruptedException, IOException {
                CreateTables.this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
                TableDestination tableDestination = CreateTables.this.dynamicDestinations.getTable(((KV)context.element()).getKey());
                TableReference tableReference = tableDestination.getTableReference();
                if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
                    tableReference.setProjectId(((BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class)).getProject());
                    tableDestination = new TableDestination(tableReference, tableDestination.getTableDescription());
                }
                TableSchema tableSchema = CreateTables.this.dynamicDestinations.getSchema(((KV)context.element()).getKey());
                BigQueryOptions options = (BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class);
                CreateTables.this.possibleCreateTable(options, tableDestination, tableSchema);
                context.output((Object)KV.of((Object)tableDestination, (Object)((KV)context.element()).getValue()));
            }
        }).withSideInputs((Iterable)sideInputs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void possibleCreateTable(BigQueryOptions options, TableDestination tableDestination, TableSchema tableSchema) throws InterruptedException, IOException {
        String tableSpec = tableDestination.getTableSpec();
        TableReference tableReference = tableDestination.getTableReference();
        String tableDescription = tableDestination.getTableDescription();
        if (this.createDisposition != BigQueryIO.Write.CreateDisposition.CREATE_NEVER && !createdTables.contains(tableSpec)) {
            Set<String> set = createdTables;
            synchronized (set) {
                BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(options);
                if (!createdTables.contains(tableSpec)) {
                    if (datasetService.getTable(tableReference) == null) {
                        datasetService.createTable(new Table().setTableReference(tableReference).setSchema(tableSchema).setDescription(tableDescription));
                    }
                    createdTables.add(tableSpec);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearCreatedTables() {
        Set<String> set = createdTables;
        synchronized (set) {
            createdTables.clear();
        }
    }
}

